<?php namespace App\Commands;

use App\Commands\Command;
use Log;
use Queue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Bus\SelfHandling;
use Illuminate\Contracts\Queue\ShouldBeQueued;

class SendSMS extends Command implements  ShouldBeQueued {

	use InteractsWithQueue, SerializesModels;

	public $SenderID;
	public $MessageType;
	public $Message;
	public $File;
	public $SMSAPI;
	
	public function __construct($SenderID,$MessageType,$Message,$File,$SMSAPI)
	{
		$this->SenderID=$SenderID;
		$this->MessageType=$MessageType;
		$this->Message=$Message;
		$this->File=$File;
		$this->SMSAPI=$SMSAPI;
	}

	/**
     * Execute the command.
     *
     * @return void
     */

    public function handle()
    {
    	 event(new SendSMSHandler($this->SenderID,$this->MessageType,$this->Message,$this->File,$this->SMSAPI));
    }
}
