<?php namespace App\Http\Controllers;
use App\state;
use App\zone;
use App\district;
use App\tehsil;
use App\village;
use App\booth;
use App\prabhag;
use App\city;
use App\voter;
use App\cast;
use App\androidapp;
use App\androidappusers;
use DB;
use App\appusersvoters;
use Validator;
use illuminate\Http\Request;
use illuminate\Routing\Controllers;
class AndroidAppController extends Controller {

	public function index() // New Android Users
	{
		$Districts=district::where('Status', '=', 1)->get();

		$data=array("pagetitle" => " नवीन कार्यकर्ता  ","Districts"=>$Districts);
		return view('admin.new_android_app',$data);
	}

	public function add_new_app()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Casts=cast::where("CastId",">",0)->get();
		$Types=DB::select("select * from tbltype");
		$data=array("pagetitle" => " नवीन कार्यकर्ता  ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Casts"=>$Casts,"Types"=>$Types);

		//$data=array("pagetitle" => " नवीन कार्यकर्ता  ","Districts"=>$Districts);

		return view('admin.new_android_app',$data);
	}

	public function edit_app()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();

		$AppUsers=DB::select("select * from tblandroidappusers Order by Name ASC ");  //androidapp::where("Status","=",1)->get();

		$Casts=cast::where("CastId",">",0)->get();
		$Types=DB::select("select * from tbltype");
		$data=array("pagetitle" => "  बदल करा  ","AppUsers"=>$AppUsers,"DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Casts"=>$Casts,"Types"=>$Types);

		return view('admin.edit_android_app',$data);
	}

	// App User Dashboard
	public function android_app_users_dashboard()
	{
		$data=array("pagetitle" => "  कार्यकर्ता डॅशबोर्ड   ");
		return view('admin.android_app_users_dashboard',$data);
	}

	public function CreateAppUser(Request $request)
	{
		$DOB="";
		if($request->DOB!="" || $request->DOB!="00-00-0000")
		{
			$DOB = date("Y-m-d", strtotime($request->DOB));
		}

		$validator = Validator::make(
		array(
				"AndroidAppName" => $request->AndroidAppName,
				"MobileNumber" => $request->MobileNumber
		),
		array(
			"AndroidAppName"=> "required",
			"MobileNumber"=> "required | max:10 | min:10 "
		));

		if($validator->fails())
		{
			// redirect Validation Errors
			return redirect("/add-new-app")->withErrors($validator)->withInput();
		}
		else
		{
			$City_VillageID="";
			// Successfully Valid entries
			$IsCity=1;
			
			
			// Check Mobile Number Exists

			$ChkExists=androidapp::where('MobileNumber', '=',$request->MobileNumber)->get();
			if(count($ChkExists)==1)
			{
				// Already Exists Mobile Number
				return redirect("/add-new-app")->withErrors($validator)->withInput()->with("error","Mobile Number is Already Exists");
			}
			else
			{
				$AndroidApp=new androidapp;
				$AndroidApp->Name=$request->AndroidAppName;
				$AndroidApp->Status=1;
				$AndroidApp->MobileNumber=$request->MobileNumber;
				$AndroidApp->Email=$request->Email;
				$AndroidApp->Address=$request->Address;
				$AndroidApp->WhatsAppNumber=$request->WhatsappNumber;
				$AndroidApp->DateOfBirth=$DOB;
				$AndroidApp->InUse=0;
				$AndroidApp->Status=1;
				$AndroidApp->AccessLevel=1;
				$AndroidApp->IsCity=$IsCity;
				$AndroidApp->Village_City_Prabhag_BoothID=1;
				$AndroidApp->BloodGroup=$request->BloodGroup;
				$AndroidApp->CastID=$request->Cast;
				$AndroidApp->Type=$request->TypeE;
				$AndroidApp->save();
				$insertedId = $AndroidApp->id;
				if($insertedId>0)
				{
					return redirect("/add-new-app")->withErrors($validator)->withInput()->with("success"," कार्यकर्ता माहिती जतन केली!!! ");
				}
				else
				{
					return redirect("/add-new-app")->with("error"," कार्यकर्ता माहिती जतन केली नाही.");
				}
			}
		}
	}

	public function InstantEditApp(Request $request)
	{
		/*
		 data:"ID="+ID+"&Name="+AndroidAppNames+"&MobileNumber="+MobileNumbers+"&Address="+Addresss+"&DOB="+DOBs
            +"&WhatsappNumber="+WhatsappNumbers+"&Email="+Emails+"&BloodGroup="+BloodGroups+"&
            Cast="+Castss1,
		*/
        $AppUserID=$request->ID;
        $Name=$request->Name;
        $MobileNumber=$request->MobileNumber;
        $WhatsappNumber=$request->WhatsappNumber;
        $Address=$request->Address;
        $Email=$request->Email;
        $BloodGroup=$request->BloodGroup;
        $Cast=$request->Cast;
        $DOB=$request->DOB;
        $Type=$request->Type;

        $Reply=array();
        if($Name!="" && $MobileNumber!="")
        {
        	$Number="";$MobileNumberRec=0;
			$MobNo=DB::select("select MobileNumber from tblandroidappusers where AppUserID=$AppUserID");
			foreach ($MobNo as $key => $val) {
				$Number=$val->MobileNumber;
			}

			$Num=0;
			if($Number!=$request->MobileNumber)
			{
				$MobileNumberRec=androidapp::where("MobileNumber","=",$MobileNumber)->get();
				$Num=count($MobileNumberRec);
			}

			if($Num==0)
			{
				$affectedRows = androidapp::where('AppUserID', '=', $AppUserID)->update(["Name"=>$Name,
					"MobileNumber"=>$MobileNumber,"Email"=>$Email,"Address"=>$Address,"WhatsAppNumber"=>$WhatsappNumber,
					"DateOfBirth"=>$DOB,"BloodGroup"=>$BloodGroup,"CastID"=>$Cast,"Type"=>$Type]);
				if($affectedRows==1)
				{
					//return redirect("/edit-app")->with("success"," कार्यकर्ता माहितीत बदल केला  !! ");
					$Reply['Message']=" कार्यकर्ता माहितीत बदल केला  !!";
				}
				else
				{
					$Reply['Message']=" कार्यकर्ता माहितीत बदल केला नाही  !!";
					//return redirect("/edit-app")->with("error","  कार्यकर्ता माहितीत बदल केला नाही  !! ");
				}
			}
			else
			{
				$Reply['Message']=" Mobile Number ".$MobileNumber." used by Other Android App. Please Try Different !!";
			}
        }
        else
        {
			$Reply['Message']=" Name and Mobile Number must not empty";
        }
        echo json_encode($Reply);
	}

	public function LoadTypes()
	{
		$Types=DB::select("select * from tbltype");
		echo json_encode($Types);
	}

	public function EditAppUser(Request $request)
	{
		$DOB = "";
		if($request->DOB!="")
		{
			$DOB = date("Y-m-d", strtotime($request->DOB));
		}
		else
		{
			$DOB = "";
		}

		$validator= Validator::make(
			array(
				"AndroidAppName"=>$request->AndroidAppName,
				"MobileNumber"=>$request->MobileNumber,
				"AndroidAppUser"=>$request->AndroidAppUser
				),
			array(
				"AndroidAppName"=>"required",
				"MobileNumber"=>"required | min:10",
				"AndroidAppUser"=>"required"
				)
			);
		if($validator->fails()) // if
		{
			return redirect("/edit-app")->withErrors($validator)->withInput();
		}
		else
		{
			// Update App User Name
			// Check Mobile Number is already used by Android App Or Not
			$UseID=$request->AndroidAppUser;
			$Number="";$MobileNumberRec=0;
			$MobNo=DB::select("select MobileNumber from tblandroidappusers where AppUserID=$UseID");
			foreach ($MobNo as $key => $val) {
				$Number=$val->MobileNumber;
			}

			$Num=0;
			if($Number!=$request->MobileNumber)
			{
				$MobileNumberRec=androidapp::where("MobileNumber","=",$request->MobileNumber)->get();
				$Num=count($MobileNumberRec);
			}

			if($Num==0)
			{
				$affectedRows = androidapp::where('AppUserID', '=', $request->AndroidAppUser)->update(["Name"=>$request->AndroidAppName,"MobileNumber"=>$request->MobileNumber,"Email"=>$request->Email,"Address"=>$request->Address,"WhatsAppNumber"=>$request->WhatsappNumber,"DateOfBirth"=>$DOB,"BloodGroup"=>$request->BloodGroup,"CastID"=>$request->Cast,"Type"=>$request->TypeE]);
				if($affectedRows==1)
				{
					return redirect("/edit-app")->with("success"," कार्यकर्ता माहितीत बदल केला  !! ");
				}
				else
				{
					return redirect("/edit-app")->with("error","  कार्यकर्ता माहितीत बदल केला नाही  !! ");
				}
			}
			else
			{
				return redirect("/edit-app")->with("error"," Mobile Number ".$request->MobileNumber." used by Other Android App. Please Try Different !! ")->withInput();
			}
		}
	}

	// Get App Users from booth
	public function getAppsOfBooth(Request $request)
	{
		$BoothId=$request->BoothId;
		$Query="";
		if($request->BoothId!=0)
		{
			$androidappusers = DB::select("select * from tblandroidappusers,tblbooth where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblandroidappusers.Village_City_Prabhag_BoothID=$BoothId");
			echo json_encode($androidappusers);
		}
	}
	// GET Apps From Village or City

	public function getAppsFromCityOrVillage(Request $request)
	{
		$CityOrVillage=$request->CityOrVillage;
		$IsCity=$request->IsCity;	
		$Query="";
		if($IsCity==0)
		{
			$Query="select * from tblandroidappusers,tblvillage where tblandroidappusers.Village_City_Prabhag_BoothID=tblvillage.VillageID and tblandroidappusers.Village_City_Prabhag_BoothID=$CityOrVillage";
		}
		else if($IsCity==1)
		{
			$Query="select * from tblandroidappusers,tblcity where tblandroidappusers.Village_City_Prabhag_BoothID=tblcity.CityID and tblandroidappusers.Village_City_Prabhag_BoothID=$CityOrVillage";
		}
		$androidappusers = DB::select($Query);
		echo json_encode($androidappusers);
	}

	// Get App Details By AppUserId

	public function getAppDetailsById(Request $request)
	{
		$AppUserID=$request->AppUserID;
		$Reply=array();
		if($request->AppUserID!=0)
		{
			$androidappusers = androidapp::where("AppUserID","=",$AppUserID)->get();
			$i=0;
			foreach ($androidappusers as $key => $value) {
				$Reply[$i]['Name']=$value->Name;
				$Reply[$i]['MobileNumber']=$value->MobileNumber;
				$Reply[$i]['AppUserID']=$value->AppUserID;
				$Reply[$i]['InUse']=$value->InUse;
				$Reply[$i]['Status']=$value->Status;
				$Reply[$i]['ActivationDate']=$value->ActivationDate;
				$Reply[$i]['DeactivationDate']=$value->DeactivationDate;
				$Reply[$i]['IMEINumber']=$value->IMEINumber;
				$Reply[$i]['LastOTP']=$value->LastOTP;
				$Reply[$i]['AccessLevel']=$value->AccessLevel;
				$Reply[$i]['Village_City_Prabhag_BoothID']=$value->Village_City_Prabhag_BoothID;
				$Reply[$i]['IsCity']=$value->IsCity;
				$Reply[$i]['Type']=$value->Type;
				//  Get DistrictID, TehsilID,CityID Or Village
				$DistrictName="";$TehsilName="";$City_VillageName="";
				if($value->IsCity==1)
				{
					$GetInfo=DB::select("select CityName,TehsilName,DistrictName from tblcity,tbltehsil,tbldistrict where tblcity.TehsilID=tbltehsil.TehsilID and tbltehsil.DistrictID=tbldistrict.DistrictID and tblcity.CityID=".$value->Village_City_Prabhag_BoothID);
					foreach ($GetInfo as $key => $valu) {
						$DistrictName=$valu->DistrictName;
						$TehsilName=$valu->TehsilName;
						$City_VillageName=$valu->CityName;	
					}
				}
				else if($value->IsCity==0)
				{
					$GetInfo=DB::select("select VillageName,TehsilName,DistrictName from tblvillage,tbltehsil,tbldistrict where tblvillage.TehsilID=tbltehsil.TehsilID and tbltehsil.DistrictID=tbldistrict.DistrictID and tblvillage.VillageID=".$value->Village_City_Prabhag_BoothID);
					foreach ($GetInfo as $key => $val) {
						$DistrictName=$val->DistrictName;
						$TehsilName=$val->TehsilName;
						$City_VillageName=$val->VillageName;	
					}
				}
				$Reply[$i]['CastId']=$value->CastID;
				$CastName="";
				$Castss=cast::where("CastID","=",$value->CastID)->get();
				foreach ($Castss as $key => $valss) {
					# code...
					$CastName=$valss->CastName;
				}
				$Reply[$i]['CastName']=$CastName;
				$Reply[$i]['BloodGroup']=$value->BloodGroup;
				$Reply[$i]['City_VillageName']=$City_VillageName;
				$Reply[$i]['TehsilName']=$TehsilName;
				$Reply[$i]['DistrictName']=$DistrictName;

				$Reply[$i]['Email']=$value->Email;
				$Reply[$i]['Address']=$value->Address;
				$Reply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				if($value->DateOfBirth=="0000-00-00")
				{
					$Reply[$i]['DateOfBirth']="";
				}
				else
				{
					$Reply[$i]['DateOfBirth']=$value->DateOfBirth;					
				}
				$i++;
			}
			echo json_encode($Reply);
		}
	}

	// Load Delete App 
	public function delete_android_app()
	{
		$AppUsers=DB::select("select * from tblandroidappusers Order by Name ASC "); //androidapp::all();
		$Casts=cast::all();
		$Types=DB::select("select * from tbltype");
		$data=array("pagetitle" => " काढून टाका  ","AppUsers"=>$AppUsers,"Casts"=>$Casts,"Types"=>$Types);
		return view('admin.delete_android_app',$data);
	}

	// Get BoothNumber By BoothId

	public function getBoothDetailsById(Request $request)
	{
		$BoothId=$request->BoothId;
		if($request->BoothId!=0)
		{
			$BoothNumbers = booth::where("BoothID","=",$BoothId)->get();
			echo json_encode($BoothNumbers);
		}
	}

	// Delete App
	public function DeleteApp(Request $request)
	{
		$validator=Validator::make(
			array(
				"AndroidAppUser"=>$request->AndroidAppUser
				),
			array("AndroidAppUser"=>"required")
			);
		if($validator->fails())
		{
			// redirect back 
			return redirect("/delete-app")->withErrors($validator)->withInput();
		}
		else
		{
			// Delete App User
			$aff_row=androidapp::where('AppUserID', '=', $request->AndroidAppUser)->delete();
			if($aff_row==1)
			{
          		return redirect("/delete-app")->withErrors($validator)->withInput()->with("success","App is Successfully Deleted");
			}
			else
			{
				return redirect("/delete-app")->withErrors($validator)->withInput()->with("error","App is not Deleted");
			}
		}
	}

	// Load Enable App blade
	public function enable_android_app()
	{
		// Get All App Users
		$Casts=cast::all();
		$AndroidAppUsers=DB::select("select * from tblandroidappusers Order by Name ASC ");//androidapp::where("Status","=",0)->get();
		$data=array("pagetitle" => "कार्यकर्ता अनब्लॉक करा  ","AppUsers"=>$AndroidAppUsers,"Casts"=>$Casts);

		return view('admin.enable_android_app',$data);
	}	

	// Load Enable App blade
	public function EnableApp(Request $request)
	{
		$validator=Validator::make(
			array(
				"AndroidAppUser"=>$request->AndroidAppUser
				),
			array("AndroidAppUser"=>"required")
			);
		if($validator->fails())
		{
			// redirect back 
			return redirect("/enable-app")->withErrors($validator)->withInput();
		}
		else
		{
			// Enable App User
			$affectedRow=androidapp::where('AppUserID', '=', $request->AndroidAppUser)->update(["Status"=>1]);
			if($affectedRow==1)
			{
				return redirect("/enable-app")->with("success","Android App is Successfully Enabled! ")->withInput();
			}
			else
			{
				return redirect("/enable-app")->with("error"," Android App is Not Enabled !! ")->withInput();
			}
		}	
	}		

	// Load Disable App
	public function disable_android_app()
	{
		$Casts=cast::all();
		$AndroidAppUsers=DB::select("select * from tblandroidappusers Order by Name ASC ");//androidapp::where("Status","=",1)->get();
		$data=array("pagetitle" => " कार्यकर्ता ब्लॉक करा  ","AppUsers"=>$AndroidAppUsers,"Casts"=>$Casts);

		return view('admin.disable_android_app',$data);
	}

	// Disable App
	public function DisableApp(Request $request)
	{
		$validator=Validator::make(
			array(
				"AndroidAppUser"=>$request->AndroidAppUser
				),
			array("AndroidAppUser"=>"required")
			);
		if($validator->fails())
		{
			// redirect back 
			return redirect("/disable-app")->withErrors($validator)->withInput();
		}
		else
		{
			// Enable App User
			$affectedRow=androidapp::where('AppUserID', '=', $request->AndroidAppUser)->update(["Status"=>0]);
			if($affectedRow==1)
			{
				return redirect("/disable-app")->with("success","Android App is Successfully Disabled! ")->withInput();
			}
			else
			{
				return redirect("/disable-app")->with("error"," Android App is Not Disable !! ")->withInput();
			}
		}	
	}

	public function manage_app_voters()
	{
		$AndroidAppUsers=DB::select("select * from tblandroidappusers Order by Name ASC ");//androidapp::where("Status","=",1)->get();

		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			//$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => " मतदार व्यावस्थापन  ","AppUsers"=>$AndroidAppUsers,"DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths);

		return view('admin.voter_assignment_for_app',$data);
	}

	function RemoveAppVoters(Request $request)
	{
		$AppUserID=$request->AppUserID;
		$VoterID=$request->VoterID;
		$Message="";
		$Reply=array();
		if($AppUserID!="" && $VoterID!="")
		{
			$whereArray = array('AppUserId' => $AppUserID,'VoterId' => $VoterID);

			$query = DB::table('tblandroiduservoters');
			foreach($whereArray as $field => $value) {
			    $query->where($field, $value);
			}
			$affectedRow=$query->delete();

			//=DB::table('tblandroiduservoters')->where(['AppUserId', '=', $AppUserID],[" VoterId",'=',$VoterID])->delete();
			if($affectedRow==1)
			{
				$Message=" कार्यकर्त्याला जोडलेला मतदार काढून टाकला ";
			}
			else
			{
				$Message=" कृपया पुन्हा प्रयत्न करा ";
			}
		}
		else
		{
			$Message=" कृपया कार्यकर्ता किंवा मतदार निवडा ";
		}
		$Reply['Message']=$Message;
		echo json_encode($Reply);
	}

	// Get All StateName, ZoneName, DistrictName, TehsilName,City or Village , Booth and All Contactcs From Booth and is Access Level Village or City load Contact from that 

	public function GetAllInfoOfAppUser(Request $request)
	{
		
		$AppUserID=$request->AppUserId;
		$AppInfo=androidapp::where("AppUserID","=",$AppUserID)->get();
		$IsCity=-1;
		$BoothId=-1;
		$AcccessLevel=-1;

		foreach ($AppInfo as $key => $value) {
			$IsCity=$value->IsCity;
			$AcccessLevel=$value->AccessLevel;
			$BoothId=$value->Village_City_Prabhag_BoothID;
		}
		// Get VillageId_City_Id

		$Village_City_Id=-1;

		$BoothNumber="";$Village_City_ID=-1;

		if($AcccessLevel==1)
		{
			$Village_City_ID=$BoothId;
			$BoothNumber="";	
		}
		else if($AcccessLevel==2)
		{
			$Booth=booth::where("BoothID","=",$BoothId)->get();			
			foreach ($Booth as $key => $value) {
				$Village_City_ID=$value->Village_City_ID;
				$BoothNumber=$value->BoothNumber;
			}			
		}
		// Get TehsilId
		$TehsilId=-1;$Village_City_Name="";
		$TehsilName="";
		if($IsCity==0)  // Load TehsilId from Village
		{
			//echo "Village ID : $Village_City_ID ---";
			$Names=village::where("VillageID","=",$Village_City_ID)->get();
			//echo json_encode($Names);
			foreach ($Names as $key => $value) {
				$TehsilId=$value->TehsilID;
				$Village_City_Name=$value->VillageName;
				//echo "Tehsil ID - ".$TehsilId;
			}
		//	echo json_encode($Names);
		}
		else if($IsCity==1) // Load TehsilId from City
		{
			$Names=city::where("CityID","=",$Village_City_ID)->get();
			foreach ($Names as $key => $value) {
				$TehsilId=$value->TehsilID;
				$Village_City_Name=$value->CityName;
			}
		}

		//Get Tehsil Name
		$TehsilName="";$DistrictId=-1;$ZoneId=-1;$StateId=-1;
		$Names=tehsil::where("TehsilID","=",$TehsilId)->get();
		foreach ($Names as $key => $value) {
			$TehsilName=$value->TehsilName;
			$DistrictId=$value->DistrictID;
		}

		$DistrictName="";
		$Names=district::where("DistrictID","=",$DistrictId)->get();
		foreach ($Names as $key => $value) {
			$DistrictName=$value->DistrictName;
			$ZoneId=$value->ZoneID;
		}
		$ZoneName="";
		$Names=zone::where("ZoneID","=",$ZoneId)->get();
		foreach ($Names as $key => $value) {
			$ZoneName=$value->ZoneName;
			$StateId=$value->StateID;
		}

		$StateName="";
		$StateNames=state::where("StateID","=",$StateId)->get();
		foreach ($StateNames as $key => $value) {
			$StateName=$value->StateName;
		}
		// Select All City Or Village From Tehsil
	
		$Reply=array();
		// Print

		$Reply['SelectedState']=$StateName;
		$Reply['SelectedZone']=$ZoneName;
		$Reply['SelectedDistrict']=$DistrictName;
		$Reply['SelectedTehsil']=$TehsilName;
		$Reply['IsCity']=$IsCity;
		$Reply['SelectVillage_City_ID']=$Village_City_Name;
		$Reply['SelectBoothId']=$BoothId;
		$Reply['SelectBoothNumber']=$BoothNumber;
		//$Reply['Booths']=$Booths;
		if($AcccessLevel==2)
		{
			$Reply['AccessLevelMessage']="This App Has Booth Level Access";
		}
		else if($AcccessLevel=1)
		{
			if($IsCity==1)
			{
				$Reply['AccessLevelMessage']="This App Has City Level Access";
			}
			else
			{
				$Reply['AccessLevelMessage']="This App Has Village Level Access";				
			}
		}
		$Reply['AccessLevel']=$AcccessLevel;

		echo json_encode($Reply);
	}
	// Get All Contacts of App USers By Access Levels
	public function GetAllContactsByAppUser(Request $request)
	{
		// Get All Contacts Assigned To User And Not Assigned to Users from Village or City
		//	header('application/json;charset=utf-8');
		$AppUserID=$request->AppUserId;
		//$AssignedVoters=voters::
		$AssignedVoters=DB::select("SELECT distinct * FROM `tblvoters`,tblandroiduservoters where tblvoters.VoterID = tblandroiduservoters.VoterID and `tblandroiduservoters`.AppUserId=$AppUserID");
		$Stored=array();$i=0;

		foreach ($AssignedVoters as $key => $value) {
			$SrNo=$value->VoterID;
			$Stored[$i]['Remove']="<input type='checkbox' name='Remove_".$i."' id='Remove_".$i."' value='".$SrNo."' onclick='UnselectAllAssigned(".$i.")'></input>";
			$Stored[$i]['SrNo']=$value->VoterID;
			$Stored[$i]['MarathiName']=$value->MarathiLastName ." ". $value->MarathiFirstName  ." ".$value->MarathiMiddleName;
			$Stored[$i]['Address']=$value->Address;
			$Stored[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";			
			if($value->Sex=="M")
			{
				$Stored[$i]['Sex']="पुरुष";	
			}
			else if($value->Sex=="F")
			{
				$Stored[$i]['Sex']="स्त्री";	
			}
			$Stored[$i]['EditVoter']="<a  href='#' onclick='ChangeVotingInformation(".$value->VoterID.")'> <i class='fa fa-pencil'></i> Edit </a>";
			$i++;
		}
		$Reply['aaData']=$Stored;
		echo json_encode($Reply);
	}

	public function GetAllContactsNotAssignedToAppUsers(Request $request)
	{
		//header('application/json ;charset=utf-8');
		$AppUserID=$request->AppUserId;
		$BoothId=$request->BoothId;
		$IsCity=$request->IsCity;
		$CityOrVillage=$request->CityOrVillageID;
		$DistrictID=$request->DistrictID;
		$TehsilID=$request->TehsilID;
		$WithOtherApp=$request->WithOtherApp;

		$MarathiFirstName=trim($request->FirstName);
		$MarathiLastName=trim($request->LastName);
		$MarathiMiddleName=trim($request->MiddleName);

		$NotAssignedVoters=array();
		$Reply=array();

		if($IsCity==0)
		{
			if($BoothId=="")
			{
				// Load Contacts From village
				if($WithOtherApp==0)
				{
					$Query="select distinct * from tblvoters,tblbooth,tblvillage where tblvoters.BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblvillage.VillageID and tblbooth.Village_City_ID=$CityOrVillage and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%')
					and tblvoters.VoterID not in 
					(select tblvoters.VoterID from tblvoters,tblandroiduservoters,tblbooth,tblvillage where tblvoters.BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblvillage.VillageID and tblvoters.VoterID=tblandroiduservoters.VoterId and tblbooth.Village_City_ID=$CityOrVillage and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%'))";
					$NotAssignedVoters=DB::select($Query);
				}
				else if($WithOtherApp==1)
				{
					$Query="select distinct * FROM tblvoters,tblbooth,tblvillage WHERE tblvoters.BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblvillage.VillageID and tblbooth.Village_City_ID=$CityOrVillage and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%')
					and tblvoters.VoterID NOT IN (SELECT  tblandroiduservoters.VoterID FROM tblandroiduservoters,tblandroidappusers,tblvoters,tblbooth,tblvillage WHERE tblandroidappusers.AppUserID=tblandroiduservoters.AppUserID and tblvoters.VoterID=tblandroiduservoters.VoterID and tblandroiduservoters.AppUserID = $AppUserID and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%'))"; //and tbl androidappusers.Village_City_Prabhag_BoothID
					$NotAssignedVoters=DB::select($Query);
				}
			}
			else if($BoothId!="")
			{
				//load Contacts from booth
				if($WithOtherApp==0)
				{
					$Query="select distinct * FROM `tblvoters` WHERE `tblvoters`.BoothID=$BoothId and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%') and
					 `tblvoters`.`VoterID` NOT IN (SELECT  `tblandroiduservoters`.`VoterID` FROM  `tblandroiduservoters`,`tblandroidappusers`,`tblvoters` WHERE `tblvoters`.BoothID=`tblandroidappusers`.Village_City_Prabhag_BoothID and `tblandroiduservoters`.`AppUserID` = $AppUserID and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%'))";
					$NotAssignedVoters=DB::select($Query);
					//echo $Query;
				}
				else if($WithOtherApp==1)
				{

					$Query="select distinct * FROM `tblvoters` WHERE `tblvoters`.BoothID=$BoothId and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%') and
					 `tblvoters`.`VoterID` NOT IN (SELECT `tblandroiduservoters`.`VoterID` FROM  `tblandroiduservoters`,`tblandroidappusers`,`tblvoters` WHERE `tblandroidappusers`.AppUserID=`tblandroiduservoters`.AppUserId and `tblvoters`.VoterID=`tblandroiduservoters`.VoterId and `tblandroiduservoters`.AppUserId=$AppUserID and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%'))";

	//				$Query="select * from tblvoters where tblvoters.BoothID=$BoothId and tblvoters.VoterID not in (select distinct tblandroiduservoters.VoterId from tblvoters,tblandroiduservoters where tblvoters.VoterID=tblandroiduservoters.VoterId and tblvoters.BoothID=$BoothId)";
				//	$Query="select distinct * FROM tblvoters WHERE tblvoters.BoothID=$BoothId and tblvoters.MarathiFirstName like '%$MarathiFirstName%' and tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' and tblvoters.MarathiLastName like '%$MarathiLastName%' and tblvoters.VoterID NOT IN 
				//	(SELECT `tblvoters`.`VoterID` FROM  `tblandroiduservoters`,`tblandroidappusers`,`tblvoters` WHERE `tblvoters`.VoterID=`tblandroiduservoters`.VoterId and tblvoters.BoothID=$BoothId and tblvoters.MarathiFirstName like '%$MarathiFirstName%' and tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' and tblvoters.MarathiLastName like '%$MarathiLastName%')";
					//echo $Query;
					$NotAssignedVoters=DB::select($Query);
				}
			}
		}
		else if($IsCity==1)
		{
			if($BoothId=="")
			{
				if($MarathiFirstName=="" && $MarathiLastName=="" && $MarathiMiddleName=="" )
				{
					if($WithOtherApp==0)
						{
							$Query="select distinct * from tblvoters,tblbooth,tblcity where tblvoters.BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblbooth.Village_City_ID=$CityOrVillage and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%')
							 and tblvoters.VoterID not in (select tblvoters.VoterID from tblvoters,tblandroiduservoters,tblbooth,tblcity where tblvoters.BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblvoters.VoterID=tblandroiduservoters.VoterId and tblbooth.Village_City_ID=$CityOrVillage and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%'))";
							//echo $Query;
							$NotAssignedVoters=DB::select($Query);
						}
						else if($WithOtherApp==1)
						{
							$Query="select distinct * FROM tblvoters,tblbooth,tblcity WHERE tblvoters.BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblbooth.Village_City_ID=$CityOrVillage and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%')
							 and tblvoters.VoterID NOT IN (SELECT  tblandroiduservoters.VoterID FROM tblandroiduservoters,tblandroidappusers,tblvoters,tblbooth,tblcity WHERE tblandroidappusers.AppUserID=tblandroiduservoters.AppUserID and tblvoters.VoterID=tblandroiduservoters.VoterID and tblandroiduservoters.AppUserID = $AppUserID and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%'))"; //and tbl androidappusers.Village_City_Prabhag_BoothID
							//	$Query="select distinct * FROM tblvoters,tblbooth,tblcity WHERE tblvoters.BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblbooth.Village_City_ID=$CityOrVillage and tblvoters.VoterID NOT IN (SELECT  tblandroiduservoters.VoterID FROM tblandroiduservoters,tblandroidappusers,tblvoters WHERE tblvoters.BoothID=tblandroidappusers.Village_City_Prabhag_BoothID and tblandroiduservoters.AppUserID = $AppUserID)";
							$NotAssignedVoters=DB::select($Query);
						}
				}
				else
				{
					// Load from City 
					if($WithOtherApp==0)
					{
						$Query="select distinct * from tblvoters,tblbooth,tblcity where tblvoters.BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblbooth.Village_City_ID=$CityOrVillage and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%')
						 and tblvoters.VoterID not in (select tblvoters.VoterID from tblvoters,tblandroiduservoters,tblbooth,tblcity where tblvoters.BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblvoters.VoterID=tblandroiduservoters.VoterId and tblbooth.Village_City_ID=$CityOrVillage and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%'))";
						//echo $Query;
						$NotAssignedVoters=DB::select($Query);
					}
					else if($WithOtherApp==1)
					{
						$Query="select distinct * FROM tblvoters,tblbooth,tblcity WHERE tblvoters.BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblbooth.Village_City_ID=$CityOrVillage and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%')
						 and tblvoters.VoterID NOT IN (SELECT  tblandroiduservoters.VoterID FROM tblandroiduservoters,tblandroidappusers,tblvoters,tblbooth,tblcity WHERE tblandroidappusers.AppUserID=tblandroiduservoters.AppUserID and tblvoters.VoterID=tblandroiduservoters.VoterID and tblandroiduservoters.AppUserID = $AppUserID and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%'))"; //and tbl androidappusers.Village_City_Prabhag_BoothID
						//	$Query="select distinct * FROM tblvoters,tblbooth,tblcity WHERE tblvoters.BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblbooth.Village_City_ID=$CityOrVillage and tblvoters.VoterID NOT IN (SELECT  tblandroiduservoters.VoterID FROM tblandroiduservoters,tblandroidappusers,tblvoters WHERE tblvoters.BoothID=tblandroidappusers.Village_City_Prabhag_BoothID and tblandroiduservoters.AppUserID = $AppUserID)";
						$NotAssignedVoters=DB::select($Query);
					}
				}
			}
			else if($BoothId!="")
			{
				if($WithOtherApp==0)
				{
					$Query="select distinct * from tblvoters where tblvoters.BoothID=$BoothId and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%')
					 and tblvoters.VoterID not in (select tblvoters.VoterID from tblvoters,tblandroiduservoters where tblvoters.VoterID=tblandroiduservoters.VoterId and tblvoters.BoothID=$BoothId and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%'))";
					$NotAssignedVoters=DB::select($Query);
				}
				else if($WithOtherApp==1)
				{
					$Query="select distinct * FROM `tblvoters` WHERE `tblvoters`.BoothID=$BoothId and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%')
					 and `tblvoters`.`VoterID` NOT IN (SELECT  `tblandroiduservoters`.`VoterID` FROM  `tblandroiduservoters`,`tblandroidappusers`,`tblvoters` WHERE `tblvoters`.BoothID=`tblandroidappusers`.Village_City_Prabhag_BoothID and `tblandroiduservoters`.`AppUserID` = $AppUserID and (tblvoters.MarathiFirstName like '%$MarathiFirstName%' or tblvoters.EnglishFirstName like '%$MarathiFirstName%' ) and (tblvoters.MarathiMiddleName like '%$MarathiMiddleName%' or tblvoters.EnglishMiddleName like '%$MarathiMiddleName%' ) and (tblvoters.MarathiLastName like '%$MarathiLastName%' or tblvoters.EnglishLastName like '%$MarathiLastName%'))";
					$NotAssignedVoters=DB::select($Query);					
				}
			}
		}

		$Stored=array();$i=0;

		foreach ($NotAssignedVoters as $key => $value) {
			$SrNo=$value->VoterID;
			//echo "onclick='UnselectAllToAssign(".$i.")'";
			$Stored[$i]['Assign']="<input type='checkbox' name='Assign_".$i."' id='Assign_".$i."' value='".$SrNo."' onclick='UnselectAllToAssign(".$i.")'>";
			$Stored[$i]['SrNo']=$value->VoterID;
			$Stored[$i]['MarathiName']= $value->MarathiLastName ." ". $value->MarathiFirstName  ." ".$value->MarathiMiddleName;
			
			$Stored[$i]['Address']=$value->Address;
			$Stored[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
			if($value->Sex=="M")
			{
				$Stored[$i]['Sex']="पुरुष";	
			}
			else if($value->Sex=="F")
			{
				$Stored[$i]['Sex']="स्त्री";	
			}
			$Stored[$i]['EditVoter']="<a  href='#' onclick='ChangeVotingInformation(".$value->VoterID.")'> <i class='fa fa-pencil'></i> Edit </a>";
			$i++;
		}
		$Reply['aaData']=$Stored;
		echo json_encode($Reply);
	}

	public function AssignVoters(Request $request)
	{
		$AppUserId=$request->AppUserId;
		$Voters=json_decode($request->Voters);
		//echo count($Voters);
		$AlreadyAssignedVotersCount=0;
		$SuccessfullySavedVoters=0;
		$CanceledVoters=0;
		foreach ($Voters as $key=> $value) {

			// Check if voterid and appuserid is already exists 
			if($value!=null)
			{
				$vot=appusersvoters::where("AppUserID","=",$AppUserId)->where("VoterID","=",$value)->get();
				if(count($vot)==0)
				{
					// Insert Voter
					$AppVoters=new appusersvoters;

					$AppVoters->AppUserId=$AppUserId;
					$AppVoters->VoterId=$value;

					$AppVoters->save();
					$LastInsertedId=$AppVoters->id;
					if($LastInsertedId>0)
					{
						// Successfully Saved
						$SuccessfullySavedVoters++;
					}
					else
					{
						// Not Saved
						$CanceledVoters++;
					}
				}	
				else
				{
					$AlreadyAssignedVotersCount++;
				}	
			}
		}

		$Reply['SuccessfullyAssigned']=$SuccessfullySavedVoters." Voters are successfully Assigned";
		$Reply['AlreadyAssigned']=$CanceledVoters." Voters are Already Assigned";
		$Reply['Cancelled']=$AlreadyAssignedVotersCount." Voters are Canceled";

		echo json_encode($Reply);
	}

	public function RemoveVoters(Request $request)
	{
		$AppUserId=$request->AppUserId;
		$Voters=json_decode($request->Voters);
		$DeletedCount=0;
		$NotDeletedCount=0;
		// remove Voters
		foreach ($Voters as $key=> $value) {

			$affectedRow= appusersvoters::where('VoterId', '=', $value)->where('AppUserId','=',$AppUserId)->delete();
			if($affectedRow==1)
			{
				$DeletedCount++;
			}
			else
			{
				$NotDeletedCount++;
			}
		}

		$Reply['DeletedCount']=$DeletedCount ." Voters Successfully Removed ";
		$Reply['NotDeletedCount']=$NotDeletedCount." Voters Not Removed";

		echo json_encode($Reply);
	}

	// Android App reports
	public function app_reports()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		$AllAppUsers=androidapp::where("AppUserID",">",0)->get();
		$ReplyData=array();$i=0;
	//	echo "Apps ".count($AllAppUsers);
		
		foreach ($AllAppUsers as $key => $value) {

			$ReplyData[$i]['AppUserID']=$value->AppUserID;
			$ReplyData[$i]['Name']=$value->Name;
			$ReplyData[$i]['MobileNumber']=$value->MobileNumber;
			$ReplyData[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
			if($value->DateOfBirth=="0000-00-00")
			{
				$ReplyData[$i]['DateOfBirth']="";
			}
			else 
			{
				$ReplyData[$i]['DateOfBirth']=$value->DateOfBirth;
			}

			$ReplyData[$i]['Address']=$value->Address;
			$ReplyData[$i]['Email']=$value->Email;
			if($value->InUse==0)
			{
				$ReplyData[$i]['InUse']="नाही";
			}
			else if($value->InUse==1)
			{
				$ReplyData[$i]['InUse']="आहे";
			}
			if($value->AppStatus==1)
			{
				$ReplyData[$i]['Status']="नाही";	
			}
			else if($value->AppStatus==0)
			{
				$ReplyData[$i]['Status']="होय";	
			}
			$ReplyData[$i]['ActivationDate']=$value->ActivationDate;
			$ReplyData[$i]['DeactivationDate']=$value->DeactivationDate;
			$ReplyData[$i]['IMEINumber']=$value->IMEINumber;
			$ReplyData[$i]['LastOTP']=$value->LastOTP;
			$ReplyData[$i]['BloodGroup']=$value->BloodGroup;
			$CastID=$value->CastID;$CastName="";

			$Cast=cast::where("CastID",'=',$CastID)->get();
			foreach ($Cast as $key => $vals) {
				$CastName=$vals->CastName;
			}
			$ReplyData[$i]['CastName']=$CastName;
			$IsCity=$ReplyData[$i]['IsCity']=$value->IsCity;
			$ReplyData[$i]['Village_City_Prabhag_BoothID']=$value->Village_City_Prabhag_BoothID;

			//$ReplyData[$i]['Village_City_ID']=$value->Village_City_ID; 
			$i++;
			
		}
		//print_r($ReplyData);
		//echo json_encode($ReplyData);
		$data=array("pagetitle" => " कार्यकर्ता रिपोर्ट्स  ","DefaultValue"=>$DefaultValue,"AppUsers"=>$ReplyData);

	//	$data=array("pagetitle" => "कार्यकर्ता रिपोर्ट्स  ",'Districts'=>$Districts);
		return view('admin.app_reports',$data);
	}

	public function APPReports(Request $request)
	{
		$DistrictId=$request->DistrictId;
		$TehsilId=$request->TehsilID;
		$IsCity=$request->IsCity;
		$City_VillageId=$request->CityOrVillageName;
		$App_Status=$request->App_Status;
		$BoothNull=-1;
		$Reply=array();
		$i=0;
		$Query="";
		if($DistrictId!="" && $TehsilId=="" && $City_VillageId=="")
		{
			if($App_Status=="") // Display All App Users from district
			{
				$Query1="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblvillage,tblandroidappusers,tbldistrict where tblandroidappusers.Village_City_Prabhag_BoothID=tblvillage.VillageID and tblvillage.TehsilID=tbltehsil.TehsilID and tbltehsil.DistrictID=tbldistrict.DistrictID and tblandroidappusers.IsCity=0 and tbldistrict.DistrictID=$DistrictId and tblandroidappusers.AccessLevel=1 UNION ALL 
				 select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblcity,tblandroidappusers,tbldistrict where tblandroidappusers.Village_City_Prabhag_BoothID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tbltehsil.DistrictID=tbldistrict.DistrictID and tblandroidappusers.IsCity=1 and tbldistrict.DistrictID=$DistrictId and tblandroidappusers.AccessLevel=1";

				$Query2="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName ,tbltehsil.TehsilID from tblbooth,tbltehsil,tblvillage,tblandroidappusers,tbldistrict where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblvillage.VillageID and tbltehsil.DistrictID=tbldistrict.DistrictID and tbldistrict.DistrictID=$DistrictId and tblandroidappusers.AccessLevel=2 UNION ALL 
				select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tblbooth,tbltehsil,tblcity,tblandroidappusers,tbldistrict where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tbltehsil.DistrictID=tbldistrict.DistrictID and tblandroidappusers.IsCity=1 and tbldistrict.DistrictID=$DistrictId and tblandroidappusers.AccessLevel=2";
				$Query=$Query1." UNION ALL ".$Query2;
			}
			else if($App_Status!="" ) // Display App Users with App Status 
			{
				 $Query1="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblvillage.VillageID and tblvillage.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=0 and tbltehsil.DistrictID=$DistrictId and tblandroidappusers.AccessLevel=1 and tblandroidappusers.Status=$App_Status UNION ALL select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tbltehsil.DistrictID=$DistrictId and tblandroidappusers.AccessLevel=1 and tblandroidappusers.Status=$App_Status";
				 $Query2="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName ,tbltehsil.TehsilID from tblbooth,tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblvillage.VillageID and tbltehsil.DistrictID=$DistrictId and tblandroidappusers.AccessLevel=2 and tblandroidappusers.Status=$App_Status UNION ALL select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tblbooth,tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tbltehsil.DistrictID=$DistrictId and tblandroidappusers.AccessLevel=2 and tblandroidappusers.Status=$App_Status";
				 $Query=$Query1." UNION ALL ".$Query2;				
			}
		}
		else if($DistrictId!="" && $TehsilId!="" && $City_VillageId=="")
		{
			if($IsCity==0)
			{
				//echo "ABC";				
				if($App_Status=="") // Display All App Users from district
				{
					$Query1="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblvillage.VillageID and tblvillage.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=0 and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=1 UNION ALL select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=1";
					$Query2="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName ,tbltehsil.TehsilID from tblbooth,tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblvillage.VillageID and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=2 UNION ALL select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tblbooth,tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=2";
					$Query=$Query1." UNION ALL ".$Query2;
					//echo $Query;
				}
				else if($App_Status!="" ) // Display App Users with App Status 
				{
					
					$Query1="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblvillage.VillageID and tblvillage.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=0 and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=1 and tblandroidappusers.Status=$App_Status UNION ALL select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=1 and tblandroidappusers.Status=$App_Status";
					$Query2="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName ,tbltehsil.TehsilID from tblbooth,tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblvillage.VillageID and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=2 and tblandroidappusers.Status=$App_Status UNION ALL select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tblbooth,tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=2 and tblandroidappusers.Status=$App_Status";
					$Query=$Query1." UNION ALL ".$Query2;
					//echo $Query;
				}		
			}
			else if($IsCity==1)
			{
				if($App_Status=="") // Display All App Users from district
				{
					$Query1="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblvillage.VillageID and tblvillage.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=0 and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=1 UNION ALL select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=1";
					$Query2="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName ,tbltehsil.TehsilID from tblbooth,tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblvillage.VillageID and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=2 UNION ALL select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tblbooth,tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=2";
					$Query=$Query1." UNION ALL ".$Query2;
					//echo $Query;
				}
				else if($App_Status!="" ) // Display App Users with App Status 
				{
					$Query1="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblvillage.VillageID and tblvillage.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=0 and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=1 and tblandroidappusers.Status=$App_Status UNION ALL select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=1 and tblandroidappusers.Status=$App_Status";
					$Query2="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName ,tbltehsil.TehsilID from tblbooth,tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblvillage.VillageID and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=2 and tblandroidappusers.Status=$App_Status UNION ALL select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tblbooth,tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tbltehsil.TehsilID=$TehsilId and tblandroidappusers.AccessLevel=2 and tblandroidappusers.Status=$App_Status";
					$Query=$Query1." UNION ALL ".$Query2;					
				//	echo $Query;
				}
			}
		}
		else if($DistrictId!="" && $TehsilId!="" && $City_VillageId!="")
		{
			if($App_Status=="") // Display All App Users from district
			{
				if($IsCity==0)
				{
				
					$Query1="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID, tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth,tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblvillage.VillageID and tblvillage.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=0 and tblvillage.VillageID=$City_VillageId and tblandroidappusers.AccessLevel=1 ";
					$Query2="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID, tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth,tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName ,tbltehsil.TehsilID from tblbooth,tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblvillage.VillageID and tblvillage.VillageID=$City_VillageId and tblandroidappusers.AccessLevel=2 ";
					$Query=$Query1." UNION ALL ".$Query2;
				}
				else if($IsCity==1)
				{

					$Query1="select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tblcity.CityID=$City_VillageId and tblandroidappusers.AccessLevel=1";
					$Query2="select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tblbooth,tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tblcity.CityID=$City_VillageId and tblandroidappusers.AccessLevel=2";
					$Query=$Query1." UNION ALL ".$Query2;
				}
			}
			else if($App_Status!="" ) // Display App Users with App Status 
			{
				if($IsCity==0)
				{
					$Query1="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblvillage.VillageID and tblvillage.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=0 and tblvillage.VillageID=$City_VillageId and tblandroidappusers.AccessLevel=1 and tblandroidappusers.Status=$App_Status";
					$Query2="select tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus ,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblvillage.VillageName as City_VillageName ,tbltehsil.TehsilID from tblbooth,tbltehsil,tblvillage,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblvillage.VillageID and tblvillage.VillageID=$City_VillageId and tblandroidappusers.AccessLevel=2 and tblandroidappusers.Status=$App_Status";
					$Query=$Query1." UNION ALL ".$Query2;
				}
				else if($IsCity==1)
				{
					$Query1="select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID,tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth, tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tblcity.CityID=$City_VillageId and tblandroidappusers.AccessLevel=1 and tblandroidappusers.Status=$App_Status";
					$Query2="select distinct tblandroidappusers.AppUserID,tblandroidappusers.Type,tblandroidappusers.BloodGroup,tblandroidappusers.CastID, tblandroidappusers.Email,tblandroidappusers.Address,tblandroidappusers.WhatsAppNumber,tblandroidappusers.DateOfBirth,tblandroidappusers.Name ,tblandroidappusers.MobileNumber , tblandroidappusers.InUse ,tblandroidappusers.Status as AppStatus,tblandroidappusers.ActivationDate ,tblandroidappusers.DeactivationDate , tblandroidappusers.IMEINumber , tblandroidappusers.LastOTP ,tblandroidappusers.AccessLevel  ,tblandroidappusers.Village_City_Prabhag_BoothID ,tblandroidappusers.IsCity ,tblandroidappusers.Village_City_Prabhag_BoothID as City_VillageID, tblcity.CityName as City_VillageName, tbltehsil.TehsilID from tblbooth,tbltehsil,tblcity,tblandroidappusers where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and tblbooth.Village_City_ID=tblcity.CityID and tblcity.TehsilID=tbltehsil.TehsilID and tblandroidappusers.IsCity=1 and tblcity.CityID=$City_VillageId and tblandroidappusers.AccessLevel=2 and tblandroidappusers.Status=$App_Status";
					$Query=$Query1." UNION ALL ".$Query2;
				}
			}
		}

		$ResultSet=DB::select($Query);
		$ReplyData=array();
		foreach ($ResultSet as $key => $value) {
			$ReplyData[$i]['SMS']="<input type='checkbox' id='_".$i."' name='_".$i."' onchange='Unselect()' value='".$value->AppUserID."'>";
			$ReplyData[$i]['AppUserID']=$value->AppUserID;
			$AppUserID=$value->AppUserID;
			$ReplyData[$i]['TotalVoters']=appusersvoters::where("AppUserId","=",$value->AppUserID)->count();
			$ReplyData[$i]['Name']=$value->Name;
			$ReplyData[$i]['MobileNumber']=$value->MobileNumber;
			$ReplyData[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
			$ReplyData[$i]['Type']=$value->Type;
			// Edit App
			$ReplyData[$i]['EditApp']="<a href='#' onclick='EditApp($AppUserID)'> <i class='fa fa-edit'></i> Edit </a>";
			if($value->DateOfBirth=="0000-00-00")
			{
				$ReplyData[$i]['DateOfBirth']="";
			}
			else 
			{
				$ReplyData[$i]['DateOfBirth']=$value->DateOfBirth;
			}

			$ReplyData[$i]['Address']=$value->Address;
			$ReplyData[$i]['Email']=$value->Email;
			if($value->InUse==0)
			{
				$ReplyData[$i]['InUse']="नाही";
			}
			else if($value->InUse==1)
			{
				$ReplyData[$i]['InUse']="आहे";
			}
			if($value->AppStatus==1)
			{
				$ReplyData[$i]['Status']="नाही";	
			}
			else if($value->AppStatus==0)
			{
				$ReplyData[$i]['Status']="होय";	
			}
			$ReplyData[$i]['ActivationDate']=$value->ActivationDate;
			$ReplyData[$i]['DeactivationDate']=$value->DeactivationDate;
			$ReplyData[$i]['IMEINumber']=$value->IMEINumber;
			$ReplyData[$i]['LastOTP']=$value->LastOTP;
			$ReplyData[$i]['BloodGroup']=$value->BloodGroup;
			$CastID=$value->CastID;$CastName="";
			$Cast=cast::where("CastID",'=',$CastID)->get();
			foreach ($Cast as $key => $vals) {
				$CastName=$vals->CastName;
			}
			$ReplyData[$i]['CastName']=$CastName;
			$IsCity=$ReplyData[$i]['IsCity']=$value->IsCity;

			if($value->AccessLevel==2)
			{
				$ReplyData[$i]['AccessLevel']="Booth Level Access";	
			}
			else if($value->AccessLevel==1)
			{
				if($IsCity==0)
				{
					$ReplyData[$i]['AccessLevel']="Village Level Access";
				}
				else if($IsCity==1)
				{
					$ReplyData[$i]['AccessLevel']="City Level Access";
				}
			}

			$ReplyData[$i]['Village_City_Prabhag_BoothID']=$value->Village_City_Prabhag_BoothID;

			if($value->AccessLevel==2)
			{
				// Select Booth Number and ID
				$BoothID="";$BoothNumber="";
				$BoothIDGet=DB::select("select Village_City_Prabhag_BoothID,tblbooth.BoothNumber from tblandroidappusers,tblbooth where tblandroidappusers.Village_City_Prabhag_BoothID=tblbooth.BoothID and AppUserID=$value->AppUserID");
				foreach ($BoothIDGet as $key => $val) {
					$BoothID=$val->Village_City_Prabhag_BoothID;
					$BoothNumber=$val->BoothNumber;
				}
				$ReplyData[$i]['BoothID']=$BoothID;
				$ReplyData[$i]['BoothNumber']=$BoothNumber;
			}
			else 
			{
				$ReplyData[$i]['BoothID']="";
				$ReplyData[$i]['BoothNumber']="";
			}
			//$ReplyData[$i]['Village_City_ID']=$value->Village_City_ID; 
			$ReplyData[$i]['City_VillageID']=$value->City_VillageID;
			$ReplyData[$i]['City_VillageName']=$value->City_VillageName;
			
			$ReplyData[$i]['TehsilID']=$value->TehsilID;
			$i++;
		}
		$Reply['aaData']=$ReplyData;
		echo json_encode($Reply);
	}

	public function app_voters_reports()
	{
		$AndroidAppUsers=DB::select("select * from tblandroidappusers Order by Name ASC ");//androidapp::where("Status","=",1)->get();
		$Districts=district::where("Status","=",1)->get();
		$data=array("pagetitle" => "  कार्यकर्ता मतदार रिपोर्ट्स  ","AppUsers"=>$AndroidAppUsers,"Districts"=>$Districts);//,"States"=>$States,"Zones"=>$Zones,,"Tehsils"=>$Tehsils);
		return view('admin.app-voters-reports',$data);
	}

	public function GetAppVoters(Request $request)
	{
		// Get All Contacts Assigned To User And Not Assigned to Users from Village or City
		$AppUserID=$request->AppUserId;
		//$AssignedVoters=voters::
		$Voters=DB::select("SELECT distinct * FROM `tblvoters`,tblandroiduservoters where tblvoters.VoterID = tblandroiduservoters.VoterID and `tblandroiduservoters`.AppUserId=$AppUserID");
		$Stored=array();$i=0;
		$Rply=array();
		foreach ($Voters as $key => $value) {
			$Rply[$i]['SMS']="<input type='checkbox' id='_".$i."' name='_".$i."' onchange='Unselect()' value='".$value->VoterID."'>";
			$Rply[$i]['SrNo']=$value->SrNo;
			$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
			$Rply[$i]['MobileNumber']=$value->MobileNumber;
			$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
			$Rply[$i]['Email']=$value->Email;
			$Rply[$i]['EPICNumber']=$value->EPICNumber;
			$Rply[$i]['VotingCenter']=$value->VotingCentre;
			$Rply[$i]['Address']=$value->Address;
			$Rply[$i]['NewAddress']=$value->NewAddress;

			if($value->Sex=="F")
			{
				$Rply[$i]['Sex']="स्त्री";
			}
			else if($value->Sex=="M")
			{
				$Rply[$i]['Sex']="पुरुष";
			}
			$BoothID=$value->BoothID;
			$BoothNumbers=DB::select("select BoothNumber from tblbooth where BoothID = $BoothID");
			foreach ($BoothNumbers as $key => $val) {
				$Rply[$i]['BoothNumber']=$val->BoothNumber;
			}
			$Rply[$i]['EditVoter']="<a  href='#' onclick='ChangeVotingInformation(".$value->VoterID.")'> <i class='fa fa-pencil'></i> Edit </a>";
			$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
			$i++;
		}
		$Reply['aaData']=$Rply;
		echo json_encode($Reply);
	}

	public function app_users_birthday_report()
	{
		$AndroidAppUsers=androidapp::where("Status","=",1)->get();
		$Districts=district::where("Status","=",1)->get();
		$data=array("pagetitle" => " कार्यकर्ता जन्मतारीख रिपोर्ट्स  ","AppUsers"=>$AndroidAppUsers,"Districts"=>$Districts);//,"States"=>$States,"Zones"=>$Zones,,"Tehsils"=>$Tehsils);
		return view('admin.app_users_birthday_report',$data);
	}

	public function GetAppUserBirthday(Request $request)
	{
		$Birthday1=$request->Birthday1;
		$Birthday2=$request->Birthday2;
		$AppUsers=array();
		$Query="";
		if($Birthday1=="" && $Birthday2=="")
		{
			$Query="select * from tblandroidappusers where 1";
		}
		else if($Birthday1!="" && $Birthday2=="")
		{
			$Birthday1=date("Y-m-d", strtotime($request->Birthday1));

			$Query="select * from tblandroidappusers where DATE_FORMAT(DateOfBirth, '%m-%d') = DATE_FORMAT('$Birthday1', '%m-%d')";	
		}
		else if($Birthday2!="" && $Birthday1=="")
		{
			$Birthday2=date("Y-m-d", strtotime($request->Birthday2));
			$Query="select * from tblandroidappusers where DATE_FORMAT(DateOfBirth, '%m-%d') = DATE_FORMAT('$Birthday2', '%m-%d') ";
		}		
		else if($Birthday1!="" && $Birthday2!="")
		{
			$Birthday1=date("Y-m-d", strtotime($request->Birthday1));
			$Birthday2=date("Y-m-d", strtotime($request->Birthday2));
			$Query="select * from tblandroidappusers where DATE_FORMAT(DateOfBirth, '%m-%d') between DATE_FORMAT('$Birthday1', '%m-%d') and DATE_FORMAT('$Birthday2', '%m-%d')";
		}

		$AppUsers=DB::select($Query);
		$Reply=array();$i=0;
		foreach ($AppUsers as $key => $value) {
			$Reply[$i]['SMS']="<input type='checkbox' id='_".$i."' name='_".$i."' onchange='Unselect()' value='".$value->AppUserID."'>";
			$Reply[$i]['Name']=$value->Name;
			$Reply[$i]['MobileNumber']=$value->MobileNumber;
			$Reply[$i]['AppUserID']=$value->AppUserID;
			$AppUserID=$value->AppUserID;
			$Reply[$i]['InUse']=$value->InUse;
			$Reply[$i]['Status']=$value->Status;
			$Reply[$i]['ActivationDate']=$value->ActivationDate;
			$Reply[$i]['DeactivationDate']=$value->DeactivationDate;
			$Reply[$i]['IMEINumber']=$value->IMEINumber;
			$Reply[$i]['LastOTP']=$value->LastOTP;
			$Reply[$i]['AccessLevel']=$value->AccessLevel;
			$Reply[$i]['Village_City_Prabhag_BoothID']=$value->Village_City_Prabhag_BoothID;
			$Reply[$i]['IsCity']=$value->IsCity;
			$Reply[$i]['Email']=$value->Email;
			$Reply[$i]['Address']=$value->Address;
			$Reply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
			$Reply[$i]['Type']=$value->Type;
			$Reply[$i]['EditApp']="<a href='#' onclick='EditApp($AppUserID)'> <i class='fa fa-edit'></i> Edit </a>";
			$Reply[$i]['BloodGroup']=$value->BloodGroup;
			$CastID=$value->CastID;$CastName="";
			$Cast=cast::where("CastID",'=',$CastID)->get();
			foreach ($Cast as $key => $vals) {
				$CastName=$vals->CastName;
			}
			$Reply[$i]['CastName']=$CastName;

			if($value->DateOfBirth=="0000-00-00")
			{
				$Reply[$i]['DateOfBirth']="";
			}
			else
			{
				$Reply[$i]['DateOfBirth']=$value->DateOfBirth;		
			}
			$i++;
		}
		$Response['aaData']=$Reply;
		echo json_encode($Response);
	}

	public function report_by_voted_voters_by_appusers()
	{
		$AndroidAppUsers=androidapp::where("Status","=",1)->get();
		$Districts=district::where("Status","=",1)->get();
		$data=array("pagetitle" => " कार्यकर्ता जन्मतारीख रिपोर्ट्स  ","AppUsers"=>$AndroidAppUsers,"Districts"=>$Districts);//,"States"=>$States,"Zones"=>$Zones,,"Tehsils"=>$Tehsils);
		return view('admin.report_by_voted_voters_by_appusers',$data);
	}

	public function GetAppUsersVotedVoters(Request $request)
	{
		// Get All Contacts Assigned To User And Not Assigned to Users from Village or City
		$AppUserID=$request->AppUserId;
		$IsVoted=$request->VotingStatus;
		$VotingAnalysis=$request->VotingAnalysis;
		$Voters=array();
		if($IsVoted==""  && $VotingAnalysis=="")
		{
			$Voters=DB::select("SELECT distinct * FROM `tblvoters`,tblandroiduservoters where tblvoters.VoterID = tblandroiduservoters.VoterID and `tblandroiduservoters`.AppUserId=$AppUserID");			
		}
		else if($IsVoted!=""  && $VotingAnalysis=="")
		{
			$Voters=DB::select("SELECT distinct * FROM `tblvoters`,tblandroiduservoters where tblvoters.VoterID = tblandroiduservoters.VoterID and `tblandroiduservoters`.AppUserId=$AppUserID and tblvoters.IsVoted=$IsVoted");
		}
		else if( $VotingAnalysis!="" && $IsVoted=="" )
		{
			$Voters=DB::select("SELECT distinct * FROM `tblvoters`,tblandroiduservoters where tblvoters.VoterID = tblandroiduservoters.VoterID and `tblandroiduservoters`.AppUserId=$AppUserID and tblvoters.VotingAnalysis='$VotingAnalysis'");
		}
		else if( $VotingAnalysis!="" && $IsVoted!="" )
		{
			$Voters=DB::select("SELECT distinct * FROM `tblvoters`,tblandroiduservoters where tblvoters.VoterID = tblandroiduservoters.VoterID and `tblandroiduservoters`.AppUserId=$AppUserID and tblvoters.IsVoted=$IsVoted and tblvoters.VotingAnalysis='$VotingAnalysis'");
		}

		$Stored=array();$i=0;
		$Rply=array();
		foreach ($Voters as $key => $value) {
			$VotingAnalysis=$value->VotingAnalysis;
			if($VotingAnalysis=="इतर")
			{
				if($value->IsPoliticallyStrong==1)
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
				}
				else
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
				}
			}
			else if($VotingAnalysis=="आपला")
			{
				if($value->IsPoliticallyStrong==1)
				{
					$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
				}
				else
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
				}				
			}
			else if($VotingAnalysis=="विरोधी")			
			{
				if($value->IsPoliticallyStrong==1)
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
				}
				else
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
				}				
			}
			else if($VotingAnalysis=="संदिग्ध")
			{
				if($value->IsPoliticallyStrong==1)
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
				}
				else
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
				}
			}
			$Rply[$i]['SrNo']=$value->SrNo;
			$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
			$Rply[$i]['MobileNumber']=$value->MobileNumber;
			$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
			$Rply[$i]['Email']=$value->Email;
			$Rply[$i]['EPICNumber']=$value->EPICNumber;
			$Rply[$i]['VotingCenter']=$value->VotingCentre;
			$Rply[$i]['Address']=$value->Address;
			$Rply[$i]['NewAddress']=$value->NewAddress;

			if($value->IsVoted==0)
			{
				$Rply[$i]['IsVoted']="नाही";
			}
			else if($value->IsVoted==1)
			{
				$Rply[$i]['IsVoted']="होय";
			}

			if($value->Sex=="F")
			{
				$Rply[$i]['Sex']="स्त्री";
			}
			else if($value->Sex=="M")
			{
				$Rply[$i]['Sex']="पुरुष";
			}
			$BoothID=$value->BoothID;
			$BoothNumbers=DB::select("select BoothNumber from tblbooth where BoothID = $BoothID");
			foreach ($BoothNumbers as $key => $val) {
				$Rply[$i]['BoothNumber']=$val->BoothNumber;
			}
			$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
			$i++;
		}
		$Reply['aaData']=$Rply;
		echo json_encode($Reply);
	}
}