<?php namespace App\Http\Controllers;
use App\state;
use App\zone;
use App\district;
use App\tehsil;
use App\city;
use App\village;
use App\prabhag;

use DB;
use Validator;
use illuminate\Http\Request;
use illuminate\Routing\Controllers;
class PrabhagController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Welcome Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders the "marketing page" for the application and
	| is configured to only allow guests. Like most of the other sample
	| controllers, you are free to modify or remove it as you desire.
	|
	*/

	/**
	 * Show the application welcome screen to the user.
	 *
	 * @return Response
	 */
	public function index()
	{
		//	echo "this is My Admin Controller";
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}
		$ZoneID="";
		$DistrictDetails=district::where("DistrictID","=",$DistrictID)->get();
		foreach ($DistrictDetails as $key => $value) {
			$ZoneID=$value->ZoneID;
		}
		$StateID="";
		$ZoneDetails=zone::where("ZoneID","=",$ZoneID)->get();
		foreach ($ZoneDetails as $key => $value) {
			$StateID=$value->StateID;
		}

		$States=state::where("Status","=",1)->get();
		$Zones=zone::where("StateID","=",$StateID)->get();

		$data=array("pagetitle" => " नवीन प्रभाग  ","States"=>$States,"SelectedState"=>$StateID,"Zones"=>$Zones,"SelectedZone"=>$ZoneID,"DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

	//	$data=array("pagetitle" => " नवीन प्रभाग  ","States"=>$States);
		return view('admin.new-prabhag',$data);
	}

	public function edit()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}
		$ZoneID="";
		$DistrictDetails=district::where("DistrictID","=",$DistrictID)->get();
		foreach ($DistrictDetails as $key => $value) {
			$ZoneID=$value->ZoneID;
		}
		$StateID="";
		$ZoneDetails=zone::where("ZoneID","=",$ZoneID)->get();
		foreach ($ZoneDetails as $key => $value) {
			$StateID=$value->StateID;
		}

		$States=state::where("Status","=",1)->get();
		$Zones=zone::where("StateID","=",$StateID)->get();

		$data=array("pagetitle" => " प्रभाग माहितीत बदल करा   ","States"=>$States,"SelectedState"=>$StateID,"Zones"=>$Zones,"SelectedZone"=>$ZoneID,"DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		//$data=array("pagetitle" => " प्रभाग माहितीत बदल करा   ","States"=>$States);
		return view('admin.edit-prabhag',$data);
	}

	public function delete()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}
		$ZoneID="";
		$DistrictDetails=district::where("DistrictID","=",$DistrictID)->get();
		foreach ($DistrictDetails as $key => $value) {
			$ZoneID=$value->ZoneID;
		}
		$StateID="";
		$ZoneDetails=zone::where("ZoneID","=",$ZoneID)->get();
		foreach ($ZoneDetails as $key => $value) {
			$StateID=$value->StateID;
		}

		$States=state::where("Status","=",1)->get();
		$Zones=zone::where("StateID","=",$StateID)->get();

		$data=array("pagetitle" => "  काढून टाका  ","States"=>$States,"SelectedState"=>$StateID,"Zones"=>$Zones,"SelectedZone"=>$ZoneID,"DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		return view('admin.delete-prabhag',$data);
	}

	// Save Prabhag
	public function SavePrabhag(Request $request)
	{
		$IsCity=0;
		if($request->CityOrVillage=="City")
		{
			$IsCity=1;
		}
		else if($request->CityOrVillage=="Village")
		{
			$IsCity=0;
		}

		$validator= Validator::make(
			array(
				"States"=>$request->States,
				"Zones"=>$request->Zones,
				"Districts"=>$request->Districts,
				"Tehsils"=>$request->Tehsils,
				"CityOrVillage"=>$request->CityOrVillage,
				"Prabhag"=>$request->Prabhag
				),
			array(
				"States"=>"required",
				"Zones"=>"required",
				"Districts"=>"required",
				"Tehsils"=>"required",
				"CityOrVillage"=>"required",
				"Prabhag"=>"required",
				)
			);
		if($validator->fails())
		{
			return redirect("/new-prabhag")->withErrors($validator)->withInput();
		}
		else
		{
			// Insert City to db
			// Check Duplicate Entry
			$CityIDOrVillageId=0;
			if($IsCity==1)
			{
				$CityIDOrVillageId=$request->CorV;
			}
			else if($IsCity==0)
			{
				$CityIDOrVillageId=$request->CorV;
			}
			$PrabhagArray=explode(",", $request->Prabhag);
			$SavedCount=0;$AlreadySavedPrabhag=0;
			for ($i=0; $i < count($PrabhagArray) ; $i++) { 
				$PrabhagName=$PrabhagArray[$i];
				if($PrabhagName!="")
				{
					$DuplicatePrabhag=prabhag::where('Village_City_ID', '=',$CityIDOrVillageId)->where('IsCity','=',$IsCity)->where('PrabhagName','=',"$PrabhagName")->get();
					if(count($DuplicatePrabhag)==0)
					{
						$Prabhag=new prabhag;
						$Prabhag->PrabhagName=$PrabhagName;
						$Prabhag->Village_City_ID=$CityIDOrVillageId;
						$Prabhag->IsCity=$IsCity;
						$Prabhag->save();
						$insertedId = $Prabhag->id;
						if($insertedId>0)
						{
							$SavedCount++;
							// return redirect("/new-Prabhag")->withErrors($validator)->withInput()->with("success","Prabhag Number ".$request->City." is Successfully Saved");
						}
						else
						{
							return redirect("/new-prabhag")->withErrors($validator)->withInput()->with("error","Can't Save Prabhag Number ".$PrabhagName." \n".$SavedCount . " Prabhags is Successfully Saved");
						}			
					}
					else
					{
						//$AlreadySavedPrabhag++;
						return redirect("/new-prabhag")->withErrors($validator)->withInput()->with("error","Prabhag ".$PrabhagName." Already Saved \n".$SavedCount . " Prabhags is Successfully Saved");
					}					
				}
				else
				{
					return redirect("/new-prabhag")->withErrors($validator)->withInput()->with("error","Prabhag Number ".$PrabhagName." is Empty ");
				}
		}

		if($SavedCount!=0)		
			{
				return redirect("/new-prabhag")->withErrors($validator)->withInput()->with("success",$SavedCount." Prabhags is Successfully Saved");
			}
			else
			{
				return redirect("/new-prabhag")->withErrors($validator)->withInput()->with("error"," No any Prabhag Saved !!!");
			}
		}
	}

	public function EditPrabhag(Request $request)
	{

		$IsCity=0;
		if($request->CityOrVillage=="City")
		{
			$IsCity=1;
		}
		else if($request->CityOrVillage=="Village")
		{
			$IsCity=0;
		}

		$validator= Validator::make(
			array(
				"States"=>$request->States,
				"Zones"=>$request->Zones,
				"Districts"=>$request->Districts,
				"Tehsils"=>$request->Tehsils,
				"CityOrVillage"=>$request->CityOrVillage,
				"Prabhags"=>$request->Prabhags,
				"Prabhag"=>$request->Prabhag
				),
			array(
				"States"=>"required",
				"Zones"=>"required",
				"Districts"=>"required",
				"Tehsils"=>"required",
				"CityOrVillage"=>"required",
				"Prabhags"=>"required",
				"Prabhag"=>"required",
				)
			);
			if($validator->fails())
			{
				return redirect("/edit-prabhag")->withErrors($validator)->withInput();
			}
			else
			{
				// Insert City to db
				// Check Duplicate Entry
				$CityIDOrVillageId=0;
				$PrabhagName=$request->Prabhag;
				if($IsCity==1)
				{
					$CityIDOrVillageId=$request->Citys;
				}
				else if($IsCity==0)
				{
					$CityIDOrVillageId=$request->Villages;
				}
				// Check Prabhag Is Already Present or not
					$DuplicatePrabhag=prabhag::where('Village_City_ID', '=',$CityIDOrVillageId)->where('IsCity','=',$IsCity)->where('PrabhagName','=',"$PrabhagName")->get();
					if(count($DuplicatePrabhag)==0)
					{
						// Update Prabhag
						$affectedRows = prabhag::where('PrabhagID', '=', $request->Prabhags)->update(['PrabhagName' => $request->Prabhag]);
						if($affectedRows==1)
						{
							return redirect("/edit-prabhag")->withErrors($validator)->withInput()->with("success","Prabhag ".$request->Prabhag." is Successfully Updated");
						}
						else
						{
							return redirect("/edit-prabhag")->withErrors($validator)->withInput()->with("error"," City ".$request->Prabhag." is Already Saved");
						}
					}
					else
					{
						// Prabhag is ALready Present
						return redirect("/edit-prabhag")->withErrors($validator)->withInput()->with("error"," Prabhag Number ".$PrabhagName." is already Saved !!!");
					}
			}
	}

	public function DeletePrabhag(Request $request)
	{
		$validator=Validator::make(
			array(
				'States'=>$request->States,
				'Zones'=>$request->Zones,
				'Districts'=>$request->Districts,
				'Tehsils'=>$request->Tehsils,
				'Prabhags'=>$request->Prabhags,
				'CityOrVillage'=>$request->CityOrVillage
			),
			array(
				'States'=>"required",
				'Zones'=>"required",
				'Districts'=>"required",
				'Tehsils'=>"required",
				'Prabhags'=>"required",
				'CityOrVillage'=>"required"
				)
			);

		if($validator->fails())
		{
			return redirect("/delete-prabhag")->withErrors($validator)->withInput();
		}
		else
		{
			// chk City if present
				$IsCity=0;
				if($request->CityOrVillage=="City")
				{
					$IsCity=1;
				}
				else if($request->CityOrVillage=="Village")
				{
					$IsCity=0;
				}
				$CityIDOrVillageId=0;
				$PrabhagName=$request->Prabhags;
				if($IsCity==1)
				{
					$CityIDOrVillageId=$request->Citys;
				}
				else if($IsCity==0)
				{
					$CityIDOrVillageId=$request->Villages;
				}

			$Prabhags=Prabhag::where('PrabhagID', '=',$request->Prabhags)->get();

			$PrabhagName="";
			foreach ($Prabhags as $key => $value) {
				$PrabhagName=$value['PrabhagName'];
			}

				// Delete City
				$affectedRows = Prabhag::where('PrabhagID', '=', $request->Prabhags)->delete();
				if($affectedRows==1)
				{
					// City is Successfully Deleted
					return redirect("/delete-prabhag")->withInput()->with("success","Prabhag ".$PrabhagName." is Successfully Deleted");
				}
				else
				{
					// City Name Not Deleted
					return redirect("/delete-prabhag")->withErrors($validator)->withInput()->with("error","Can't Delete Prabhag ".$PrabhagName."");
				}
		}
	}

	// Get Prabhags by city or village id
	public function getPrabhagsByCityOrVillageId(Request $request)
	{
		$validator= Validator::make(
			array(
				"Village_Or_City_Id"=>$request->Village_Or_City_Id
				),
			array(
				"Village_Or_City_Id"=>"required",
				)
		);

		if($validator->fails())
		{
			return redirect("/edit-prabhag")->withErrors($validator)->withInput();
		//	return redirect()->intended($this->redirectPath())->withErrors($validator)->withInput();
		}
		else
		{
			$Prabhags=prabhag::where('Village_City_ID', '=',$request->Village_Or_City_Id)->get();
			echo json_encode($Prabhags);
		}

	}

	public function getPrabhagNameById(Request $request)
	{
		$validator= Validator::make(
			array(
				"PrabhagID"=>$request->PrabhagID
				),
			array(
				"PrabhagID"=>"required"
				)
		);

		if($validator->fails())
		{
			return redirect("/edit-prabhag")->withErrors($validator)->withInput();
		//	return redirect()->intended($this->redirectPath())->withErrors($validator)->withInput();
		}
		else
		{
			$Prabhags=prabhag::where('PrabhagID', '=',$request->PrabhagID)->get();
			echo json_encode($Prabhags);
		}
	}
}