<?php namespace App\Http\Controllers;
use App\state;// state model
use App\zone; // zone model
use App\district;
use App\tehsil;
use Validator;

use illuminate\Http\Request;
use illuminate\Routing\Controllers;
class TehsilController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Welcome Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders the "marketing page" for the application and
	| is configured to only allow guests. Like most of the other sample
	| controllers, you are free to modify or remove it as you desire.
	|
	*/

	/**
	 * Show the application welcome screen to the user.
	 *
	 * @return Response
	 */
	public function index()
	{
	//	echo "this is My Admin Controller";
		$data=array("pagetitle" => "Add New Tehsil | Election Management System ");
		return view('admin.new-tehsil',$data);
	}

	public function edit()
	{
	//	echo "this is My Admin Controller";
		$data=array("pagetitle" => "Edit Tehsil | Election Management System | Sterling Systems");
		return view('admin.edit-tehsil',$data);
	}

	public function delete()
	{
	//	echo "this is My Admin Controller";
		$data=array("pagetitle" => "Delete Tehsil | Election Management System | Sterling Systems");
		return view('admin.delete-tehsil',$data);
	}

	public function getTehsilNames(Request $request)
	{
		$validator=Validator::make(
			array('Districts'=>$request->districtid),
			array('Districts'=>'required')

			);
		if($validator->fails())
		{
			return redirect()->intended($this->redirectPath())->withErrors($validator)->withInput();
		}
		else
		{
			$Tehsils=tehsil::where('DistrictID', '=',$request->districtid)->get();
			echo json_encode($Tehsils);
		}
	}
}
