@extends('admin.layouts.votermainview')
@section('content') 

<script>
 
  function GetMessageCount()
  {
    var Message=$("#Message").val();
    if(document.getElementById("Marathi").checked)
    {
      var MessageLength=(Message.length)*4;
      var NoOfMessages=Math.ceil(MessageLength / 160);
      document.getElementById("MessageCount").innerHTML="Message Characters "+MessageLength+ " : Message Count : "+NoOfMessages;
    }
    else if(document.getElementById("English").checked)
    {
      var MessageLength=Message.length;
      var NoOfMessages=Math.ceil(MessageLength / 160);
      document.getElementById("MessageCount").innerHTML="Message Characters "+MessageLength+ " : Message Count : "+NoOfMessages;
    }
  }

  function loadTehsil()
  {
      DistrictId=$("#District").val();
      $.ajax({
          type: "GET",
          url: "getTehsilNames",
          data:"districtid="+DistrictId,
          dataType: "json",
          success: function(result){
               $('#Tehsil').children().remove();         
               $('#Tehsil').append($('<option>').text(" तालुका ").attr('value', ""));
               $.each(result, function(id, value) {
                  $('#Tehsil').append($('<option>').text(value.TehsilName).attr('value', value.TehsilID));
               });
            }
       });
  }

  function getCityOrVillages()
  {
      var IsCity=-1;
      if(document.getElementById("City").checked==true)
      {
        IsCity=1;
      }
      else if(document.getElementById("Village").checked==true)
      {
        IsCity=0;
      }
      var CityId=$('#CorV').val();
      var TehsilId=$('#Tehsil').val();
      // Load Cities or villages from 
       $.ajax({
            type: "GET",
            url: "loadAvailableCitiesOrVillages",
            data:"IsCity="+IsCity+"&Tehsil="+TehsilId,
            dataType: "json",
            success: function(result){
              if(IsCity==1)
              {
                $('#CorV').children().remove();         
                $('#CorV').append($('<option>').text(" शहर ").attr('value', ""));
                $.each(result, function(id, value) {
                    $('#CorV').append($('<option>').text(value.CityName).attr('value', value.CityID));
                });
              }
              else if(IsCity==0)
              {
                $('#CorV').children().remove();         
                $('#CorV').append($('<option>').text(" गाव ").attr('value', ""));
                $.each(result, function(id, value) {
                    $('#CorV').append($('<option>').text(value.VillageName).attr('value', value.VillageID));
                });
              }
            }
          });
  }

  function loadBooth1()
  {
      var IsCity=-1;
      if(document.getElementById("City").checked==true)
      {
        IsCity=1;
      }
      else if(document.getElementById("Village").checked==true)
      {
        IsCity=0;
      }
      var CityId=$('#CorV').val();
      // Load Cities or villages from 
      $.ajax({
            type: "GET",
            url: "getBoothsNumbersById",
            data:"Village_Or_City_Id="+CityId,
            dataType: "json",
            success: function(result){
                $('#Booth').children().remove();         
                $('#Booth').append($('<option>').text(" बूथ ").attr('value', ""));
                $.each(result, function(id, value) {
                    $('#Booth').append($('<option>').text(value.BoothNumber).attr('value', value.BoothID));
              });
            }
       }); 
  }
  $(document).ready(function() {
     $("#loading").hide();
     $("#CorV").select2();
     $("#PrabhagOrWard").select2();
     $("#District").select2();
     $("#Tehsil").select2();
     $("#Booth").select2();
     $("#SurnameSelect2").select2();
     $("#CastSelect2").select2();
 });

  function loadSurnamesOnCheck()
  {
      $("#loading").show();
      if(document.getElementById("SurnameCheck").checked==true)
      {
          var DistrictID=$("#District").val();
          var TehsilID=$("#Tehsil").val();
          var CorV_ID=$("#CorV").val();
          var Booth=$("#Booth").val();
          var IsCity=-1;
          if(document.getElementById("City").checked==true)
          {
            IsCity=1;
          }
          else if(document.getElementById("Village").checked==true)
          {
            IsCity=0;
          }
          $.ajax({
            type: "GET",
            url: "loadSurnamesOnCheck",
            data:"DistrictID="+DistrictID+"&TehsilID="+TehsilID+"&CorV_ID="+CorV_ID+"&IsCity="+IsCity+"&BoothId="+Booth,
            dataType: "json",
            success: function(result){
                $('#SurnameSelect2').children().remove();         
                $('#SurnameSelect2').append($('<option>').text(" आडनाव ").attr('value', ""));
                $.each(result, function(id, value) {
                    $('#SurnameSelect2').append($('<option>').text(value.MarathiLastName +" ("+ value.Total +" )").attr('value', value.MarathiLastName));
                });
                $("#loading").hide();
            }
          });
      }
      else
      {
          $('#SurnameSelect2').children().remove();
          $('#SurnameSelect2').append($('<option>').text(" आडनाव ").attr('value', ""));
          $("#loading").hide();
      }
  }

  function GetMobileNumbersCount()
  {
    var DistrictID=$("#District").val();
    var TehsilID=$("#Tehsil").val();
    var City_VillageID=$("#CorV").val();
    var IsCity=-1;
    if(document.getElementById("City").checked==true)
    {
      IsCity=1;
    }
    else if(document.getElementById("Village").checked==true)
    {
      IsCity=0;
    }
    var BoothID=$("#Booth").val();
    var SurnameCheck="";
    if(document.getElementById("SurnameCheck").checked==true)
    {
      SurnameCheck=$("#SurnameCheck").val();
    }
    var SurnameSelect2=$("#SurnameSelect2").val();
    var CastCheck="";
    if(document.getElementById("CastCheck").checked==true)
    {
      CastCheck=$("#CastCheck").val();
    }
    var CastSelect2=$("#CastSelect2").val();
    var EducationCheck="";
    if(document.getElementById("EducationCheck").checked==true)
    {
      EducationCheck=$("#EducationCheck").val();
    }
    var EducationSelect2=$("#EducationSelect2").val();

    $("#loading").show();
    $.ajax({
        type: "GET",
        url: "GetVoterCountForAllInOne",
        data:"DistrictID="+DistrictID+"&TehsilID="+TehsilID+"&IsCity="+IsCity+
        "&City_VillageID="+City_VillageID+"&BoothID="+BoothID+"&SurnameCheck="+SurnameCheck+"&SurnameSelect2="+SurnameSelect2+
        +"&CastCheck="+CastCheck+"&CastSelect2="+CastSelect2+"&EducationCheck="+EducationCheck
        +"&EducationSelect2="+EducationSelect2,
        dataType: "json",
        success: function(result){
           $("#loading").hide();
           $("#Count").val(result.MobileNumbersCount);
           $("#ValidCount").val(result.ValidMobileNumbersCount);
        }
      });
  }
</script>
  <div class="qv rc sm sp" style="margin-top:3%;">
    <div class="qw">
      @if(Session::has('Name'))
        <span style="margin-left:70px;"> <strong> {{ $pagetitle }} </strong> </span>
        <span style="margin-top:-7px;margin-left:55%;">Welcome, {{ Session::get('Name') }}
        <a href='dashboard' class='cg ts fx green' style="margin-left:80px;"> Go To Dashboard </a>
      @endif
    </div>
  </div>
  <div class="row">
      <div class="col-lg-12">
        <div class="col-lg-4"> </div>
        <div class="col-lg-4">
          @if(Session::has('success'))
            <div class="alert pv alert-dismissible alert-success" role="alert">
               <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
               <font style="color:#f5f5f5"> {{ Session::get('success') }}  </font>
            </div>
          @elseif(Session::has('error'))
            <div class="alert pv alert-dismissible alert-warning" role="alert">
               <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
               <font style="color:#f5f5f5"> {{ Session::get('error') }}  </font>
            </div>
          @endif
         </div>
        <div class="col-lg-4"> </div>                
      </div>
  </div>
  <form action="SendSMSToVoterForAllInOne" role="form" id="SMSForm" name="SMSForm">
    <div class="row">
      <div class="col-lg-10 col-md-offset-1">
        <div class="by amt" style="width:200%;">
          <div class="gc">
            <div class="gz">
              <div class="ca qo anx ">
                <div class="qf b aml">
                  <div class="row" style="margin-top:15px;">
                    <div class="col-lg-12">
                       <div class="col-lg-2">
                          <select id="District" name="District" onchange="loadTehsil();loadSurnamesOnCheck();" class="form-control">
                            <option value=""> जिल्हा </option>
                            @foreach($Districts as $District)
                               @if($SelectDistrict==$District->DistrictID )
                                  <option value="{{ $District->DistrictID }}" selected>{{ $District->DistrictName }}</option>
                                @else
                                 <option value="{{ $District->DistrictID }}">{{ $District->DistrictName }}</option>
                                 @endif
                            @endforeach
                          </select>
                      </div>

                      <div class="col-lg-2">
                          <select id="Tehsil" name="Tehsil" onchange="loadSurnamesOnCheck();" class="form-control">
                            <option value="">  तालुका </option>
                               @foreach($Tehsils as $Tehsil)
                                 @if($SelectedTehsil==$Tehsil->TehsilID )
                                    <option value="{{ $Tehsil->TehsilID }}" selected>{{ $Tehsil->TehsilName }}</option>
                                  @else
                                    <option value="{{ $Tehsil->TehsilID }}">{{ $Tehsil->TehsilName }}</option>
                                  @endif
                               @endforeach
                          </select>
                      </div>

                      <div class="col-lg-2">
                         <div class="bv" data-example-id="" style="margin-top:5px;">
                            @if($IsCity==-1)
                              <div class="ew ug ul">
                                <label>
                                  <input type="radio" id="City" name="CityOrVillage" value="City" onclick="getCityOrVillages();loadSurnamesOnCheck();">  
                                  <span class="uh"></span>
                                   शहर
                                </label>
                              </div>
                              <div class="ew ug ul">
                                 <label>
                                   <input type="radio" name="CityOrVillage" id="Village" value="Village" onclick="getCityOrVillages();loadSurnamesOnCheck();"> 
                                    <span class="uh"></span>
                                      गाव
                                   </label>
                              </div>
                            @elseif($IsCity==1)
                              <div class="ew ug ul">
                                <label>
                                  <input type="radio" id="City" name="CityOrVillage" value="City" onclick="getCityOrVillages();loadSurnamesOnCheck();" checked>  
                                  <span class="uh"></span>
                                   शहर
                                </label>
                              </div>
                            <div class="ew ug ul">
                                 <label>
                                   <input type="radio" name="CityOrVillage" id="Village" value="Village" onclick="getCityOrVillages();loadSurnamesOnCheck();"> 
                                    <span class="uh"></span>
                                      गाव
                                   </label>
                            </div>
                            @elseif($IsCity==0)
                              <div class="ew ug ul">
                                <label>
                                  <input type="radio" id="City" name="CityOrVillage" value="City" onclick="getCityOrVillages();loadSurnamesOnCheck();" >  
                                  <span class="uh"></span>
                                   शहर
                                </label>
                              </div>
                              <div class="ew ug ul">
                                 <label>
                                   <input type="radio" name="CityOrVillage" id="Village" value="Village" onclick="getCityOrVillages();loadSurnamesOnCheck();" checked>
                                    <span class="uh"></span>
                                      गाव
                                   </label>
                              </div>
                            @endif
                          </div>
                      </div>

                      <div class="col-lg-2">
                          <select id="CorV" name="CorV" onchange="loadBooth1();loadSurnamesOnCheck();" class="form-control">
                            <option value=""> शहर / गाव </option>
                              @if($IsCity==1)
                                 @foreach($Cities_Villages as $City_Village)
                                   @if($SelectedCityOrVillage==$City_Village->CityID )
                                      <option value="{{ $City_Village->CityID }}" selected>{{ $City_Village->CityName }}</option>
                                    @else
                                      <option value="{{ $City_Village->CityID }}">{{ $City_Village->CityName }}</option>
                                    @endif
                                 @endforeach
                              @elseif($IsCity==0)
                                @foreach($Cities_Villages as $City_Village)
                                   @if($SelectedCityOrVillage==$City_Village->VillageID )
                                      <option value="{{ $City_Village->VillageID }}" selected>{{ $City_Village->VillageName }}</option>
                                    @else
                                      <option value="{{ $City_Village->VillageID }}">{{ $City_Village->VillageName }}</option>
                                    @endif
                                 @endforeach
                              @endif
                          </select>
                      </div>

                      <div class="col-lg-2">
                          <select id="Booth" name="Booth" onchange="loadSurnamesOnCheck();" class="form-control">
                            <option value=""> बूथ </option>
                             @foreach($Booths as $Booth)
                                <option value="{{ $Booth->BoothID }}">{{ $Booth->BoothNumber }}</option>
                              @endforeach
                          </select>
                      </div>
                    </div>
                  </div>
                  <div class="row" style="margin-top:25px;">
                    <div class="col-md-12">
                      <div class="col-md-1">
                        <div class="bv" data-example-id="" style="margin-left:40px;">
                          <div class="ev ug uk">
                            <label>
                              <input type="checkbox" id="SurnameCheck" name="SurnameCheck" onclick="loadSurnamesOnCheck()" value="1" >
                              <span class="uh"></span>
                            </label>
                          </div>
                        </div>
                      </div>
                      <div class="col-md-2 ">
                          <select id="SurnameSelect2" name="SurnameSelect2" class="form-control">
                            <option value=""> आडनाव </option>
                          </select>
                      </div>

                      <div class="col-md-1">
                        <div class="bv" data-example-id="" style="margin-left:40px;">
                          <div class="ev ug uk">
                            <label>
                              <input type="checkbox" id="CastCheck" name="CastCheck" value="1">
                              <span class="uh"></span>
                            </label>
                          </div>
                        </div>
                      </div>
                      <div class="col-md-2">
                         <select id="CastSelect2" name="CastSelect2" class="form-control select2-select" style="width:100%;">
                          <option value=""> जात </option>
                           @foreach($Casts as $Cast)
                              <option value="{{ $Cast->CastName }}">{{ $Cast->CastName }}</option>
                            @endforeach
                        </select>
                      </div>
                      <div class="col-md-1">
                        <div class="bv" data-example-id="" style="margin-left:40px;">
                          <div class="ev ug uk">
                            <label>
                              <input type="checkbox" id="EducationCheck" name="EducationCheck" value="1">
                              <span class="uh"></span>
                            </label>
                          </div>
                        </div>
                      </div>
                      <div class="col-md-2 ">
                          <select id="EducationSelect2" name="EducationSelect2" class="form-control">
                            <option value=""> शिक्षण </option>
                            <option value="दहावी">   दहावी </option> 
                            <option value="बारावी">   बारावी </option> 
                            <option value="डिप्लोमा">   डिप्लोमा </option> 
                            <option value="पदवीधर">   पदवीधर </option> 
                            <option value="पदव्युत्तर" >   पदव्युत्तर </option> 
                            <option value="इतर"> इतर </option>
                          </select>
                      </div>
                    </div>
                  </div>

                  <div class="row" style="margin-top:25px;">
                    <div class="col-lg-1 col-md-offset-1">
                        <div class="col-lg-2">
                          <input type="button" value="दाखवा" onclick="GetMobileNumbersCount();" class="cg fp">  </input>
                        </div>
                    </div>
                  </div>
                  <div class="row" style="margin-top:12px;">
                    <div class="col-lg-8 col-md-offset-3">
                      <div class="col-lg-2">
                         <strong> मतदार संख्या </strong>
                      </div>
                      <div class="col-lg-3">
                        <input type="text" id="Count" name="Count" class="form-control" placeholder="मतदार संख्या" readonly></input>
                      </div>
                      <div class="col-lg-2">
                         <strong> वैध मोबाईल नंबर्स</strong>
                      </div>
                      <div class="col-lg-3">
                        <input type="text" id="ValidCount" name="ValidCount" class="form-control" placeholder=" वैध मोबाईल नंबर्स " readonly></input>
                      </div>                      
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row"  style="margin-left:12px;">
      <div class="col-lg-12">
        <div class="col-lg-5"></div>
        <div class="col-lg-2"> <img src="{!! asset('theme/assets/images/loader7.gif') !!}" id="loading" name="loading">  </div>
        <div class="col-lg-5"></div>                
      </div>
    </div>
   	<div class="row">
   		<div class="col-lg-6 col-md-offset-3">
		  <div class="by amt" style="width:200%;">
		    <div class="gc">
		      <div class="gz">
		        <div class="ca qo anx ">
			        <div class="qf b aml">
                <div class="row" style="margin-top:15px;"> <!-- Route Type -->
                  <div class="col-lg-12">
                    <div class="col-lg-4">
                      Route Type
                    </div>
                    <div class="col-lg-8">
                      <div class="bv" data-example-id="" >
                        <div class="ew ug ul">
                            <label>
                                <input type="radio" id="TranscationalRoute" name="RouteType" value="T" checked>
                                <span class="uh"></span>
                                Transcational
                            </label>
                        </div>
                        <div class="ew ug ul">
                            <label>
                                <input type="radio" id="PromotionalRoute" name="RouteType" value="P" >
                                <span class="uh"></span>
                                Promotional
                            </label>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row" style="margin-top:15px;">
  			        	<div class="col-lg-12">
                    <div class="col-lg-4">
                      Sender ID
                    </div>
                    <div class="col-lg-8">
                      <select id="SenderID" name="SenderID" class="form-control">
                        <option value=""> Sender ID </option>
                        @foreach($SenderIDs as $senders)
                          <option value="{{ $senders->SenderID }}"> {{ $senders->SenderID }} </option>
                        @endforeach
                      </select>
                    </div>
                  </div>
                </div>
               <!-- <input type="hidden" name="File" id="File" -->
                <div class="row" style="margin-top:15px;">
                  <div class="col-lg-12">
                    <div class="col-lg-4">
                        Message Language
                    </div>
                    <div class="col-lg-8">
                        <div class="bv" style="margin-top:5px;">
                        <div class="ew ug ul">
                          <label>
                            <input type="radio" id="English" name="MessageLanguage" value="0" >  
                            <span class="uh"></span>
                             English
                          </label>
                        </div>
                        <div class="ew ug ul">
                           <label>
                             <input type="radio" id="Marathi" name="MessageLanguage" value="2"> 
                              <span class="uh"></span>
                                Marathi
                             </label>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row" style="margin-top:15px;">
                  <div class="col-lg-12">
                    <div class="col-lg-4">

                    </div>
                    <div class="col-lg-8">
                        <a href="http://www.marathi.sterlingsys.in" target="_blank">
                          Click to Type Marathi Message
                        </a>                        
                    </div>
                  </div>
                </div>
                <div class="row" style="margin-top:15px;">
                  <div class="col-lg-12">
                    <div class="col-lg-4">
                      Your Message
                    </div>
                    <div class="col-lg-8">
                        <textarea id="Message" name="Message" rows="4" cols="30" onkeyup="GetMessageCount();" class="form-control" placeholder="Your Message"></textarea>
                    </div>
                  </div>
                </div>
                <div class="row" style="margin-top:15px;">
                  <div class="col-lg-12">
                    <div class="col-lg-4">
                    </div>
                    <div class="col-lg-8">
                        <span id="MessageCount"> </span>
                    </div>
                  </div>
                </div>
                <div class="row" style="margin-top:15px;">
                  <div class="col-lg-12">
                    <div class="col-lg-4">
                    </div>
                    <div class="col-lg-8">
                        <input type="submit" value=" Send SMS" class="cg fp"> </input>
                    </div>
                  </div>
                </div>
			        </div>
		        </div>
		      </div>
		    </div>
		  </div>
   		</div>
   	</div>
   </form>

  <script>
   $(document).ready(function() {
      //$('#Final_Numbers').DataTable();
      $('#SMSForm')
        .formValidation({
            framework: 'bootstrap',
            icon: {
                valid: 'glyphicon glyphicon-ok',
                invalid: 'glyphicon glyphicon-remove',
                validating: 'glyphicon glyphicon-refresh'
            },
            // This option will not ignore invisible fields which belong to inactive panels
            excluded: ':disabled',
            fields: {
                Message: {
                    validators: {
                        notEmpty: {
                            message: 'The Message is required'
                        }
                    }
                },
                MessageLanguage: {
                    validators: {
                        notEmpty: {
                            message: 'The Message Language is required'
                        }
                    }
                },
                SenderID: {
                    validators: {
                        notEmpty: {
                            message: 'The Sender ID is required'
                        }
                    }
                }
              }
        });

    function validateTab(index) {
       var fv   = $('#SMSForm').data('formValidation'), // FormValidation instance
        // The current tab
        $tab = $('#SMSForm');

        // Validate the container
        fv.validateContainer($tab);

        var isValidStep = fv.isValidContainer($tab);
        if (isValidStep === false || isValidStep === null) {
            // Do not jump to the target tab
            return false;
        }
        return true;
    }   
  });
</script>   
<style>
.pagination {
  display: inline-block;
  padding-left: 0;
  margin-top: 1rem;
  margin-bottom: 1rem;
  border-radius: .25rem;
}

.page-item {
  display: inline;
}

.page-item:first-child .page-link {
  margin-left: 0;
  border-top-left-radius: .25rem;
  border-bottom-left-radius: .25rem;
}

.page-item:last-child .page-link {
  border-top-right-radius: .25rem;
  border-bottom-right-radius: .25rem;
}

.page-item.active .page-link, .page-item.active .page-link:focus, .page-item.active .page-link:hover {
  z-index: 2;
  color: #fff;
  cursor: default;
  background-color: #0275d8;
  border-color: #0275d8;
}

.page-item.disabled .page-link, .page-item.disabled .page-link:focus, .page-item.disabled .page-link:hover {
  color: #818a91;
  cursor: not-allowed;
  background-color: #fff;
  border-color: #ddd;
}

.page-link {
  position: relative;
  float: left;
  padding: .5rem .75rem;
  margin-left: -1px;
  line-height: 1.5;
  color: #0275d8;
  text-decoration: none;
  background-color: #fff;
  border: 1px solid #ddd;
}

.page-link:focus, .page-link:hover {
  color: #014c8c;
  background-color: #eceeef;
  border-color: #ddd;
}

.pagination-lg .page-link {
  padding: .75rem 1.5rem;
  font-size: 1.25rem;
  line-height: 1.333333;
}

.pagination-lg .page-item:first-child .page-link {
  border-top-left-radius: .3rem;
  border-bottom-left-radius: .3rem;
}

.pagination-lg .page-item:last-child .page-link {
  border-top-right-radius: .3rem;
  border-bottom-right-radius: .3rem;
}

.pagination-sm .page-link {
  padding: .275rem .75rem;
  font-size: .875rem;
  line-height: 1.5;
}

.pagination-sm .page-item:first-child .page-link {
  border-top-left-radius: .2rem;
  border-bottom-left-radius: .2rem;
}

.pagination-sm .page-item:last-child .page-link {
  border-top-right-radius: .2rem;
  border-bottom-right-radius: .2rem;
}

 .pagination{display:inline-block;padding-left:0;margin:20px 0;border-radius:4px}
 .pagination>li{display:inline}
 .pagination>li>a,.pagination>li>span{position:relative;float:left;padding:6px 12px;margin-left:-1px;line-height:1.42857143;color:#337ab7;text-decoration:none;background-color:#fff;border:1px solid #ddd}
 .pagination>li:first-child>a,.pagination>li:first-child>span{margin-left:0;border-top-left-radius:4px;border-bottom-left-radius:4px}
 .pagination>li:last-child>a,.pagination>li:last-child>span{border-top-right-radius:4px;border-bottom-right-radius:4px}
 .pagination>li>a:focus,.pagination>li>a:hover,.pagination>li>span:focus,.pagination>li>span:hover{color:#23527c;background-color:#eee;border-color:#ddd}
 .pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover{z-index:2;color:#fff;cursor:default;background-color:#337ab7;border-color:#337ab7}.pagination>.disabled>a,.pagination>.disabled>a:focus,.pagination>.disabled>a:hover,.pagination>.disabled>span,.pagination>.disabled>span:focus,.pagination>.disabled>span:hover{color:#777;cursor:not-allowed;background-color:#fff;border-color:#ddd}.pagination-lg>li>a,.pagination-lg>li>span{padding:10px 16px;font-size:18px}.pagination-lg>li:first-child>a,.pagination-lg>li:first-child>span{border-top-left-radius:6px;border-bottom-left-radius:6px}.pagination-lg>li:last-child>a,.pagination-lg>li:last-child>span{border-top-right-radius:6px;border-bottom-right-radius:6px}.pagination-sm>li>a,.pagination-sm>li>span{padding:5px 10px;font-size:12px}.pagination-sm>li:first-child>a,.pagination-sm>li:first-child>span{border-top-left-radius:3px;border-bottom-left-radius:3px}
 .pagination-sm>li:last-child>a,.pagination-sm>li:last-child>span{border-top-right-radius:3px;border-bottom-right-radius:3px}

</style>
@endsection