<?php namespace App\Http\Controllers;

use App\state;
use App\zone;
use App\district;
use App\tehsil;
use App\city;
use Validator;
use illuminate\Http\Request;
use illuminate\Routing\Controllers;

class CityController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Welcome Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders the "marketing page" for the application and
	| is configured to only allow guests. Like most of the other sample
	| controllers, you are free to modify or remove it as you desire.
	|
	*/

	/**
	 * Show the application welcome screen to the user.
	 *
	 * @return Response
	 */
	public function index()
	{
	//	echo "this is My Admin Controller";

		$States=state::where('Status', '=', 1)->get();

		$data=array("pagetitle" => "Add New City | Election Management System","States"=>$States);
		return view('admin.new-city',$data);
	}

	public function edit()
	{
	//	echo "this is My Admin Controller";
		$States=state::where('Status', '=', 1)->get();
		$data=array("pagetitle" => "Edit City | Election Management System | Sterling Systems","States"=>$States);
		return view('admin.edit-city',$data);
	}

	public function delete()
	{
	//	echo "this is My Admin Controller";
		$States=state::where('Status', '=', 1)->get();
		$data=array("pagetitle" => "Delete City | Election Management System | Sterling Systems","States"=>$States);
		return view('admin.delete-city',$data);
	}

	public function SaveCity(Request $request)
	{
		$validator= Validator::make(
			array(
				"States"=>$request->States,
				"Zones"=>$request->Zones,
				"Districts"=>$request->Districts,
				"Tehsils"=>$request->Tehsils,
				"City"=>$request->City
				),
			array(
				"States"=>"required",
				"Zones"=>"required",
				"Districts"=>"required",
				"Tehsils"=>"required",
				"City"=>"required"
				)
			);
		if($validator->fails())
		{
			return redirect("/new-city")->withErrors($validator)->withInput();
		}
		else
		{
			// Insert City to db

			// Check Duplicate Entry

			$DuplicateCity=city::where('TehsilID', '=',$request->Tehsils)->where('CityName','=',"$request->City")->get();
			if(count($DuplicateCity)==0)
			{
				$City=new city;
				$City->CityName=$request->City;
				$City->Status=1;
				$City->TehsilId=$request->Tehsils;
				$City->save();
				$insertedId = $City->id;
				if($insertedId>0)
				{
					 return redirect("/new-city")->withErrors($validator)->withInput()->with("success","City ".$request->City." is Successfully Saved");
				}
				else
				{
					return redirect("/new-city")->withErrors($validator)->withInput()->with("error","Can't Save City ".$request->City."");
				}			
			}
			else
			{
				return redirect("/new-city")->withErrors($validator)->withInput()->with("error","City ".$request->City." is Already Saved ");
			}
		}

	}

	public function getCityNames(Request $request)
	{
		$validator= Validator::make(
			array(
				"Tehsils"=>$request->tehsilid
				),
			array(
				"Tehsils"=>"required",
				)
		);

		if($validator->fails())
		{
			return redirect("/edit-city")->withErrors($validator)->withInput();
		//	return redirect()->intended($this->redirectPath())->withErrors($validator)->withInput();
		}
		else
		{
			$Cities=city::where('TehsilID', '=',$request->tehsilid)->get();
			echo json_encode($Cities);
		}
	}

	// Load Cityname by id
	public function getCityNameById(Request $request)
	{
		$validator= Validator::make(
			array(
				"Citys"=>$request->cityid
				),
			array(
				"Citys"=>"required",
				)
		);

		if($validator->fails())
		{
		//	return redirect("/edit-city")->withErrors($validator)->withInput();
			return redirect()->intended($this->redirectPath())->withErrors($validator)->withInput();
		}
		else
		{
			$Cities=city::where('CityID', '=',$request->cityid)->get();
			echo json_encode($Cities);
		}
	}

	// Edit City
	public function EditCity(Request $request)
	{
		$validator= Validator::make(
			array(
				"Citys"=>$request->Citys,
				"City"=>$request->City,
				"Tehsils"=>$request->Tehsils,
				"Districts"=>$request->Districts,
				"Zones"=>$request->Zones,
				"States"=>$request->States
				),
			array(
				"Citys"=>"required",
				"City"=>"required",
				"Tehsils"=>"required",
				"Districts"=>"required",
				"Zones"=>"required",
				"States"=>"required"				
				)
		);

		if($validator->fails())
		{
		//	return redirect("/edit-city")->withErrors($validator)->withInput();
			return redirect()->intended($this->redirectPath())->withErrors($validator)->withInput();
		}
		else
		{
			// Chk if Entered City Name is same or not
			$CityChkExists=city::where('CityID', '=',$request->cityid)->where('CityName', '=',$request->City)->get();
			if(count($CityChkExists)==0)
			{
				// chk if City is already Available
				$DuplicateCity=city::where('TehsilID', '=',$request->Tehsils)->where('CityName','=',"$request->City")->get();
				if(count($DuplicateCity)==0)
				{
					//Update City Here

					$affectedRows = city::where('CityID', '=', $request->Citys)->update(['CityName' => $request->City]);
					if($affectedRows==1)
					{
						return redirect("/edit-city")->withErrors($validator)->withInput()->with("success","City ".$request->City." is Successfully Updated");
					}
					else
					{
						return redirect("/edit-city")->withErrors($validator)->withInput()->with("error"," City ".$request->City." is Already Saved");				
					}
				}
				else
				{
					// Duplicate City
					return redirect("/edit-city")->withErrors($validator)->withInput()->with("error"," City ".$request->City." is Already Saved");
				}
			}
			else
			{
				// City is Already ( Entered City name is Same )
				return redirect("/edit-city")->withErrors($validator)->withInput()->with("error","You Entered Same City ".$request->City."");
			}
		}
	}

	public function DeleteCity(Request $request)
	{
		$validator=Validator::make(
			array(
				'Citys'=>$request->Citys,
				'States'=>$request->States,
				'Zones'=>$request->Zones,
				'Districts'=>$request->Districts,
				'Tehsils'=>$request->Tehsils
			),
			array(
				'Citys'=>"required",
				'States'=>"required",
				'Zones'=>"required",
				'Districts'=>"required",
				'Tehsils'=>"required"
				)
			);

		if($validator->fails())
		{
return redirect("/delete-city")->withErrors($validator)->withInput();
		}
		else
		{
			// chk City if present

			$CityChkExists=city::where('CityID', '=',$request->Citys)->get();
			$Cities=city::where('CityID', '=',$request->Citys)->get();

			$CityName="";
			foreach ($Cities as $key => $value) {
				$CityName=$value['CityName'];
			}

			if(count($CityChkExists)>0)
			{
				// Delete City
				$affectedRows = city::where('CityID', '=', $request->Citys)->delete();
				if($affectedRows==1)
				{
					// City is Successfully Deleted
					return redirect("/delete-city")->withInput()->with("success","City ".$CityName." is Successfully Deleted");
				}
				else
				{
					// City Name Not Deleted
					return redirect("/delete-city")->withErrors($validator)->withInput()->with("error","Can't Delete City ".$CityName."");
				}

			}
			else
			{
				// City is Not Present
				return redirect("/delete-city")->withErrors($validator)->withInput()->with("error","City is Not Present in System ");
			}
		}
	}
}