<?php namespace App\Http\Controllers;
use App\state;
use App\zone;
use App\district;
use App\tehsil;
use App\village;
use Validator;
use illuminate\Http\Request;
use illuminate\Routing\Controllers;
class VillageController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Welcome Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders the "marketing page" for the application and
	| is configured to only allow guests. Like most of the other sample
	| controllers, you are free to modify or remove it as you desire.
	|
	*/

	/**
	 * Show the application welcome screen to the user.
	 *
	 * @return Response
	 */
	public function index()
	{
	//	echo "this is My Admin Controller";
		$States=state::where('Status', '=', 1)->get();
		$data=array("pagetitle" => "Add New Village | Election Management System ","States"=>$States);

		return view('admin.new-village',$data);
	}

	public function edit()
	{
	//	echo "this is My Admin Controller";
		$States=state::where('Status', '=', 1)->get();
		$data=array("pagetitle" => "Edit Village | Election Management System | Sterling Systems","States"=>$States);
		return view('admin.edit-village',$data);
	}

	public function delete()
	{
		//	echo "this is My Admin Controller";
		$States=state::where('Status', '=', 1)->get();
		$data=array("pagetitle" => "Delete Village | Election Management System | Sterling Systems","States"=>$States);
		return view('admin.delete-village',$data);
	}

	// Public Village Names by Tehsil

	public function getVillageNames(Request $request)
	{
		$validator= Validator::make(
			array(
				"Tehsils"=>$request->tehsilid
				),
			array(
				"Tehsils"=>"required",
				)
		);

		if($validator->fails())
		{
		//	return redirect("/edit-city")->withErrors($validator)->withInput();
			return redirect()->intended($this->redirectPath())->withErrors($validator)->withInput();
		}
		else
		{
			$Villages=village::where('TehsilID', '=',$request->tehsilid)->get();
			echo json_encode($Villages);
		}
	}

	// Get Village name By ID
	public function getVillageNameById(Request $request)
	{
		$validator= Validator::make(
			array(
				"Villages"=>$request->villageid,
				),
			array(
				"Villages"=>"required",
				)
		);

		if($validator->fails())
		{
		//	return redirect("/edit-city")->withErrors($validator)->withInput();
			return redirect()->intended($this->redirectPath())->withErrors($validator)->withInput();
		}
		else
		{
			$Village=village::where('VillageID', '=',$request->villageid)->get();
			echo json_encode($Village);
		}
	}

	public function SaveVillage(Request $request)
	{
		$Validator=Validator::make(
			array(
				"Village"=>$request->Village,
				"Tehsils"=>$request->Tehsils,
				"Districts"=>$request->Districts,
				"Zones"=>$request->Zones,
				"States"=>$request->States
				),
			array(
				"Village"=>"required",
				"Tehsils"=>"required",
				"Districts"=>"required",
				"Zones"=>"required",
				"States"=>"required"
				)
			);
		if($Validator->fails())
		{
			return redirect()->intended($this->redirectPath())->withErrors($Validator)->withInput();
		}
		else
		{
			// Check Village is already Present in system or not
			$DuplicateVillage=village::where('TehsilID', '=',$request->Tehsils)->where('VillageName','=',"$request->Village")->get();
			if(count($DuplicateVillage)==0)
			{
				$Village=new village;
				$Village->VillageName=$request->Village;
				$Village->Status=1;
				$Village->TehsilId=$request->Tehsils;
				$Village->save();
				$insertedId = $Village->id;
				if($insertedId>0)
				{
					 return redirect("/new-village")->withErrors($Validator)->withInput()->with("success","Village ".$request->Village." is Successfully Saved");
				}
				else
				{
					return redirect("/new-village")->withErrors($Validator)->withInput()->with("error","Can't Save Village ".$request->Village."");
				}			
			}
			else
			{
				return redirect("/new-village")->withErrors($Validator)->withInput()->with("error","Village ".$request->Village." is Already Saved ");
			}
		}
	}

	public function EditVillage(Request $request)
	{
			$validator= Validator::make(
			array(
				"Villages"=>$request->Villages,
				"Village"=>$request->Village,
				"Tehsils"=>$request->Tehsils,
				"Districts"=>$request->Districts,
				"Zones"=>$request->Zones,
				"States"=>$request->States
				),
			array(
				"Villages"=>"required",
				"Village"=>"required",
				"Tehsils"=>"required",
				"Districts"=>"required",
				"Zones"=>"required",
				"States"=>"required"				
				)
		);

		if($validator->fails())
		{
			return redirect("/edit-village")->withErrors($validator)->withInput();
			//return redirect()->intended($this->redirectPath())->withErrors($validator)->withInput();
		}
		else
		{
			// Chk if Entered City Name is same or not
			$VillageChkExists=village::where('VillageID', '=',$request->Villages)->where('VillageName', '=',$request->Village)->get();
			if(count($VillageChkExists)==0)
			{
				// chk if Village is already Available
				$DuplicateVillage=village::where('TehsilID', '=',$request->Tehsils)->where('VillageName','=',"$request->Village")->get();
				if(count($DuplicateVillage)==0)
				{
					//Update City Here

					$affectedRows = village::where('VillageID', '=', $request->Villages)->update(['VillageName' => $request->Village]);
					if($affectedRows==1)
					{
						return redirect("edit-village")->withErrors($validator)->withInput()->with("success","Village ".$request->Village." is Successfully Updated");
					}
					else
					{
						return redirect("edit-village")->withErrors($validator)->withInput()->with("error"," Village ".$request->Village." is Already Saved");				
					}
				}
				else
				{
					// Duplicate City
					return redirect("edit-village")->withErrors($validator)->withInput()->with("error"," Village ".$request->Village." is Already Saved");
				}
			}
			else
			{
				// City is Already ( Entered City name is Same )
				return redirect("edit-village")->withErrors($validator)->withInput()->with("error","You Entered Same Village ".$request->Village."");
			}
		}
	}

	public function DeleteVillage(Request $request)
	{
		$validator=Validator::make(
			array(
				'Villages'=>$request->Villages,
				'States'=>$request->States,
				'Zones'=>$request->Zones,
				'Districts'=>$request->Districts,
				'Tehsils'=>$request->Tehsils
			),
			array(
				'Villages'=>"required",
				'States'=>"required",
				'Zones'=>"required",
				'Districts'=>"required",
				'Tehsils'=>"required"
				)
			);

		if($validator->fails())
		{
			return redirect("/delete-village")->withErrors($validator)->withInput();
		}
		else
		{
			// chk City if present

			$VillageChkExists=village::where('VillageID', '=',$request->Villages)->get();
			// Get VillageName
			$Villages=village::where('VillageId', '=',$request->Villages)->get();

			$VillageName="";
			foreach ($Villages as $key => $value) {
				$VillageName=$value['VillageName'];
			}

			if(count($VillageChkExists)>0)
			{
				// Delete City
				$affectedRows = village::where('VillageID', '=', $request->Villages)->delete();
				if($affectedRows==1)
				{
					// City is Successfully Deleted
					return redirect("/delete-village")->withInput()->with("success","Village ".$VillageName." is Successfully Deleted");
				}
				else
				{
					// City Name Not Deleted
					return redirect("/delete-village")->withErrors($validator)->withInput()->with("error","Can't Delete Village ".$VillageName."");
				}
			}
			else
			{
				// City is Not Present
				return redirect("/delete-city")->withErrors($validator)->withInput()->with("error","Village is Not Present in System ");
			}
		}
	}
}