<?php namespace App\Http\Controllers;


use Validator;
use DB;
use Auth;
use Session;
use App\User; // This is User Model

use App\state;
use App\zone;
use App\district;
use App\tehsil;
use App\village;
use App\booth;
use App\city;
use App\voter;
use App\androidapp;
use App\appusersvoters;

use illuminate\Http\Request;
use illuminate\Routing\Controllers;

class AdminController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Welcome Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders the "marketing page" for the application and
	| is configured to only allow guests. Like most of the other sample
	| controllers, you are free to modify or remove it as you desire.
	|
	*/

	/**
	 * Show the application welcome screen to the user.
	 *
	 * @return Response
	 */
	public function index()
	{
		$data=array("pagetitle" => "  लॉग इन  ");
		return view('admin.login',$data);
	}

	public function Login()
	{
		$data=array("pagetitle" => " लॉग इन  ");
		return view('admin.login',$data);
	}

	public function logout()
	{
		// Logout
		  Auth::logout();
		  return redirect()->intended('Login');
	}

	public function chklogin(Request $request)
	{
		$validator= Validator::make(
			array(
				"Username"=>$request->Username,
				"Password"=>$request->Password
				),
			array(
				"Username"=>"required|email",
				"Password"=>"required|min:3|max:15",
				)
			);

		if($validator->fails())
		{
			return redirect("/")->withErrors($validator)->withInput();
		}
		else
		{

			/* $2y$10$db.HfNo2b9EncnfwALO/Eepqc9C.UQIcnZrXzRvY6h0TZYh1lLDTO str for 123 */

			//$Password=bcrypt($request->Password);//Hash::make($request->Password);
			//echo $Password;
			if(Auth::attempt(['email' => $request->Username, 'password' => $request->Password])) // Authenticate User Login
				{
					// Get Name and Send it with session
					$UserDetails=User::where('email', '=', $request->Username)->get();
					$Name="";
					foreach ($UserDetails as $key => $value) {
						$Name=$value['name'];
					}
					//session()->regenerate();
					Session::put('Name', $Name);
					session(['key' => 'value']);

					return redirect("/dashboard")->withInput();
				}
				else
				{
					//return redirect()->intended('dashboard');
					//$p=bcrypt($request->Password);
					return redirect("/")->withErrors($validator)->withInput()->with("error","Invalid Username Or Password !");
				}	
		}
	}

	public function dashboard()
	{
		$TotalAppUsers=androidapp::where("Status","=",1)->count();
		$Voters=voter::where("SrNo","!=","")->count();
		$MobileNumberCount=voter::where("MobileNumber","!=","")->count();
		$WhatsAppMobileCount=voter::where("WhatsAppNumber","!=","")->count();
		$AppUsers=androidapp::where("Status","=",1)->get();
		$AVC=0;
		$AssignedVotersCount=DB::select("select COUNT( tblandroiduservoters.VoterId ) AS AssignedVotersCount FROM tblandroiduservoters");
		foreach ($AssignedVotersCount as $key => $value) {
			$AVC=$value->AssignedVotersCount;
		}
		
		$data=array("pagetitle" => " डॅशबोर्ड   ","AppUsers"=>$TotalAppUsers,"Voters"=>$Voters,"MobileNumbers"=>$MobileNumberCount,"WhatsAppNumbers"=>$WhatsAppMobileCount,"AndroidAppUsers"=>$AppUsers,"AssignedCount"=>$AVC);
		return view('admin.dashboard',$data);
	}

	public function LoadBar()
	{
		//$Reply=array();
		$Reply['TotalVotersCount']=voter::where("VoterID","!=","")->count();
		$Reply['MobileNumber']=voter::where("MobileNumber","!=","")->count();
		$Reply['WhatsAppNumber']=voter::where("WhatsAppNumber","!=","")->count();
		$Reply['Email']=voter::where("Email","!=","")->count();
		$Reply['IsPoliticallyStrong']=voter::where("IsPoliticallyStrong","=","1")->count();
		$Reply['Profession']=voter::where("Profession","!=","")->count();
		$Reply['Education']=voter::where("Education","!=","")->count();
		$Reply['IsVoted']=voter::where("IsVoted","=","1")->count();
		$Reply['Cast']=voter::where("Cast","!=","")->count();
		$Reply['Male']=voter::where("Sex","=","M")->count();
		$Reply['Female']=voter::where("Sex","=","F")->count();
		echo json_encode($Reply);
	}

	public function LoadAndroidAppUsersBar(Request $request)
	{
		$AppUsers=$request->AppUserId;
		//$Reply['MobileNumber']=
		if($AppUsers!="")
		{
			$MCount=DB::select("select count(tblvoters.MobileNumber) as MobileNumber from tblvoters,tblandroiduservoters where 	tblvoters.VoterID = tblandroiduservoters.VoterID and tblandroiduservoters.AppUserId=$AppUsers and tblvoters.MobileNumber!='' ");
			foreach ($MCount as $key => $value) {
				$Reply['MobileNumber']=$value->MobileNumber;
			}

			$MCount=DB::select("select count(tblvoters.WhatsAppNumber) as WhatsAppNumber from tblvoters,tblandroiduservoters where 	tblvoters.VoterID = tblandroiduservoters.VoterID and tblandroiduservoters.AppUserId=$AppUsers and tblvoters.WhatsAppNumber!='' ");
			foreach ($MCount as $key => $value) {
				$Reply['WhatsAppNumber']=$value->WhatsAppNumber;
			}

			$MCount=DB::select("select count(tblvoters.Email) as Email from tblvoters,tblandroiduservoters where tblvoters.VoterID = tblandroiduservoters.VoterID and tblandroiduservoters.AppUserId=$AppUsers and tblvoters.Email!='' ");
			foreach ($MCount as $key => $value) {
				$Reply['Email']=$value->Email;
			}

			$MCount=DB::select("select count(tblvoters.IsPoliticallyStrong) as IsPoliticallyStrong from tblvoters,tblandroiduservoters where tblvoters.VoterID = tblandroiduservoters.VoterID and tblandroiduservoters.AppUserId=$AppUsers and tblvoters.IsPoliticallyStrong=1 ");
			foreach ($MCount as $key => $value) {
				$Reply['IsPoliticallyStrong']=$value->IsPoliticallyStrong;
			}

			$MCount=DB::select("select count(tblvoters.Profession) as Profession from tblvoters,tblandroiduservoters where tblvoters.VoterID = tblandroiduservoters.VoterID and tblandroiduservoters.AppUserId=$AppUsers and tblvoters.Profession!='' ");
			foreach ($MCount as $key => $value) {
				$Reply['Profession']=$value->Profession;
			}

			$MCount=DB::select("select count(tblvoters.Education) as Education from tblvoters,tblandroiduservoters where tblvoters.VoterID = tblandroiduservoters.VoterID and tblandroiduservoters.AppUserId=$AppUsers and tblvoters.Education!='' ");
			foreach ($MCount as $key => $value) {
				$Reply['Education']=$value->Education;
			}

			$MCount=DB::select("select count(tblvoters.IsVoted) as IsVoted from tblvoters,tblandroiduservoters where tblvoters.VoterID = tblandroiduservoters.VoterID and tblandroiduservoters.AppUserId=$AppUsers and tblvoters.IsVoted=1 ");
			foreach ($MCount as $key => $value) {
				$Reply['IsVoted']=$value->IsVoted;
			}

			$MCount=DB::select("select count(tblvoters.Cast) as Cast from tblvoters,tblandroiduservoters where tblvoters.VoterID = tblandroiduservoters.VoterID and tblandroiduservoters.AppUserId=$AppUsers and tblvoters.Cast!=''");
			foreach ($MCount as $key => $value) {
				$Reply['Cast']=$value->Cast;
			}			
		}
		else
		{
			$Reply['MobileNumber']=voter::where("MobileNumber","!=","")->count();
			$Reply['WhatsAppNumber']=voter::where("WhatsAppNumber","!=","")->count();
			$Reply['Email']=voter::where("Email","!=","")->count();
			$Reply['IsPoliticallyStrong']=voter::where("IsPoliticallyStrong","=","1")->count();	
			$Reply['Profession']=voter::where("Profession","!=","")->count();
			$Reply['Education']=voter::where("Education","!=","")->count();
			$Reply['IsVoted']=voter::where("IsVoted","=","1")->count();
			$Reply['Cast']=voter::where("Cast","!=","")->count();

		}
		echo json_encode($Reply);
	}

	public function LoadVotersCountBySurname()
	{
		$MCount=DB::select("SELECT distinct MarathiLastName, count(*) as Total FROM tblvoters group by MarathiLastName order by Total desc");
		$i=0;
		foreach ($MCount as $key => $value) {
			$Reply[$i]['MarathiLastName']=$value->MarathiLastName;
			$Reply[$i]['Total']=$value->Total;
			$i++;
		}
		echo json_encode(count($Reply));
	}

	public function LoadPie()
	{
		//$Reply=array();
		$Reply['TotalVotersCount']=voter::where("VoterID","!=","")->count();
		$Reply['MobileNumber']=voter::where("MobileNumber","!=","")->count();
		$Reply['WhatsAppNumber']=voter::where("WhatsAppNumber","!=","")->count();
		$Reply['Email']=voter::where("Email","!=","")->count();
		$Reply['IsPoliticallyStrong']=voter::where("IsPoliticallyStrong","=","1")->count();
		$Reply['Profession']=voter::where("Profession","!=","")->count();
		$Reply['Education']=voter::where("Education","!=","")->count();
		$Reply['IsVoted']=voter::where("IsVoted","=","1")->count();
		
		$Reply['Male']=voter::where("Sex","=","M")->count();
		$Reply['Female']=voter::where("Sex","=","F")->count();
		echo json_encode($Reply);
	}

	public function LoadCastPie()
	{
		$Reply=array();
		$Res=DB::select("SELECT distinct Cast, count(*) as Total FROM tblvoters group by Cast order by Total desc");
		$i=0;
		foreach ($Res as $key => $value) {
			if($value->Cast=="")
			{
				$Reply[$i]["Cast"]="Total";
				$Reply[$i]["Total"]=$value->Total;
			}
			else
			{
				$Reply[$i]["Cast"]=$value->Cast;
				$Reply[$i]["Total"]=$value->Total;				
			}
			$i++;
		}
		echo json_encode($Reply);
	}

	public function LoadVotingAnalysisPie()
	{
		$Reply=array();
		$Res=DB::select("SELECT distinct VotingAnalysis, count(*) as Total FROM tblvoters group by VotingAnalysis ");//order by Total desc
		$i=0;
		foreach ($Res as $key => $value) {
			if($value->VotingAnalysis=="")
			{
				$Reply[$i]["VotingAnalysis"]="Total";
				$Reply[$i]["Total"]=$value->Total;
			}
			else
			{
				$Reply[$i]["VotingAnalysis"]=$value->VotingAnalysis;
				$Reply[$i]["Total"]=$value->Total;				
			}
			$i++;
		}
		echo json_encode($Reply);	
	}

	public function LoadProfessionPie()
	{
		$Reply=array();
		$Res=DB::select("SELECT distinct Profession, count(*) as Total FROM tblvoters group by Profession order by Total desc");
		$i=0;
		foreach ($Res as $key => $value) {

			if($value->Profession=="")
			{
				$Reply[$i]["Profession"]="Total";
				$Reply[$i]["Total"]=$value->Total;
			}
			else
			{
				$Reply[$i]["Profession"]=$value->Profession;
				$Reply[$i]["Total"]=$value->Total;				
			}
			$i++;
		}
		echo json_encode($Reply);

	}

	public function LoadEducationPie()
	{
		$Reply=array();
		$Res=DB::select("SELECT distinct Education, count(*) as Total FROM tblvoters group by Education order by Total desc");
		$i=0;
		foreach ($Res as $key => $value) {
			if($value->Education=="")
			{
				$Reply[$i]["Education"]="Total";
				$Reply[$i]["Total"]=$value->Total;
			}
			else
			{
				$Reply[$i]["Education"]=$value->Education;
				$Reply[$i]["Total"]=$value->Total;			
			}
			$i++;
		}
		echo json_encode($Reply);
	}

	public function default_values()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => " आपोआप दिसणारा पत्ता  ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village);

		return view('admin.default-values',$data);	
	}

	public function ChangeDefaultValues(Request $request)
	{
		$DefaultValue=$request->DefaultValue;
		$DistrictID=$request->District;
		$TehsilID=$request->Tehsil;
		$CityOrVillage=$request->CityOrVillage;
		$Village_CityID=$request->CorV;
		$IsCity="";
		if($CityOrVillage=="Village")
		{
			$IsCity=0;
		}
		else if($CityOrVillage=="City")
		{
			$IsCity=1;
		}
		$Affected_Row=0;
		if($DefaultValue=="District")
		{
			$Affected_Row=DB::table("tbldefaultvalues")->where('id','=',1)->update(['DistrictID'=>$DistrictID,'TehsilID'=>-1,'CityID'=>-1,'VillageID'=>-1]);
		}
		else if($DefaultValue=="Tehsil")
		{
			$Affected_Row=DB::table("tbldefaultvalues")->where('id','=',1)->update(['DistrictID'=>-1,'TehsilID'=>$TehsilID,'CityID'=>-1,'VillageID'=>-1]);
		}
		else if($DefaultValue=="City")
		{
			if($IsCity==0)
			{
					return redirect("/default-values")->withInput()->with("error"," Please Select Valid City to Set Default");
			}
			else if($IsCity=1)
			{
				$Affected_Row=DB::table("tbldefaultvalues")->where('id','=',1)->update(['DistrictID'=>-1,'TehsilID'=>-1,'CityID'=>$Village_CityID,'VillageID'=>-1]);			
			}
		}
		else if($DefaultValue=="Village")
		{
			echo "$Village_CityID - $IsCity";
			if($IsCity==0)
			{
				$Affected_Row=DB::table("tbldefaultvalues")->where('id','=',1)->update(['DistrictID'=>-1,'TehsilID'=>-1,'CityID'=>-1,'VillageID'=>$Village_CityID]);				
			}
			else if($IsCity=1)
			{
				return redirect("/default-values")->withInput()->with("error"," Please Select Valid Village to Set Default");
			}
		}
		echo " <p/> $Affected_Row";
		if($Affected_Row==1)
			{
				return redirect("/default-values")->withInput()->with("success","Default Value is Successfully Updated");
			}
			else
			{
				return redirect("/default-values")->withInput()->with("error"," Default Value is not Updated");
			}
	}

	public function setting()
	{
		$data=array("pagetitle" => " सत्ता सेटिंग ");
		return view('admin.setting',$data);
	}

	public function mypost()
	{
	//	echo "this is My Admin Controller";
		$data=array("pagetitle" => "My Post");

		return view('admin.post',$data);
	}


}
