<?php namespace App\Http\Controllers;
use App\state;
use App\zone;
use App\district;
use App\tehsil;
use App\city;
use App\village;
use App\booth;
use DB;
use Validator;
use illuminate\Http\Request;
use illuminate\Routing\Controllers;
class BoothController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Welcome Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders the "marketing page" for the application and
	| is configured to only allow guests. Like most of the other sample
	| controllers, you are free to modify or remove it as you desire.
	|
	*/

	/**
	 * Show the application welcome screen to the user.
	 *
	 * @return Response
	 */
	public function index()
	{
		//	echo "this is My Admin Controller";
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}
		$ZoneID="";
		$DistrictDetails=district::where("DistrictID","=",$DistrictID)->get();
		foreach ($DistrictDetails as $key => $value) {
			$ZoneID=$value->ZoneID;
		}
		$StateID="";
		$ZoneDetails=zone::where("ZoneID","=",$ZoneID)->get();
		foreach ($ZoneDetails as $key => $value) {
			$StateID=$value->StateID;
		}

		$States=state::where("Status","=",1)->get();
		$Zones=zone::where("StateID","=",$StateID)->get();

		$data=array("pagetitle" => "नवीन बूथ  ","States"=>$States,"SelectedState"=>$StateID,"Zones"=>$Zones,"SelectedZone"=>$ZoneID,"DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		//$data=array("pagetitle" => " नवीन बूथ  ","States"=>$States);
		return view('admin.new-booth',$data);
	}

	public function edit()
	{
		//	echo "this is My Admin Controller";
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}
		$ZoneID="";
		$DistrictDetails=district::where("DistrictID","=",$DistrictID)->get();
		foreach ($DistrictDetails as $key => $value) {
			$ZoneID=$value->ZoneID;
		}
		$StateID="";
		$ZoneDetails=zone::where("ZoneID","=",$ZoneID)->get();
		foreach ($ZoneDetails as $key => $value) {
			$StateID=$value->StateID;
		}

		$States=state::where("Status","=",1)->get();
		$Zones=zone::where("StateID","=",$StateID)->get();

		$data=array("pagetitle" => " बदल करा ","States"=>$States,"SelectedState"=>$StateID,"Zones"=>$Zones,"SelectedZone"=>$ZoneID,"DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		return view('admin.edit-booth',$data);
	}

	public function delete()
	{
		//	echo "this is My Admin Controller";
		//	echo "this is My Admin Controller";
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}
		$ZoneID="";
		$DistrictDetails=district::where("DistrictID","=",$DistrictID)->get();
		foreach ($DistrictDetails as $key => $value) {
			$ZoneID=$value->ZoneID;
		}
		$StateID="";
		$ZoneDetails=zone::where("ZoneID","=",$ZoneID)->get();
		foreach ($ZoneDetails as $key => $value) {
			$StateID=$value->StateID;
		}

		$States=state::where("Status","=",1)->get();
		$Zones=zone::where("StateID","=",$StateID)->get();

		$data=array("pagetitle" => " काढून टाका  ","States"=>$States,"SelectedState"=>$StateID,"Zones"=>$Zones,"SelectedZone"=>$ZoneID,"DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		//$data=array("pagetitle" => " काढून टाका  | Sterling Systems ","States"=>$States);
		return view('admin.delete-booth',$data);
	}

	// Save Booth
	public function SaveBooth(Request $request)
	{
		$IsCity=0;
		if($request->CityOrVillage=="City")
		{
			$IsCity=1;
		}
		else if($request->CityOrVillage=="Village")
		{
			$IsCity=0;
		}

		$validator= Validator::make(
			array(
				"States"=>$request->States,
				"Zones"=>$request->Zones,
				"Districts"=>$request->Districts,
				"Tehsils"=>$request->Tehsils,
				"CityOrVillage"=>$request->CityOrVillage,
				"Booth"=>$request->Booth
				),
			array(
				"States"=>"required",
				"Zones"=>"required",
				"Districts"=>"required",
				"Tehsils"=>"required",
				"CityOrVillage"=>"required",
				"Booth"=>"required",
				)
			);
		if($validator->fails())
		{
			return redirect("/new-booth")->withErrors($validator)->withInput();
		}
		else
		{
			// Insert City to db
			// Check Duplicate Entry
			$CityIDOrVillageId=0;
			if($IsCity==1)
			{
				$CityIDOrVillageId=$request->CorV;
			}
			else if($IsCity==0)
			{
				$CityIDOrVillageId=$request->CorV;
			}
			$BoothArray=explode(",", $request->Booth);
			$SavedCount=0;
			for ($i=0; $i < count($BoothArray) ; $i++) { 
				$BoothNumber=$BoothArray[$i];
				if($BoothNumber!="")
				{
					$DuplicateBooth=booth::where('Village_City_ID', '=',$CityIDOrVillageId)->where('IsCity','=',$IsCity)->where('BoothNumber','=',"$BoothNumber")->get();
					if(count($DuplicateBooth)==0)
					{
						$Booth=new booth;
						$Booth->BoothNumber=$BoothNumber;
						$Booth->Village_City_ID=$CityIDOrVillageId;
						$Booth->IsCity=$IsCity;
						$Booth->save();
						$insertedId = $Booth->id;
						if($insertedId>0)
						{
							$SavedCount++;
							// return redirect("/new-booth")->withErrors($validator)->withInput()->with("success","Booth Number ".$request->City." is Successfully Saved");
						}
						else
						{
							return redirect("/new-booth")->withErrors($validator)->withInput()->with("error","Can't Save Booth Number ".$BoothNumber." \n".$SavedCount . " Booths is Successfully Saved");
						}			
					}
					else
					{
						return redirect("/new-booth")->withErrors($validator)->withInput()->with("error","Booth Number ".$BoothNumber." is Already Saved \n".$SavedCount . " Booths is Successfully Saved");
					}	

					
				}
				else
				{
					return redirect("/new-booth")->withErrors($validator)->withInput()->with("error","Booth Number ".$BoothNumber." is Empty ");
				}
		}

		if($SavedCount!=0)		
			{
				return redirect("/new-booth")->withErrors($validator)->withInput()->with("success",$SavedCount." Booths is Successfully Saved");
			}
			else
			{
				return redirect("/new-booth")->withErrors($validator)->withInput()->with("error"," No any Booth Saved !!!");
			}
		}
	}

	public function EditBooth(Request $request)
	{

		$IsCity=0;
		if($request->CityOrVillage=="City")
		{
			$IsCity=1;
		}
		else if($request->CityOrVillage=="Village")
		{
			$IsCity=0;
		}

		$validator= Validator::make(
			array(
				"States"=>$request->States,
				"Zones"=>$request->Zones,
				"Districts"=>$request->Districts,
				"Tehsils"=>$request->Tehsils,
				"CityOrVillage"=>$request->CityOrVillage,
				"Booths"=>$request->Booths,
				"Booth"=>$request->Booth
				),
			array(
				"States"=>"required",
				"Zones"=>"required",
				"Districts"=>"required",
				"Tehsils"=>"required",
				"CityOrVillage"=>"required",
				"Booths"=>"required",
				"Booth"=>"required",
				)
			);
			if($validator->fails())
			{
				return redirect("/new-booth")->withErrors($validator)->withInput();
			}
			else
			{
				// Insert City to db
				// Check Duplicate Entry
				$CityIDOrVillageId=0;
				$BoothNumber=$request->Booth;
				if($IsCity==1)
				{
					$CityIDOrVillageId=$request->Citys;
				}
				else if($IsCity==0)
				{
					$CityIDOrVillageId=$request->Villages;
				}
				// Check Booth Is Already Present or not
					$DuplicateBooth=booth::where('Village_City_ID', '=',$CityIDOrVillageId)->where('IsCity','=',$IsCity)->where('BoothNumber','=',"$BoothNumber")->get();
					if(count($DuplicateBooth)==0)
					{
						// Update Booth
						$affectedRows = booth::where('BoothID', '=', $request->Booths)->update(['BoothNumber' => $request->Booth]);
						if($affectedRows==1)
						{
							return redirect("/edit-booth")->withErrors($validator)->withInput()->with("success","Booth ".$request->Booth." is Successfully Updated");
						}
						else
						{
							return redirect("/edit-booth")->withErrors($validator)->withInput()->with("error"," City ".$request->Booth." is Already Saved");
						}
					}
					else
					{
						// Booth is ALready Present
						return redirect("/edit-booth")->withErrors($validator)->withInput()->with("error"," Booth Number ".$BoothNumber." is already Saved !!!");
					}
			}
	}

	public function DeleteBooth(Request $request)
	{
		$validator=Validator::make(
			array(
				'States'=>$request->States,
				'Zones'=>$request->Zones,
				'Districts'=>$request->Districts,
				'Tehsils'=>$request->Tehsils,
				'Booths'=>$request->Booths,
				'CityOrVillage'=>$request->CityOrVillage
			),
			array(
				'States'=>"required",
				'Zones'=>"required",
				'Districts'=>"required",
				'Tehsils'=>"required",
				'Booths'=>"required",
				'CityOrVillage'=>"required"
				)
			);

		if($validator->fails())
		{
			return redirect("/delete-booth")->withErrors($validator)->withInput();
		}
		else
		{
			// chk City if present
				$IsCity=0;
				if($request->CityOrVillage=="City")
				{
					$IsCity=1;
				}
				else if($request->CityOrVillage=="Village")
				{
					$IsCity=0;
				}
				$CityIDOrVillageId=0;
				$BoothNumber=$request->Booths;
				if($IsCity==1)
				{
					$CityIDOrVillageId=$request->CorV;
				}
				else if($IsCity==0)
				{
					$CityIDOrVillageId=$request->CorV;
				}

			$Booths=booth::where('BoothID', '=',$request->Booths)->get();

			$BoothName="";
			foreach ($Booths as $key => $value) {
				$BoothName=$value['BoothName'];
			}

			if(count($Booths)>0)
			{
				// Delete City
				$affectedRows = booth::where('BoothID', '=', $request->Booths)->delete();
				if($affectedRows==1)
				{
					// City is Successfully Deleted
					return redirect("/delete-booth")->withInput()->with("success","Booth ".$BoothName." is Successfully Deleted");
				}
				else
				{
					// City Name Not Deleted
					return redirect("/delete-booth")->withErrors($validator)->withInput()->with("error","Can't Delete Booth ".$BoothName."");
				}
			}
			else
			{
				// City is Not Present
				return redirect("/delete-city")->withErrors($validator)->withInput()->with("error","Booth is Not Present in System ");
			}
		}
	}

	// Get Booths by city or village id
	public function getBoothsNumbersById(Request $request)
	{
		$validator= Validator::make(
			array(
				"Village_Or_City_Id"=>$request->Village_Or_City_Id
				),
			array(
				"Village_Or_City_Id"=>"required",
				)
		);

		if($validator->fails())
		{
			return redirect("/edit-booth")->withErrors($validator)->withInput();
		//	return redirect()->intended($this->redirectPath())->withErrors($validator)->withInput();
		}
		else
		{
			$Booths=booth::where('Village_City_ID', '=',$request->Village_Or_City_Id)->get();
			echo json_encode($Booths);
		}

	}

	public function getBoothNameById(Request $request)
	{
		$validator= Validator::make(
			array(
				"BoothID"=>$request->BoothID
				),
			array(
				"BoothID"=>"required"
				)
		);

		if($validator->fails())
		{
			return redirect("/edit-booth")->withErrors($validator)->withInput();
		//	return redirect()->intended($this->redirectPath())->withErrors($validator)->withInput();
		}
		else
		{
			$Booths=booth::where('BoothID', '=',$request->BoothID)->get();
			echo json_encode($Booths);
		}
	}
}