<?php namespace App\Http\Controllers;

use App\state;
use App\zone;
use App\district;
use App\tehsil;
use App\city;
use App\cast;
use Validator;
use illuminate\Http\Request;
use illuminate\Routing\Controllers;

class CastController extends Controller {

	public function index()
	{
		//	echo "this is My Admin Controller";

		$Casts=cast::where("CastId",">",0)->get();

		$data=array("pagetitle" => " नवीन जात  ","Casts"=>$Casts);
		return view('admin.new_cast',$data);
	}

	public function SaveCast(Request $request)
	{
		//echo "<h1> In Cast </h1>";
		$validator=Validator::make(
			array(
				"CastName"=>$request->CastName,
			),
			array(
				"CastName"=>"required",	
			)
		);

		if($validator->fails())
		{
			return redirect("/new-cast")->withErrors($validator)->withInput();
		}
		else
		{
			$IfAlreadySaved=cast::where("CastName","=",$request->CastName)->get();
			//echo "Cast - ".count($IfAlreadySaved);
			if(count($IfAlreadySaved)>0)
			{
				// Already Saved
				return redirect("/new-cast")->with("error"," Cast is Already Saved !! ")->withInput();
			}
			else if(count($IfAlreadySaved)==0)
			{	
				$Cast=new cast;
				$Cast->CastName=$request->CastName;
				$Cast->save();
				$insertedId = $Cast->id;
				if($insertedId>0)
				{
					return redirect("/new-cast")->with("success"," जात ".$request->CastName." जतन केली !!")->withInput();
				}
				else
				{
					return redirect("/new-cast")->with("error"," जात ".$request->CastName." जतन केली नाही !!")->withInput();
				}
			}
		}
	}

	public function edit()
	{
		//	echo "this is My Admin Controller";
		$Casts=cast::where("CastId",">",0)->get();
		$data=array("pagetitle" => " बदल करा   ","Casts"=>$Casts);
		return view('admin.edit_cast',$data);
	}

	public function EditCast(Request $request)
	{
		$CastID=$request->CastID;
		$CastName=$request->CastName;
		$validator=Validator::make(
			array(
				"CastID"=>$request->CastID,
				"CastName"=>$request->CastName,
			),
			array(
				"CastID"=>"required",
				"CastName"=>"required",
			)
		);

		if($validator->fails())
		{
			return redirect("/edit-cast")->withErrors($validator)->withInput();
		}
		else
		{
			$IfAlreadySaved=cast::where("CastName","=",$request->CastName)->get();
			//echo "Cast - ".count($IfAlreadySaved);
			if(count($IfAlreadySaved)>0)
			{
				// Already Saved
				return redirect("/edit-cast")->with("error"," Cast is Already Saved !! ")->withInput();
			}
			else if(count($IfAlreadySaved)==0)
			{	
				$AffectedRows=cast::where("CastId","=",$request->CastID)->update(["CastName"=>$request->CastName]);
				if($AffectedRows==1)
				{
					return redirect("/edit-cast")->with("success",$request->CastName." बदल केली !! ")->withInput();
				}
				else
				{
					return redirect("/edit-cast")->with("error"," Cast is Already Saved !! ")->withInput();
				}
			}
		}
	}

	public function getCastNameById(Request $request)
	{
		$CastID=$request->CastID;
		$Cast=cast::where("CastId","=",$CastID)->get();
		$CastName="";
		/* foreach ($Cast as $key => $value) {
			$CastName=$value->CastName;
		}
		*/
		echo json_encode($Cast);
	}

	public function delete()
	{
	//	echo "this is My Admin Controller";
		$Casts=cast::where("CastId",">",0)->get();
		$data=array("pagetitle" => " काढून टाका   ","Casts"=>$Casts);
		return view('admin.delete_cast',$data);
	}

	public function DeleteCast(Request $request)
	{
		$CastID=$request->CastID;
		$aff_row=cast::where("CastId","=",$CastID)->delete();
		if($aff_row==1)
			{
          		return redirect("/delete-cast")->withInput()->with("success","जात काढून टाकली !!");
			}
			else
			{
				return redirect("/delete-cast")->withInput()->with("error","जात काढून टाकली नाही !!");
			}
	}

}