@extends('admin.layouts.mainview')
@section('content')

<script>
  function loadZoneNames()
  {
      var StateId=$('#States').val();
      // Get State Name
      $.ajax({
          type: "GET",
          url: "getZoneNames",
          data:"stateid="+StateId,
          dataType: "json",
          success: function(result){
               $('#Zones').children().remove();         
               $('#Zones').append($('<option>').text("Zone").attr('value', ""));
              $.each(result, function(id, value) {
                $('#Zones').append($('<option>').text(value.ZoneName).attr('value', value.ZoneID));
              });
            }
          });
  }

  function loadDistrictNames()
  {
      var StateId=$('#States').val();
      var ZoneId=$('#Zones').val();
      // Get State Name
      $.ajax({
          type: "GET",
          url: "getDistrictNames",
          data:"zoneid="+ZoneId,
          dataType: "json",
          success: function(result){
               $('#Districts').children().remove();         
               $('#Districts').append($('<option>').text("District").attr('value', ""));
               $.each(result, function(id, value) {
                  $('#Districts').append($('<option>').text(value.DistrictName).attr('value', value.DistrictID));
               });
            }
          });
  }

 function loadTehsilNames()
  {
      var DistrictId=$('#Districts').val();
      // Get State Name
      $.ajax({
          type: "GET",
          url: "getTehsilNames",
          data:"districtid="+DistrictId,
          dataType: "json",
          success: function(result){
               $('#Tehsils').children().remove();         
               $('#Tehsils').append($('<option>').text("Tehsil").attr('value', ""));
               $.each(result, function(id, value) {
                  $('#Tehsils').append($('<option>').text(value.TehsilName).attr('value', value.TehsilID));
               });
            }
       });
  }

  function loadVillageNames()
  {
      var TehsilId=$('#Tehsils').val();
      // Get State Name
      $.ajax({
          type: "GET",
          url: "getVillageNames",
          data:"tehsilid="+TehsilId,
          dataType: "json",
          success: function(result){
               $('#Villages').children().remove();         
               $('#Villages').append($('<option>').text("Village").attr('value', ""));
               $.each(result, function(id, value) {
                  $('#Villages').append($('<option>').text(value.VillageName).attr('value', value.VillageID));
               });
            }
       });
  }

  function loadVillageName()
  {
      var CityId=$('#Villages').val();
      // Get State Name
      $.ajax({
          type: "GET",
          url: "getVillageNameById",
          data:"villageid="+CityId,
          dataType: "json",
          success: function(result){
              $.each(result, function(id, value) {
                  $("#Village").val(value.VillageName);
                });
              }
       });   
  }
</script>

  <div class="qv rc sm sp" >
        <div class="qw">
            @if(Session::has('Name'))
              <span style="margin-left:70px;"> <strong> Delete Village </strong> </span>
            <span style="margin-top:-7px;margin-left:55%;">Welcome, {{ Session::get('Name') }}
            <a href='dashboard' class='cg ts fx green' style="margin-left:80px;"> Go To Dashboard </a>
          @endif
        </div>
  </div>

      <div class="row" style="margin-left:10%;width:80%;">
        <div class="col-lg-12">
            <div class="w-lg m-y-lg bv">
               <form action="DeleteVillage" id="DeleteVillageForm" name="DeleteVillageForm"  role="form" style="margin-top:20px;">

                  <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">
                            <!-- Errors And Success Messages -->
                             @if(count($errors)>0)
                            <div class="alert alert-danger">
                              <ul>
                                @foreach ($errors->all() as $error)
                                  <li> <strong><font color="red" > {{ $error }} </font> </strong></li>
                                  <p/>
                                @endforeach
                              </ul>
                            </div>
                            @endif
                        </p>
                         @if(Session::has('success'))
                              <font color="green" > {{ Session::get('success') }} </font>
                              <p/>
                            @endif

                            @if(Session::has('error'))
                              <font color="red" > {{ Session::get('error') }} </font>
                              <p/>
                            @endif
                          </div>
                          <div class="col-lg-3"></div>
                  </div>
                 <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">
                            <select id="States" name="States" onchange="loadZoneNames()" class="form-control">
                              <option value=""> State  </option>
                               @foreach($States as $state)
                                  <option value="{{ $state->StateID }}">{{ $state->StateName}}</option>
                                @endforeach
                            </select>
                          </div>
                        <div class="col-lg-3"></div>
                  </div>
                    <p/>

                    <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">
                            <select id="Zones" name="Zones" onchange="loadDistrictNames()" class="form-control">
                              <option value=""> Zone  </option>
                            </select>
                          </div>
                        <div class="col-lg-3"></div>
                    </div>
                    <p/>
                    <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">
                            <select id="Districts" name="Districts" onchange="loadTehsilNames()" class="form-control">
                              <option value=""> District  </option>
                            </select>
                          </div>
                        <div class="col-lg-3"></div>
                    </div>
                    <p/>
                    <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">
                            <select id="Tehsils" name="Tehsils" onchange="loadVillageNames()" class="form-control">
                              <option value=""> Tehsil  </option>
                            </select>
                          </div>
                        <div class="col-lg-3"></div>
                    </div>
                    <p/>
                    <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">
                            <select id="Villages" name="Villages" class="form-control">
                            	<option value=""> Village  </option>
                            </select>
                          </div>
                        <div class="col-lg-3"></div>
                    </div>
                    <p/>
                    <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">                      
                            <input type="submit" value="Delete" class="cg fp"> &nbsp;&nbsp;&nbsp;
                            <input type="reset" value="Cancel" class="fy cg">
                          </div>
                          <div class="col-lg-3"></div>
                    </div>

                </form>
            </div>
         </div>
      </div>

<script>
   $(document).ready(function() {
        $("#States").select2();
        $("#Zones").select2();
        $("#Districts").select2();
        $("#Tehsils").select2();
        $("#Villages").select2();
     });

    $('#DeleteVillageForm')
        .formValidation({
            framework: 'bootstrap',
            icon: {
                valid: 'glyphicon glyphicon-ok',
                invalid: 'glyphicon glyphicon-remove',
                validating: 'glyphicon glyphicon-refresh'
            },
            // This option will not ignore invisible fields which belong to inactive panels
            excluded: ':disabled',
            fields: {
                City: {
                    validators: {
                        notEmpty: {
                            message: 'The City Name is required'
                        }
                    }
                },
                States: {
                    validators: {
                        notEmpty: {
                            message: 'The State is required '
                        }
                    }
                },
                Zones: {
                    validators: {
                        notEmpty: {
                            message: 'The Zone is required '
                        }
                    }
                },
                Districts: {
                    validators: {
                        notEmpty: {
                            message: 'The District is required'
                        }
                    }
                },
                Tehsils: {
                    validators: {
                        notEmpty: {
                            message: 'The Tehsil is required'
                        }
                    }
                },
                Villages: {
                    validators: {
                        notEmpty: {
                            message: 'The Villages is required'
                        }
                    }
                }               
              }
        });

      function validateTab(index) {

         var fv   = $('#DeleteVillageForm').data('formValidation'), // FormValidation instance
            // The current tab
            $tab = $('#DeleteVillageForm');

        // Validate the container
        fv.validateContainer($tab);

        var isValidStep = fv.isValidContainer($tab);
        if (isValidStep === false || isValidStep === null) {
            // Do not jump to the target tab
            return false;
        }
        return true;
    }

</script>

@endsection