@extends('admin.layouts.mainview')
@section('content')

<script>
     $(document).ready(function() {
            $("#VillagePanel").hide();
            $("#CityPanel").hide();
        });

  function loadZoneNames()
  {
      var StateId=$('#States').val();
      // Get State Name
      $.ajax({
          type: "GET",
          url: "getZoneNames",
          data:"stateid="+StateId,
          dataType: "json",
          success: function(result){
               $('#Zones').children().remove();         
               $('#Zones').append($('<option>').text(" विभाग ").attr('value', ""));
              $.each(result, function(id, value) {
                $('#Zones').append($('<option>').text(value.ZoneName).attr('value', value.ZoneID));
              });
            }
          });
  }

  function loadDistrictNames()
  {
      var StateId=$('#States').val();
      var ZoneId=$('#Zones').val();
      // Get State Name
      $.ajax({
          type: "GET",
          url: "getDistrictNames",
          data:"zoneid="+ZoneId,
          dataType: "json",
          success: function(result){
               $('#Districts').children().remove();         
               $('#Districts').append($('<option>').text(" जिल्हा ").attr('value', ""));
               $.each(result, function(id, value) {
                  $('#Districts').append($('<option>').text(value.DistrictName).attr('value', value.DistrictID));
               });
            }
          });
  }

 function loadTehsilNames()
  {
      var DistrictId=$('#Districts').val();
      // Get State Name
      $.ajax({
          type: "GET",
          url: "getTehsilNames",
          data:"districtid="+DistrictId,
          dataType: "json",
          success: function(result){
               $('#Tehsils').children().remove();         
               $('#Tehsils').append($('<option>').text(" तालुका ").attr('value', ""));
               $.each(result, function(id, value) {
                  $('#Tehsils').append($('<option>').text(value.TehsilName).attr('value', value.TehsilID));
               });
            }
       });
  }

  function loadVillageNames()
  {
      var TehsilId=$('#Tehsils').val();
      // Get State Name
      $.ajax({
          type: "GET",
          url: "getVillageNames",
          data:"tehsilid="+TehsilId,
          dataType: "json",
          success: function(result){
               $('#Villages').children().remove();         
               $('#Villages').append($('<option>').text(" गाव ").attr('value', ""));
               $.each(result, function(id, value) {
                  $('#Villages').append($('<option>').text(value.VillageName).attr('value', value.VillageID));
               });
            }
       });
  }

  function loadVillageName()
  {
      var CityId=$('#Villages').val();
      // Get State Name
      $.ajax({
          type: "GET",
          url: "getVillageNameById",
          data:"villageid="+CityId,
          dataType: "json",
          success: function(result){
              $.each(result, function(id, value) {
                  $("#Village").val(value.VillageName);
                });
              }
       });   
  }

  // Load City or Village if 

  function loadCityOrVillage()
  {
    if(document.getElementById("City").checked==true)  // City is Selected then Add 
    {
      // if City is checked
         var TehsilId=$('#Tehsils').val();
              // Get State Name
              $.ajax({
                  type: "GET",
                  url: "getCityNames",
                  data:"tehsilid="+TehsilId,
                  dataType: "json",
                  success: function(result){
                       $('#Citys').children().remove();         
                       $('#Citys').append($('<option>').text(" शहर ").attr('value', ""));
                       $.each(result, function(id, value) {
                          $('#Citys').append($('<option>').text(value.CityName).attr('value', value.CityID));
                       });
                    }
               });
    }
    else if(document.getElementById("Village").checked==true)
    {
      // if Village is checked
        
        var TehsilId=$('#Tehsils').val();
        // Get State Name
        $.ajax({
            type: "GET",
            url: "getVillageNames",
            data:"tehsilid="+TehsilId,
            dataType: "json",
            success: function(result){
                $('#Villages').children().remove();         
                $('#Villages').append($('<option>').text(" गाव ").attr('value', ""));
                $.each(result, function(id, value) {
                    $('#Villages').append($('<option>').text(value.VillageName).attr('value', value.VillageID));
              });
            }
       });
    }
  }

  function loadPrabhags()
  {
    var Village_Or_City_Id=0;
    if(document.getElementById("City").checked==true)  // City is Selected then Add 
    {
         // if City is checked
         Village_Or_City_Id=$('#Citys').val();
      }
      else if(document.getElementById("Village").checked==true)
      {
         // if Village is checked
         Village_Or_City_Id=$('#Villages').val();
      }

      $.ajax({
            type: "GET",
            url: "getPrabhagsByCityOrVillageId",
            data:"Village_Or_City_Id="+Village_Or_City_Id,
            dataType: "json",
            success: function(result){
                $('#Prabhags').children().remove();
                $('#Prabhags').append($('<option>').text(" बूथ ").attr('value', ""));
                $.each(result, function(id, value) {
                    $('#Prabhags').append($('<option>').text(value.PrabhagName).attr('value', value.PrabhagID));
              });
            }
       });
  }

    function getCityOrVillages()
  {
      var IsCity=-1;
      if(document.getElementById("City").checked==true)
      {
        IsCity=1;
      }
      else if(document.getElementById("Village").checked==true)
      {
        IsCity=0;
      }
      var CityId=$('#CorV').val();
      var TehsilId=$('#Tehsils').val();
      // Load Cities or villages from 
       $.ajax({
            type: "GET",
            url: "loadAvailableCitiesOrVillages",
            data:"IsCity="+IsCity+"&Tehsil="+TehsilId,
            dataType: "json",
            success: function(result){
              if(IsCity==1)
              {
                $('#CorV').children().remove();         
                $('#CorV').append($('<option>').text(" शहर ").attr('value', ""));
                $.each(result, function(id, value) {
                    $('#CorV').append($('<option>').text(value.CityName).attr('value', value.CityID));
                });
              }
              else if(IsCity==0)
              {
                $('#CorV').children().remove();         
                $('#CorV').append($('<option>').text(" गाव ").attr('value', ""));
                $.each(result, function(id, value) {
                    $('#CorV').append($('<option>').text(value.VillageName).attr('value', value.VillageID));
                });
              }
            }
          });
  }

  function getPrabhagName()
  {
      var PrabhagID=$("#Prabhags").val();
      $.ajax({
            type: "GET",
            url: "getPrabhagNameById",
            data:"PrabhagID="+PrabhagID,
            dataType: "json",
            success: function(result){
                $.each(result, function(id, value) {
                    $('#Prabhag').val(value.PrabhagName);
              });
            }
       }); 
  }
</script>
  <div class="qv rc sm sp" >
        <div class="qw">
            @if(Session::has('Name'))   
              <span style="margin-left:70px;"> <strong> प्रभाग माहितीत बदल करा  </strong> </span>
            <span style="margin-top:-7px;margin-left:55%;">Welcome, {{ Session::get('Name') }}
            <a href='dashboard' class='cg ts fx green' style="margin-left:80px;"> Go To Dashboard </a>
          @endif
        </div>
  </div>
      <div class="row" style="margin-left:10%;width:80%;">
        <div class="col-lg-12">
            <div class="w-lg m-y-lg bv">
               <form action="EditPrabhag" id="EditPrabhagForm" name="EditBoothForm" role="form" style="margin-top:20px;">
                    <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">
                            <!-- Errors And Success Messages -->
                             @if(count($errors)>0)
                            <div class="alert alert-danger">
                              <ul>
                                @foreach ($errors->all() as $error)
                                  <li> <strong><font color="red" > {{ $error }} </font> </strong></li>
                                  <p/>
                                @endforeach
                              </ul>
                            </div>
                            @endif
                        </p>
                         @if(Session::has('success'))
                              <font color="green" > {{ Session::get('success') }} </font>
                              <p/>
                            @endif

                            @if(Session::has('error'))
                              <font color="red" > {{ Session::get('error') }} </font>
                              <p/>
                            @endif
                          </div>
                          <div class="col-lg-3"></div>
                  </div>
                  <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">
                            <select id="States" name="States" onchange="loadZoneNames()" class="form-control">
                             <option value="">  राज्य  </option>
                                   @foreach($States as $State)
                                   @if($SelectedState==$State->StateID )
                                       <option value="{{ $State->StateID }}" selected>{{ $State->StateName }}</option>
                                    @else
                                       <option value="{{ $State->StateID }}">{{ $State->StateName }}</option>
                                    @endif
                               @endforeach
                            </select>
                          </div>
                        <div class="col-lg-3"></div>
                  </div>
                    <p/>
                    <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">
                            <select id="Zones" name="Zones" onchange="loadDistrictNames()" class="form-control">
                              <option value=""> विभाग </option>
                               @foreach($Zones as $Zone)
                                   @if($SelectedZone==$Zone->ZoneID )
                                       <option value="{{ $Zone->ZoneID }}" selected>{{ $Zone->ZoneName }}</option>
                                    @else
                                       <option value="{{ $Zone->ZoneID }}">{{ $Zone->ZoneName }}</option>
                                    @endif
                               @endforeach
                            </select>
                          </div>
                        <div class="col-lg-3"></div>
                    </div>
                    <p/>
                    <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">
                            <select id="Districts" name="Districts" onchange="loadTehsilNames()" class="form-control">
                              <option value="">  जिल्हा  </option>
                                 @foreach($Districts as $District)
                                         @if($SelectDistrict==$District->DistrictID )
                                            <option value="{{ $District->DistrictID }}" selected>{{ $District->DistrictName }}</option>
                                          @else
                                           <option value="{{ $District->DistrictID }}">{{ $District->DistrictName }}</option>
                                           @endif
                                      @endforeach
                            </select>
                          </div>
                        <div class="col-lg-3"></div>
                    </div>
                    <p/>
                    <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">
                            <select id="Tehsils" name="Tehsils" class="form-control">
                              <option value=""> तालुका  </option>
                              @foreach($Tehsils as $Tehsil)
                                         @if($SelectedTehsil==$Tehsil->TehsilID )
                                            <option value="{{ $Tehsil->TehsilID }}" selected>{{ $Tehsil->TehsilName }}</option>
                                          @else
                                            <option value="{{ $Tehsil->TehsilID }}">{{ $Tehsil->TehsilName }}</option>
                                          @endif
                                       @endforeach
                            </select>
                          </div>
                        <div class="col-lg-3"></div>
                    </div>
                    <p/>
                   <div class="row">
                      <div class="col-lg-3"></div>
                      <div class="col-lg-2">
                        <div class="bv" data-example-id="" style="margin-top:5px;">
                                  @if($IsCity==-1)
                                    <div class="ew ug ul">
                                      <label>
                                        <input type="radio" id="City" name="CityOrVillage" value="City" onclick="getCityOrVillages()">  
                                        <span class="uh"></span>
                                         शहर
                                      </label>
                                    </div>
                                    <div class="ew ug ul">
                                       <label>
                                         <input type="radio" name="CityOrVillage" id="Village" value="Village" onclick="getCityOrVillages()"> 
                                          <span class="uh"></span>
                                            गाव
                                         </label>
                                    </div>

                                  @elseif($IsCity==1)
                                    <div class="ew ug ul">
                                      <label>
                                        <input type="radio" id="City" name="CityOrVillage" value="City" onclick="getCityOrVillages()" checked>  
                                        <span class="uh"></span>
                                         शहर
                                      </label>
                                    </div>
                                    <div class="ew ug ul">
                                         <label>
                                           <input type="radio" name="CityOrVillage" id="Village" value="Village" onclick="getCityOrVillages()"> 
                                            <span class="uh"></span>
                                              गाव
                                           </label>
                                    </div>
                                   
                                  @elseif($IsCity==0)
                                    <div class="ew ug ul">
                                      <label>
                                        <input type="radio" id="City" name="CityOrVillage" value="City" onclick="getCityOrVillages()" >  
                                        <span class="uh"></span>
                                         शहर
                                      </label>
                                    </div>
                                    <div class="ew ug ul">
                                       <label>
                                         <input type="radio" name="CityOrVillage" id="Village" value="Village" onclick="getCityOrVillages()" checked> 
                                          <span class="uh"></span>
                                            गाव
                                         </label>
                                    </div>
                                  @endif
                                </div>
                            </div>
                     </div>
                    <p/>
                    <div class="row" >
                          <div class="col-lg-3"></div>
                            <div class="col-lg-6">
                              <select id="CorV" name="CorV" onchange="loadPrabhags()" class="form-control">
                                <option value=""> शहर / गाव </option>
                                    @if($IsCity==1)
                                       @foreach($Cities_Villages as $City_Village)
                                         @if($SelectedCityOrVillage==$City_Village->CityID )
                                            <option value="{{ $City_Village->CityID }}" selected>{{ $City_Village->CityName }}</option>
                                          @else
                                            <option value="{{ $City_Village->CityID }}">{{ $City_Village->CityName }}</option>
                                          @endif
                                       @endforeach
                                    @elseif($IsCity==0)
                                      @foreach($Cities_Villages as $City_Village)
                                         @if($SelectedCityOrVillage==$City_Village->VillageID )
                                            <option value="{{ $City_Village->VillageID }}" selected>{{ $City_Village->VillageName }}</option>
                                          @else
                                            <option value="{{ $City_Village->VillageID }}">{{ $City_Village->VillageName }}</option>
                                          @endif
                                       @endforeach
                                    @endif
                              </select>
                            </div>
                          <div class="col-lg-3"></div>
                      </div>
                      <p/>
                   <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">
                            <select id="Prabhags" name="Prabhags" onchange="getPrabhagName()" class="form-control">
                              <option value="">  प्रभाग  </option>
                                @foreach($Prabhags as $Prabhag)
                                  <option value="{{ $Prabhag->PrabhagID }}">{{ $Prabhag->PrabhagName }}</option>
                                @endforeach
                            </select>
                          </div>
                        <div class="col-lg-3"></div>
                    </div>
                    <p/>
                    <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">
                            <input type="text" id="Prabhag" name="Prabhag" class="form-control" placeholder=" प्रभाग ">
                          </div>
                        <div class="col-lg-3"></div>
                    </div>
                    <p/>
                    <div class="row">
                        <div class="col-lg-3"></div>
                          <div class="col-lg-6">                      
                            <input type="submit" value="बदल करा" class="cg fp"> &nbsp;&nbsp;&nbsp;
                            <input type="reset" value="रद्द करा " class="fy cg">
                          </div>
                          <div class="col-lg-3"></div>
                    </div>
                </form>
            </div>
         </div>
      </div>

<script>
   $(document).ready(function() {
        $("#States").select2();
        $("#Zones").select2();
        $("#Districts").select2();
        $("#Tehsils").select2();
        $("#CorV").select2();
        $("#Prabhags").select2();
     });

    $('#EditPrabhagForm')
        .formValidation({
            framework: 'bootstrap',
            icon: {
                valid: 'glyphicon glyphicon-ok',
                invalid: 'glyphicon glyphicon-remove',
                validating: 'glyphicon glyphicon-refresh'
            },
            // This option will not ignore invisible fields which belong to inactive panels
            excluded: ':disabled',
            fields: {
                States: {
                    validators: {
                        notEmpty: {
                            message: 'The State is required '
                        }
                    }
                },
                Zones: {
                    validators: {
                        notEmpty: {
                            message: 'The Zone is required '
                        }
                    }
                },
                Districts: {
                    validators: {
                        notEmpty: {
                            message: 'The District is required'
                        }
                    }
                },
                Tehsils: {
                    validators: {
                        notEmpty: {
                            message: 'The Tehsil is required'
                        }
                    }
                },
                CityOrVillage: {
                    validators: {
                        notEmpty: {
                            message: 'The City Or Village is required'
                        }
                    }
                },

                Prabhag: {
                    validators: {
                        notEmpty: {
                            message: 'The Prabhag is required'
                        }
                    }
                }                
              }
        });

      function validateTab(index) {

         var fv   = $('#EditPrabhagForm').data('formValidation'), // FormValidation instance
            // The current tab
            $tab = $('#EditPrabhagForm');

        // Validate the container
        fv.validateContainer($tab);

        var isValidStep = fv.isValidContainer($tab);
        if (isValidStep === false || isValidStep === null) {
            // Do not jump to the target tab
            return false;
        }
        return true;
    }
</script>
@endsection