<?php namespace App\Commands;

use App\Commands\Command;
use Log;
use Queue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Bus\SelfHandling;
use Illuminate\Contracts\Queue\ShouldBeQueued;

class SendVoterSlip extends Command implements  ShouldBeQueued {

	use InteractsWithQueue, SerializesModels;

	public $RouteType;
	public $SenderID;
	public $VotingAnalysis;
	public $VotingStatus;

	public function __construct($RouteType,$SenderID,$VotingAnalysis,$VotingStatus)
	{
		$this->RouteType=$RouteType;
		$this->SenderID=$SenderID;
		$this->VotingAnalysis=$VotingAnalysis;
		$this->VotingStatus=$VotingStatus;
	}

	/**
     * Execute the command.
     *
     * @return void
     */

    public function handle()
    {
    	 event(new SendVoterSlipHandler($this->RouteType,$this->SenderID,$this->VotingAnalysis,$this->VotingStatus));
    }
}