<?php namespace App\Http\Controllers;

use App\state; // This is Modal for State Controller

use Validator;

use illuminate\Http\Request;
use illuminate\Routing\Controllers;

class StateController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Welcome Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders the "marketing page" for the application and
	| is configured to only allow guests. Like most of the other sample
	| controllers, you are free to modify or remove it as you desire.
	|
	*/

	/**
	 * Show the application welcome screen to the user.
	 *
	 * @return Response
	 */
	public function index()
	{
	//	echo "this is My Admin Controller";
		$data=array("pagetitle" => "Add New State | Election Management System | Sterling Systems");
		return view('admin.new-state',$data);
	}

	public function edit()
	{
	//	echo "this is My Admin Controller";

		$States=state::where('Status', '=', 1)->get();
		$StateArray=array();
		if(count($States)>0)
		{
			$StateArray['Status']=1;
			$StateArray['States']=$States;
			$StateArray['Message']="";
		}
		$data=array("pagetitle" => "Edit State | Election Management System | Sterling Systems","States"=>$States);
		return view('admin.edit-state',$data);
	}

	public function delete()
	{
	//	echo "this is My Admin Controller";
		$data=array("pagetitle" => "Add New State | Election Management System | Sterling Systems");
		return view('admin.delete-state',$data);
	}

	public function getStateName(Request $request)
	{
		$validator= Validator::make(
			array(
				"States"=>$request->stateid
				),
			array(
				"States"=>"required",
				)
			);

		if($validator->fails())
		{
			return redirect("/edit-state")->withErrors($validator)->withInput();
		}
		else
		{
			$State=array();
			$States=state::where('StateID', '=',$request->stateid)->get();

			if(count($States)>0)
			{
				$State['Status']=1;
				$State['States']=$States;
				$State['Message']="";
			}
			else
			{
				$State['Status']=0;
				$State['States']=$States;
				$State['Message']="State Not Found";	

			//	return redirect("/edit-state")->withErrors($validator)->withInput();

			}
			echo json_encode($States);
			//echo $States['StateName'];
		}
	}

	// Edit State
	public function editStateName(Request $request)
	{
		$validator= Validator::make(
			array(
				"States"=>$request->States,
				"state"=>$request->state
				),
			array(
				"States"=>"required",
				"state"=>"required"
				)
			);

		if($validator->fails())
		{
			return redirect("/edit-state")->withErrors($validator)->withInput();
		}
		else
		{
			$State=array();
			//$States=state::where('StateId', '=',$request->stateid)->get();
			/*$user = state::find($request->States);

			$user->StateName = $request->state;

			$user->save();
			*/
			$affectedRows = state::where('StateID', '=', $request->States )->update(['StateName' => $request->state]);

			if($affectedRows==1)
			{
//				return redirect("/edit-state")->withErrors($validator)->withInput();
				return redirect("/edit-state")->withErrors($validator)->withInput()->with("success","State Name ".$request->state." is Successfully Updated");
			}
			else
			{
				return redirect("/edit-state")->withErrors($validator)->withInput()->with("error","Can't Update State Name <strong>".$request->state."</strong>");
//				return redirect("/edit-state")->withErrors($validator)->withInput();
			}

		}

	}

	public function getAllStates()
	{
		
	//	$States=state::all();
		$States=state::where('Status', '=', 1)->get();
		$StateArray=array();
		if(count($States)>0)
		{
			$StateArray['Status']=1;
			$StateArray['States']=$States;
			$StateArray['Message']="";
		}
		/* foreach ($States as $key => $value) {
			# code...
			echo "<h4>".$value->StateName ."</h4> <p/>";

		}
		*/
		//echo json_encode($StateArray);
		return $States;
	}


}
