<?php namespace App\Http\Controllers;
use App\state;
use App\zone;
use App\district;
use App\tehsil;
use App\city;
use App\village;
use App\booth;
use App\prabhag;
use App\voter;
use App\cast;
use Validator;
use DB;
use Storage;
use App\androidapp;
use Log;
use Bus;
use Queue;
use Collection;
use Artisan;
use App\Commands\SendSMS;
use illuminate\Http\Request;
use illuminate\Routing\Controllers;
class VoterController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Welcome Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders the "marketing page" for the application and
	| is configured to only allow guests. Like most of the other sample
	| controllers, you are free to modify or remove it as you desire.
	|
	*/
	/**
	 * Show the application welcome screen to the user.
	 *
	 * @return Response
	 */
	public function index()
	{
		//	echo "this is My Admin Controller";
		$data=array("pagetitle" => " नवीन मतदार  ");
		return view('admin.voter',$data);
	}

	public function VotingDay()
	{
		//	echo "this is My Admin Controller";
		$data=array("pagetitle" => " मतदान दिवस ");
		return view('admin.voting_day',$data);
	}

	public function SearchVoters(Request $request)
	{
		$LastName=trim($request->LastName);
		$FirstName=trim($request->FirstName);
		$MiddleName=trim($request->MiddleName);
		
		$Names=array();$Message="खालील मतदार यादीमधून ";
		if($LastName!="" && $FirstName=="" && $MiddleName=="")
		{
			$Message.=" [नाव] [वडिलांचे / पतीचे नाव ] निवडा";
			$Names=DB::select("select MarathiLastName,MarathiFirstName,MarathiMiddleName,VoterID from tblvoters where EnglishLastName='$LastName' or MarathiLastName='$LastName'");
		}
		else if($FirstName!="" && $LastName=="" && $MiddleName=="")
		{
			$Message.=" [ आडनाव ] [वडिलांचे / पतीचे नाव ] निवडा";	
			$Names=DB::select("select MarathiLastName,MarathiFirstName,MarathiMiddleName,VoterID from tblvoters where EnglishFirstName='$FirstName' or MarathiFirstName='$FirstName'");
		}
		else if($MiddleName !="" && $LastName=="" && $FirstName=="")
		{
			$Message.=" [ आडनाव ] [ नाव ] निवडा";
			$Names=DB::select("select MarathiLastName,MarathiFirstName,MarathiMiddleName,VoterID from tblvoters where MarathiMiddleName='$MiddleName' or MarathiMiddleName='$MiddleName'");
		}
		else if($FirstName!="" && $LastName!="" && $MiddleName=="")
		{
			$Message.=" [वडिलांचे / पतीचे नाव ] निवडा";
			$Names=DB::select("select MarathiLastName,MarathiFirstName,MarathiMiddleName,VoterID from tblvoters where (EnglishLastName='$LastName' or MarathiLastName='$LastName') and (EnglishFirstName='$FirstName' or MarathiFirstName='$FirstName')");
		}
		else if($FirstName!="" && $MiddleName!="" && $LastName=="" )
		{
			$Message.=" [ आडनाव ] निवडा";
			$Names=DB::select("select MarathiLastName,MarathiFirstName,MarathiMiddleName,VoterID from tblvoters where (MarathiMiddleName='$MiddleName' or MarathiMiddleName='$MiddleName') and (EnglishFirstName='$FirstName' or MarathiFirstName='$FirstName')");
		}
		else if( $LastName!="" && $MiddleName!="" && $FirstName=="" )
		{
			$Message.=" [ नाव ] निवडा";
			$Names=DB::select("select MarathiLastName,MarathiFirstName,MarathiMiddleName,VoterID from tblvoters where (MarathiMiddleName='$MiddleName' or MarathiMiddleName='$MiddleName') and (EnglishLastName='$LastName' or MarathiLastName='$LastName')");
		}
		else if($LastName!="" && $MiddleName!=""  && $FirstName!="")
		{
			$Message.=" [ मतदार ] निवडा";
			$Query="select MarathiLastName,MarathiFirstName,MarathiMiddleName,VoterID from tblvoters where (MarathiMiddleName='$MiddleName' or MarathiMiddleName='$MiddleName') and (EnglishLastName='$LastName' or MarathiLastName='$LastName') and ( EnglishFirstName='$FirstName' or MarathiFirstName='$FirstName' ) ";
			$Names=DB::select($Query);
		}
		
		//$Names=DB::select("SELECT distinct MarathiLastName, count(*) as Total FROM tblvoters group by MarathiLastName order by Total desc");
		$i=0;$Voters=array();
		foreach ($Names as $key => $value) {

			$Voters[$i]['VoterID']=$value->VoterID;
			if($LastName!="" && $FirstName=="" && $MiddleName=="")
		{
					$Voters[$i]['MarathiFirstName']=$value->MarathiFirstName;
					$Voters[$i]['MarathiLastName']="";
					$Voters[$i]['MarathiMiddleName']=$value->MarathiMiddleName;
					
		}
		else if($FirstName!="" && $LastName=="" && $MiddleName=="")
		{
					$Voters[$i]['MarathiFirstName']="";
					$Voters[$i]['MarathiLastName']=$value->MarathiLastName;
					$Voters[$i]['MarathiMiddleName']=$value->MarathiMiddleName;
									
		}
		else if($MiddleName !="" && $LastName=="" && $FirstName=="")
		{
			$Voters[$i]['MarathiFirstName']=$value->MarathiFirstName;
			$Voters[$i]['MarathiLastName']=$value->MarathiLastName;
			$Voters[$i]['MarathiMiddleName']="";
					
		}
		else if($FirstName!="" && $LastName!="" && $MiddleName=="")
		{
			$Voters[$i]['MarathiFirstName']="";
			$Voters[$i]['MarathiLastName']="";
			$Voters[$i]['MarathiMiddleName']=$value->MarathiMiddleName;
			
		}
		else if($FirstName!="" && $MiddleName!="" && $LastName=="" )
		{
			$Voters[$i]['MarathiFirstName']="";
			$Voters[$i]['MarathiLastName']=$value->MarathiLastName;
			$Voters[$i]['MarathiMiddleName']="";
			
		}
		else if( $MiddleName!="" && $LastName!="" && $FirstName=="" )
		{
			$Voters[$i]['MarathiFirstName']=$value->MarathiFirstName;
			$Voters[$i]['MarathiLastName']="";
			$Voters[$i]['MarathiMiddleName']="";
			
		}
		else if($LastName!="" && $MiddleName!=""  && $FirstName!="")
		{
			$Voters[$i]['MarathiFirstName']=$value->MarathiFirstName;
			$Voters[$i]['MarathiLastName']=$value->MarathiLastName;
			$Voters[$i]['MarathiMiddleName']=$value->MarathiMiddleName;
			
		}
		$i++;
		}
		$Reply['Message']=$Message;		
		$Reply['Data']=$Voters;

		echo json_encode($Reply);
	}

	public function edit()
	{
		$States=state::where('Status', '=', 1)->get();
		$Casts=cast::all();
		$data=array("pagetitle" => "मतदार माहितीबदल करा    ","States"=>$States,"Casts"=>$Casts);
		return view('admin.edit-voter',$data);	
	}

	public function wizard()
	{
		$data=array("pagetitle" => " Wizard | Add New Voter  ");
		return view('admin.Wizard',$data);
	}

	public function Report_Dashboard()
	{
		$data=array("pagetitle" => " मतदार रिपोर्ट  ");
		return view('admin.Report_Dashboard',$data);
	}

	// Edit Voter
	public function EditVoter(Request $request)
	{
		$validator= Validator::make(
			array(
				"Voters"=>$request->Voters,
				"FirstName"=>$request->FirstName,
				"LastName"=>$request->LastName,
				"FirstNameMarathi"=>$request->FirstNameMarathi,
				"LastNameMarathi"=>$request->LastNameMarathi
				),
			array(
				"Voters"=>"required",
				"FirstName"=>"required",
				"LastName"=>"required",
				"FirstNameMarathi"=>"required",
				"LastNameMarathi"=>"required"
				)
		);

		if($validator->fails())
		{
			return redirect("/edit-voter")->withErrors($validator)->withInput();
		//	return redirect()->intended($this->redirectPath())->withErrors($validator)->withInput();
		}
		else
		{
			// Chk Voter exists
			$ChkExists=voter::where('VoterID', '=',$request->Voters)->get();
			if(count($ChkExists)==1)
			{
				// Update Voter Details
				$Birthday="";
				if($request->Birthday!="")
				{
					$Birthday=date("Y-m-d", strtotime($request->Birthday));
				}

				$MobileNumber=str_replace(' ', '', $request->MobileNumber);
				$WhatsAppMobileNumber=trim($request->WhatsAppMobileNumber);
				$affectedRows = voter::where('VoterID', '=', $request->Voters)->update(['MarathiFirstName' => $request->FirstNameMarathi,
					'MarathiMiddleName' => $request->ModdleNameMarathi,
					'MarathiLastName' => $request->LastNameMarathi,
					'EnglishFirstName' => $request->FirstName,
					'EnglishMiddleName' => $request->ModdleName,
					'EnglishLastName' => $request->LastName,
					'MobileNumber' => $MobileNumber,
					'WhatsAppNumber' =>$WhatsAppMobileNumber,
					'DateofBirth' => $Birthday,
					'NewAddress' => $request->NewAddress,
					'Education' => $request->Education,
					'Cast'=>$request->Cast
					]);

				if($affectedRows==1)
				{
					return redirect("/edit-voter")->withErrors($validator)->withInput()->with("success","मतदार माहितीत बदल केला ");
				}
				else
				{
					return redirect("/edit-voter")->withErrors($validator)->withInput()->with("error"," मतदार माहितीत बदल झाला नाही पुन्हा प्रयत्न करा  ");
				}
			}
			else
			{
				// Voter is not Exists
				return redirect("/edit-voter")->withErrors($validator)->withInput()->with("error"," मतदार माहितीत बदल झाला नाही पुन्हा प्रयत्न करा  ");				
			}
		}
	}

	public function InstantUpdateVoter(Request $request)
	{
		$ChkExists=voter::where('VoterID', '=',$request->VoterId)->get();
		$Message="";
			if(count($ChkExists)==1)
			{
				// Update Voter Details
				$MobileNumber=str_replace(' ', '', $request->MobileNumber);
				$WhatsAppMobileNumber=trim($request->WhatsAppMobileNumber);
				$affectedRows = voter::where('VoterID', '=', $request->VoterId)->
				update(['MarathiFirstName' => $request->FirstNameMarathi,
					'MarathiMiddleName' => $request->ModdleNameMarathi,
					'MarathiLastName' => $request->LastNameMarathi,
					'EnglishFirstName' => $request->FirstName,
					'EnglishMiddleName' => $request->ModdleName,
					'EnglishLastName' => $request->LastName,
					'MobileNumber' => $MobileNumber,
					'WhatsAppNumber' =>$WhatsAppMobileNumber,
					'DateofBirth' => $request->Birthday,
					'NewAddress' => $request->NewAddress,
					'Education' => $request->Education,
					'Cast'=>$request->Cast
					]);

				if($affectedRows==1)
				{

					$Message="मतदार माहितीत बदल केला";
				}
				else
				{
					$Message="मतदार माहितीत बदल झाला नाही पुन्हा प्रयत्न करा ";
				}
			}
			else
			{
				// Voter is not Exists
				$Message="मतदार माहितीत बदल झाला नाही पुन्हा प्रयत्न करा ";
			}
			$Reply['Message']=$Message;
			echo json_encode($Reply);
	}

	public function getVotersByVillageOrCity(Request $request)
	{
		// Get Village's Voter
		$City_Village_Id=$request->Village_Or_City_Id;
		if($request->IsCity==0)
		{
			// Form village
			$Voters = voter::join('tblbooth','tblvoters.BoothID','=','tblbooth.BoothID')->join('tblvillage','tblbooth.Village_City_ID','=','tblvillage.VillageId')->where('Village_City_ID', '=', $City_Village_Id)->get();

			//$Voters=voter::where('Village_City_ID', '=', $City_Village_Id)->join('tblbooth','tblvoters.BoothID','=','tblbooth.BoothID')->get();
			echo json_encode($Voters);
		}
		else
		{
			// From City
			$Voters = voter::join('tblbooth','tblvoters.BoothID','=','tblbooth.BoothID')->join('tblcity','tblbooth.Village_City_ID','=','tblcity.CityId')->where('Village_City_ID', '=', $City_Village_Id)->get();

			//$Voters=voter::where('Village_City_ID', '=', $City_Village_Id)->join('tblbooth','tblvoters.BoothID','=','tblbooth.BoothID')->get();
			echo json_encode($Voters);
		}
	}

	public function getVoterDetailById(Request $request)
	{
		$Response=array();
		$VoterDetails=voter::where('VoterID', '=',$request->VoterId)->get();
		$BoothNo=-1;
		$IsCity=0;
		// Get Booth Number
		foreach ($VoterDetails as $key => $value) {
			$BoothNo=$value['BoothID'];
		}

		// Get Village or City id
		$VillageId=booth::where('BoothID', '=',$BoothNo)->get();
		$Village_City_Id=-1;
		foreach ($VillageId as $key => $value) {
			$Village_City_Id=$value['Village_City_ID'];
			$IsCity=$value['IsCity'];
		}

		$Tehsils=array();
		// get Tehsil id 
		$Villages_Cities=array();
		if($IsCity==0) // Village Id
		{
			$Villages_Cities=village::where('VillageID','=',$Village_City_Id)->get();
		}
		else if($IsCity==1) // City Id
		{
			$Villages_Cities=city::where('CityID','=',$Village_City_Id)->get();
		}

		$tehsilId=-1;
		foreach ($Villages_Cities as $key => $value) {
			$tehsilId=$value['TehsilID'];
		}	
		// Get District ID
		$DistrictID=-1;
		$Teh=tehsil::where('TehsilID', '=',$tehsilId)->get();

		foreach ($Teh as $key => $value) {
			$DistrictID=$value['DistrictID'];
		}
		// ZoneID

		$ZoneID=-1;
		$Dist=district::where('DistrictID', '=',$DistrictID)->get();
		foreach ($Dist as $key => $value) {
			$ZoneID=$value['ZoneID'];
		}
		// Get State ID

		$StateID=-1;
		$Zon=zone::where('ZoneID', '=',$ZoneID)->get();
		foreach ($Zon as $key => $value) {
			$StateID=$value['StateID'];
		}

		$Response['Voters']=$VoterDetails;
		$Response['SelectBooth']=$BoothNo;
		$Response['IsCity']=$IsCity;
		$Response['SelectCity_Village']=$Village_City_Id;
		$Response['SelectTehsil']=$tehsilId;
		$Response['SelectDistrict']=$DistrictID;
		$Response['SelectZone']=$ZoneID;
		$Response['SelectState']=$StateID;

		// Get All States
		$States=array();
		$States=state::where('Status', '=', 1)->get();
		
		// Get All Zones from State

		$Zones=zone::where('StateID', '=',$StateID)->get();

		// Get All Districts from zone
		$Districts=district::where('ZoneID', '=',$ZoneID)->get();		

		// Get All Tehsils from district
		$Tehsils=tehsil::where('DistrictID', '=',$DistrictID)->get();		

		// Get All City or Villages from tehsil
		$Citys_Villages=array();
		if($IsCity==0) // Village Id
		{
			$Citys_Villages=village::where('TehsilID', '=',$tehsilId)->get();		
		}
		else if($IsCity==1) // City Id
		{
			$Citys_Villages=city::where('TehsilID', '=',$tehsilId)->get();		
		}
		// Get all Booths from village or City
		$Booths=array();
		$Booths=booth::where('Village_City_ID', '=',$Village_City_Id)->get();

		//$Response['Booths']=$Booths;
		$Casts=array();
		$Casts=DB::select("select CastId,CastName from tblcast");
		$Response['Casts']=$Casts;
		$Response['Citys_Villages']=$Citys_Villages;
		$Response['Tehsils']=$Tehsils;
		$Response['Districts']=$Districts;
		$Response['Zones']=$Zones;
		$Response['States']=$States;

		echo json_encode($Response);
	}
	// Voter Details 
	public function voter(Request $request)
	{
		//$voters = voter::where('VoterID', '=', $request->VoterID)->get();
		$voters=DB::select("select * from tblvoters,tblbooth where tblvoters.BoothID=tblbooth.BoothID and tblvoters.VoterID=".$request->VoterID);
		$AppUsers=DB::select("select * from tblandroidappusers,tblandroiduservoters where tblandroidappusers.AppUserID=tblandroiduservoters.AppUserId and tblandroiduservoters.VoterId=$request->VoterID ");
		$data=array("pagetitle" => " मतदार माहिती   ","voter"=>$voters,"AppUsers"=>$AppUsers);
		return view('admin.VoterDetails',$data);
	}

	public function loadAvailableCitiesOrVillages(Request $request)
	{
		$IsCity=$request->IsCity;
		$Villages_Cities=array();
		$TehsilID=$request->Tehsil;
		if($IsCity==0)
		{
			// Villages
			$Villages_Cities=DB::select("select distinct tblvillage.VillageID,tblvillage.VillageName from tblvillage,tbltehsil where tbltehsil.TehsilID=tblvillage.TehsilID and tbltehsil.TehsilID=$TehsilID");
		}
		else if($IsCity==1)
		{
			// Cities
			$Villages_Cities=DB::select("select distinct tblcity.CityID,tblcity.CityName from tblcity,tbltehsil where tbltehsil.TehsilID=tblcity.TehsilID and tbltehsil.TehsilID=$TehsilID");
		}
		echo json_encode($Villages_Cities);
	}

	public function loadPrabhag(Request $request)
	{
		$IsCity=$request->IsCity;
		$Villages_Cities=array();
		$City_Village_Id=$request->City_Village_Id;
		if($IsCity==0)
		{
			// Villages
			$Villages_Cities=DB::select("select distinct tblprabhag.PrabhagID,tblprabhag.PrabhagName from tblvillage,tblprabhag where tblprabhag.Village_City_ID=tblvillage.VillageID and tblprabhag.Village_City_ID=$City_Village_Id");
		}
		else if($IsCity==1)
		{
			// Cities
			$Villages_Cities=DB::select("select distinct tblprabhag.PrabhagID,tblprabhag.PrabhagName from tblcity,tblprabhag where tblprabhag.Village_City_ID=tblcity.CityID and tblprabhag.Village_City_ID=$City_Village_Id");
		}
		echo json_encode($Villages_Cities);
	}

	// Load Surnames under cities or villages
	public function loadSurnames(Request $request)
	{
		$Village_CityID=$request->CorV_ID;
		$IsCity=$request->IsCity;
		$PrabhagOrWard=$request->PrabhagOrWard;
		$BoothId=$request->BoothId;

		$Villages_Cities=array();
		if($PrabhagOrWard=="" && $BoothId=="" )
		{
			if($IsCity==0)
			{
				// Load Voters Surname from Village
				$Villages_Cities=DB::select("select distinct tblvoters.MarathiLastName,tblvoters.EnglishLastName,count(tblvoters.MarathiLastName) as Total from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID group by MarathiLastName order by Total desc");
			}
			else if($IsCity==1)
			{
				// Load Voters Surnames From City
				$Villages_Cities=DB::select("select distinct tblvoters.MarathiLastName,tblvoters.EnglishLastName,count(tblvoters.MarathiLastName) as Total from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblbooth.Village_City_ID=$Village_CityID group by MarathiLastName order by Total desc");
			}
		}
		else if($BoothId!="" && $PrabhagOrWard=="")
		{
			// Load Voters Surnames from Booth
			$Villages_Cities=DB::select("select distinct tblvoters.MarathiLastName,tblvoters.EnglishLastName,count(tblvoters.MarathiLastName) as Total from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId group by MarathiLastName order by Total desc");
		}
		else if($PrabhagOrWard!="" && $BoothId=="" )
		{
			// Load Voters Surnames from Prabhag
			$Villages_Cities=DB::select("select distinct tblvoters.MarathiLastName,tblvoters.EnglishLastName,count(tblvoters.MarathiLastName) as Total from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagOrWard' group by MarathiLastName order by Total desc");
		}
		echo json_encode($Villages_Cities);
	}

	public function searchSurname(Request $request)
	{
		$Village_CityID=$request->CorV_ID;
		$IsCity=$request->IsCity;
		$PrabhagId=$request->PrabhagId;
		$BoothId=$request->BoothId;
		$Surname=$request->Surname;
		$Voters=array();
		if($PrabhagId=="" && $BoothId=="" )
		{
			if($IsCity==0)
			{
				// Load Voters Surname from Village
				if($Surname=="")
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
				}
				else
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.MarathiLastName='$Surname' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");					
				}
			}
			else if($IsCity==1)
			{
				// Load Voters Surnames From City
				if($Surname=="")
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
				}
				else
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.MarathiLastName='$Surname' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
				}
			}
		}
		else if($BoothId!="" && $PrabhagId=="")
		{
			// Load Voters Surnames from Booth
			if($Surname=="")
			{
				$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId order by MarathiLastName desc");
			}
			else
			{
				$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.MarathiLastName='$Surname' order by MarathiLastName desc");				
			}
		}
		else if($PrabhagId!="" && $BoothId=="" )
		{
			// Load Voters Surnames from Prabhag
			if($Surname=="")
			{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID  and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
			}
			else
			{
				$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and  tblvoters.MarathiLastName='$Surname' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");				
			}

		}
		$Rply=array();
		$Reply=array();
		$i=0;
		foreach ($Voters as $key => $value) {
			$VotingAnalysis=$value->VotingAnalysis;
			if($VotingAnalysis=="इतर")
			{
				if($value->IsPoliticallyStrong==1)
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img> &nbsp;&nbsp; ";
				}
				else
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
				}
			}
			else if($VotingAnalysis=="आपला")
			{
				if($value->IsPoliticallyStrong==1)
				{
					$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
				}
				else
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
				}				
			}
			else if($VotingAnalysis=="विरोधी")			
			{
				if($value->IsPoliticallyStrong==1)
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
				}
				else
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
				}				
			}
			else if($VotingAnalysis=="संदिग्ध")
			{
				if($value->IsPoliticallyStrong==1)
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
				}
				else
				{
					$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
				}
			}

			$Rply[$i]['SrNo']=$value->SrNo;
			$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
			$Rply[$i]['MobileNumber']=$value->MobileNumber;
			$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
			$Rply[$i]['Email']=$value->Email;
			$Rply[$i]['EPICNumber']=$value->EPICNumber;
			$Rply[$i]['VotingCenter']=$value->VotingCentre;
			$Rply[$i]['BoothNumber']=$value->BoothNumber;
			$Rply[$i]['Address']=$value->Address;
			$Rply[$i]['NewAddress']=$value->NewAddress;
			$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
			$i++;
		}
		$Reply['aaData']=$Rply;
		echo json_encode($Reply);
	}	

	public function report(Request $request)
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => " आडनावानुसार मतदार रिपोर्ट  ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		//$Districts=district::where('Status','=',1)->get();

		//$data=array("pagetitle" => " आडनावानुसार मतदार रिपोर्ट  ","Districts"=>$Districts);
		return view('admin.report',$data);
	}

	public function search(Request $request)
	{
		return redirect("/dashboard");	
	}

	public function report_by_seurnam()
	{
		$Districts=district::where('Status','=',1)->get();
		// Get All Surnames
		// echo json_encode($Districts);
		$data=array("pagetitle" => " आडनावानुसार मतदार रिपोर्ट  ","Districts"=>$Districts);
		return view('admin.report',$data);
	}

	public function report_by_politically_strong()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => "राजकीयदृष्ट्या प्रभावी मतदार रिपोर्ट ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);
		//$data=array("pagetitle" => " राजकीयदृष्ट्या प्रभावी मतदार रिपोर्ट   ","Districts"=>$Districts);
		return view('admin.report-by-politically-strong',$data);
	}

	public function getVotersPoliticalStatus(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$IsPoliticallyStrong=$request->IsPoliticallyStrong;
			$Voters=array();
			if($PrabhagId=="" && $BoothId=="" )
			{
				if($IsCity==0)
				{
					// Load Voters Surname from Village
					if($IsPoliticallyStrong=="")
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.IsPoliticallyStrong=$IsPoliticallyStrong and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($IsCity==1)
				{
					// Load Voters Surnames From City
					if($IsPoliticallyStrong=="")
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.IsPoliticallyStrong=$IsPoliticallyStrong and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
					
				}
			}
			else if($BoothId!="" && $PrabhagId=="")
			{
				// Load Voters Surnames from Booth
				if($IsPoliticallyStrong=="")
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId order by MarathiLastName desc");
				}
				else
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.IsPoliticallyStrong=$IsPoliticallyStrong order by MarathiLastName desc");					
				}
			}
			else if($PrabhagId!="" && $BoothId=="" )
			{
				// Load Voters Surnames from Prabhag
				if($IsPoliticallyStrong=="")
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
				else
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.IsPoliticallyStrong=$IsPoliticallyStrong and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");					
				}
			}
			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";

				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);	
	}

	public function report_by_booth_wise()
	{
 		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			//$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => " बुथनिहाय मतदार रिपोर्ट  ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths);

		//$Districts=district::where('Status','=',1)->get();
		// Get All Surnames
		//echo json_encode($Districts);
		//$data=array("pagetitle" => " बुथनिहाय मतदार रिपोर्ट  ","Districts"=>$Districts);

		return view('admin.report_by_booth_wise',$data);
	}
	public function getVotersByBooth(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$BoothId=$request->BoothId;
			$Voters=array();
			if( $BoothId=="" )
			{
				if($IsCity==0)
				{
					// Load Voters Surname from Village
					$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
				}
				else if($IsCity==1)
				{
					// Load Voters Surnames From City
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
				}
			}
			else if($BoothId!="" )
			{
				// Load Voters Surnames from Booth
				$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId order by MarathiLastName desc");
			}
			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";

				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);
	}

	public function report_by_color()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => "मतदार अंदाजानुसार रिपोर्ट  ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);
		//$data=array("pagetitle" => " मतदार अंदाजानुसार रिपोर्ट  ","Districts"=>$Districts);
		return view('admin.report_by_color',$data);
	}

	public function getVotersByColor(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$VotingAnalysis=$request->VotingAnalysis;
			$Voters=array();
			if($VotingAnalysis=="")
			{
				if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
							$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1  and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId  order by MarathiLastName desc";
					$Voters=DB::select($Query);
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID order by MarathiLastName desc";
					$Voters=DB::select($Query);
				}		
			}
			else{
					if($PrabhagId=="" && $BoothId=="" )
					{
						if($IsCity==0)
						{
							// Load Voters Surname from Village
								$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.VotingAnalysis='$VotingAnalysis' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
						}
						else if($IsCity==1)
						{
							// Load Voters Surnames From City
							$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.VotingAnalysis='$VotingAnalysis' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
						}
					}
					else if($BoothId!="" && $PrabhagId=="")
					{
						// Load Voters Surnames from Booth
						$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.VotingAnalysis='$VotingAnalysis' order by MarathiLastName desc";
						$Voters=DB::select($Query);
					}
					else if($PrabhagId!="" && $BoothId=="" )
					{
						// Load Voters Surnames from Prabhag
						$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.VotingAnalysis='$VotingAnalysis' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc";
						$Voters=DB::select($Query);
					}				
			}

			//echo $Query;
			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);	
	}

	public function report_by_color2()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => " मतदार अंदाजानुसार रिपोर्ट   ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		//$data=array("pagetitle" => "  मतदार अंदाजानुसार रिपोर्ट   ","Districts"=>$Districts);
		return view('admin.report_by_color_voting',$data);
	}

	public function getVotersByColor2(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$VotingAnalysis=$request->VotingAnalysis;
			$VotingStatus=$request->VotingStatus;
			$Voters=array();
			if($VotingAnalysis=="")
			{
				if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						if($VotingStatus=="")
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
						}
						else
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID and tblvoters.IsVoted=$VotingStatus order by MarathiLastName desc");
						}
						
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						if($VotingStatus=="")
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1  and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
						}
						else
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1  and tblbooth.Village_City_ID=$Village_CityID and tblvoters.IsVoted=$VotingStatus order by MarathiLastName desc");
						}

					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					if($VotingStatus=="")
					{
						$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId  order by MarathiLastName desc";						
					}
					else
					{
						$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.IsVoted=$VotingStatus order by MarathiLastName desc";
					}
					
					$Voters=DB::select($Query);
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					if($VotingStatus=="")
					{
						$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID order by MarathiLastName desc";
					}
					else
					{
						$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.IsVoted=$VotingStatus order by MarathiLastName desc";
					}
					$Voters=DB::select($Query);
				}		
			}
			else{
					if($PrabhagId=="" && $BoothId=="" )
					{
						if($IsCity==0)
						{
							// Load Voters Surname from Village
							if($VotingStatus=="")
							{
								$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.VotingAnalysis='$VotingAnalysis' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
							}
							else
							{
								$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.VotingAnalysis='$VotingAnalysis' and tblvillage.VillageID=$Village_CityID and tblvoters.IsVoted=$VotingStatus order by MarathiLastName desc");
							}
							
						}
						else if($IsCity==1)
						{
							// Load Voters Surnames From City
							if($VotingStatus=="")
							{
								$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.VotingAnalysis='$VotingAnalysis' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
							}
							else
							{
								$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.VotingAnalysis='$VotingAnalysis' and tblbooth.Village_City_ID=$Village_CityID and tblvoters.IsVoted=$VotingStatus order by MarathiLastName desc");
							}
							
						}
					}
					else if($BoothId!="" && $PrabhagId=="")
					{
						// Load Voters Surnames from Booth
						if($VotingStatus=="")
						{
							$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.VotingAnalysis='$VotingAnalysis' order by MarathiLastName desc";
						}
						else
						{
							$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.VotingAnalysis='$VotingAnalysis' and tblvoters.IsVoted=$VotingStatus order by MarathiLastName desc";
						}
						
						$Voters=DB::select($Query);
					}
					else if($PrabhagId!="" && $BoothId=="" )
					{
						// Load Voters Surnames from Prabhag
						if($VotingStatus=="")
						{
							$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' and tblvoters.VotingAnalysis='$VotingAnalysis' order by MarathiLastName desc";
						}
						else
						{
							$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' and tblvoters.VotingAnalysis='$VotingAnalysis' and tblvoters.IsVoted=$VotingStatus order by MarathiLastName desc";							
						}
						
						$Voters=DB::select($Query);
					}				
			}

			//echo $Query;
			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				if($value->IsVoted==0)
				{
					$Rply[$i]['IsVoted']="नाही";
				}
				else if($value->IsVoted==1)
				{
					$Rply[$i]['IsVoted']="होय";
				}
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);	
	}	

	public function loadVotedVotersCount(Request $request)
	{
		$IsCity=$request->IsCity;
		$CityOrVillage=$request->CityOrVillage;
		$Booth=$request->Booth;
		$Prabhag=$request->Prabhag;
		$Reply=array();$Query="";
		if($Booth=="" && $Prabhag=="")
		{
			// Load from City or Villages
			if($IsCity==1)
			{
				//Load Count From City
				$Query="";
			}
			else
			{
				// Load Count From Village

			}
		}
		else 
		{
			if($Booth!="" && $Prabhag=="")
			{

			}
			else if($Prabhag!="" && $Booth=="")
			{

			}
		}
	}

	public function report_by_dead_voters()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => " जिवंत - मृत मतदार रिपोर्ट  ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

	//	$data=array("pagetitle" => " जिवंत - मृत मतदार रिपोर्ट  ","Districts"=>$Districts);
		return view('admin.report_by_dead_voters',$data);
	}

	public function getVotersByDeadStatus(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$IsDead=$request->IsDead;
			if($IsDead=="")
			{
				$IsDead="0 and tblvoters.IsDead=1";
			}
			$Voters=array();
			if($PrabhagId=="" && $BoothId=="" )
			{
				if($IsCity==0)
				{
					// Load Voters Surname from Village
					$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.IsDead='$IsDead' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
				}
				else if($IsCity==1)
				{
					// Load Voters Surnames From City
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.IsDead='$IsDead' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
				}
			}
			else if($BoothId!="" && $PrabhagId=="")
			{
				// Load Voters Surnames from Booth
				$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.IsDead='$IsDead' order by MarathiLastName desc");
			}
			else if($PrabhagId!="" && $BoothId=="" )
			{
				// Load Voters Surnames from Prabhag
				$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.IsDead='$IsDead' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
			}
			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				if($value->IsDead==0)
				{
					$Rply[$i]['IsDead']="नाही";
				}
				else if($value->IsDead==1)
				{
					$Rply[$i]['IsDead']="होय";
				}

				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);	
	}

	public function report_by_voted_voters()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => " संपूर्ण मतदान रिपोर्ट   ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		//$data=array("pagetitle" => " संपूर्ण मतदान रिपोर्ट   ","Districts"=>$Districts);
		return view('admin.report_by_voted_voters',$data);
	}

	public function getVotersByIsVotingStatus(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$IsVoted=$request->IsVoted;
			if($IsVoted=="")
			{
				//$IsVoted="0 and tblvoters.IsVoted=1 ";
			}
			$Voters=array();
			if($PrabhagId=="" && $BoothId=="" )
			{
				if($IsCity==0)
				{
					// Load Voters Surname from Village
					if($IsVoted=="")
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.IsVoted='$IsVoted' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");						
					}
					
				}
				else if($IsCity==1)
				{
					// Load Voters Surnames From City
					if($IsVoted=="")
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.IsVoted='$IsVoted' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}

				}
			}
			else if($BoothId!="" && $PrabhagId=="")
			{
				// Load Voters Surnames from Booth
				if($IsVoted=="")
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId order by MarathiLastName desc");
				}
				else
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.IsVoted='$IsVoted' order by MarathiLastName desc");
				}
			}
			else if($PrabhagId!="" && $BoothId=="" )
			{
				// Load Voters Surnames from Prabhag
				if($IsVoted=="")
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
				else
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.IsVoted='$IsVoted' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
			}
			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);
	}

	public function report_by_mobile_number()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => " मोबाईल नंबर्स रिपोर्ट    ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		//$data=array("pagetitle" => " मोबाईल नंबर्स रिपोर्ट   ","Districts"=>$Districts);
		return view('admin.report_by_mobile_number',$data);
	}

	public function getVotersByIsMobileNumbers(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$MobileStatus=$request->MobileStatus;
			$Voters=array();
			if($PrabhagId=="" && $BoothId=="" )
			{
				if($IsCity==0)
				{
					// Load Voters Surname from Village
					if($MobileStatus==1)
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.MobileNumber!='' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.MobileNumber='' and  tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($IsCity==1)
				{
					// Load Voters Surnames From City
					if($MobileStatus==1)
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.MobileNumber!='' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.MobileNumber='' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
			}
			else if($BoothId!="" && $PrabhagId=="")
			{
				// Load Voters Surnames from Booth
				if($MobileStatus==1)
				{				
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.MobileNumber!='' order by MarathiLastName desc");				
				}
				else
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.MobileNumber='' and tblvoters.BoothID=$BoothId order by MarathiLastName desc");
				}
			}
			else if($PrabhagId!="" && $BoothId=="" )
			{
				// Load Voters Surnames from Prabhag
				if($MobileStatus==1)
				{				
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.MobileNumber!='' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
				else
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.MobileNumber='' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
	
			}
			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);
	}
	 // Whatsapp Mobile Numbers


	public function report_by_whatsapp_number()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => "  व्हॉट्सअप नंबर्स रिपोर्ट  ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		//$data=array("pagetitle" => "  व्हॉट्सअप नंबर्स रिपोर्ट   ","Districts"=>$Districts);
		return view('admin.report_by_whatsapp_number',$data);
	}

	public function getVotersByIsWhatsappNumbers(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$MobileStatus=$request->MobileStatus;
			$Voters=array();
			if($PrabhagId=="" && $BoothId=="" )
			{
				if($IsCity==0)
				{
					// Load Voters Surname from Village
					if($MobileStatus==1)
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.WhatsAppNumber!='' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.WhatsAppNumber='' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($IsCity==1)
				{
					// Load Voters Surnames From City
					if($MobileStatus==1)
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.WhatsAppNumber!='' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.WhatsAppNumber='' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
					
				}
			}
			else if($BoothId!="" && $PrabhagId=="")
			{
				// Load Voters Surnames from Booth
					if($MobileStatus==1)
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.WhatsAppNumber!='' order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.WhatsAppNumber='' order by MarathiLastName desc");
					}				
				
			}
			else if($PrabhagId!="" && $BoothId=="" )
			{
				// Load Voters Surnames from Prabhag
					if($MobileStatus==1)
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WhatsAppNumber!='' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WhatsAppNumber='' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
					}				

			}
			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);
	}


	public function report_by_email()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => " इमेल रिपोर्ट  ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		//$data=array("pagetitle" => " इमेल रिपोर्ट | Satta ","Districts"=>$Districts);
		return view('admin.report_by_email',$data);
	}

	public function getVotersByEmail(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$EmailStatus=$request->EmailStatus;
			$Voters=array();
			if($PrabhagId=="" && $BoothId=="" )
			{
				if($IsCity==0)
				{
					// Load Voters Surname from Village
					if($EmailStatus==1)
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.Email!='' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");			
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.Email='' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($IsCity==1)
				{
					// Load Voters Surnames From City
					if($EmailStatus==1)
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.Email!='' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.Email='' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");		
					}
					
				}
			}
			else if($BoothId!="" && $PrabhagId=="")
			{
				// Load Voters Surnames from Booth
					if($EmailStatus==1)
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.Email!='' order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.Email='' order by MarathiLastName desc");
					}
			}
			else if($PrabhagId!="" && $BoothId=="" )
			{

				// Load Voters Surnames from Prabhag
					if($EmailStatus==1)
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.Email!='' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.Email='' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
					}				

			}
			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);
	}

	// Reports by Gender
	public function report_by_gender()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => " स्त्री - पुरुष मतदार रिपोर्ट   ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		//$data=array("pagetitle" => "स्त्री - पुरुष मतदार रिपोर्ट  ","Districts"=>$Districts);
		return view('admin.report_by_gender',$data);
	}

	public function getVotersByGender(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$Gender=$request->Gender;
			$Voters=array();
			if($PrabhagId=="" && $BoothId=="" )
			{
				if($IsCity==0)
				{
					// Load Voters Surname from Village
					if($Gender=="")
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.Sex='$Gender' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
						
				}
				else if($IsCity==1)
				{
					// Load Voters Surnames From City
					if($Gender=="")
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
					else
					{
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.Sex='$Gender' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
			}
			else if($BoothId!="" && $PrabhagId=="")
			{
				// Load Voters Surnames from Booth
				if($Gender=="")
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId order by MarathiLastName desc");
				}
				else
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.Sex='$Gender' order by MarathiLastName desc");
				}
			}
			else if($PrabhagId!="" && $BoothId=="" )
			{
				// Load Voters Surnames from Prabhag
				if($Gender=="")
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
				else
				{
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.Sex='$Gender' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
			}
			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				if($value->Sex=="M")
				{
					$Rply[$i]['Sex']="पुरुष";
				}
				else if($value->Sex=="F")
				{
					$Rply[$i]['Sex']="स्त्री";
				}

				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);
	}

	// By Birthday
	public function report_by_birthday()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$data=array("pagetitle" => " जन्मतारीख/वाढदिवस रिपोर्ट  ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

	//	$data=array("pagetitle" => " जन्मतारीख/वाढदिवस रिपोर्ट  ","Districts"=>$Districts);
		return view('admin.report_by_birthday',$data);
	}

	public function getVotersByBirthday(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$Birthday1=$request->Birthday1;
			$Birthday2=$request->Birthday2;

			$Voters=array();
			if($Birthday1=="" && $Birthday2=="")
			{
    			if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}	
			}
			else if($Birthday1!="" && $Birthday2=="")
			{
				$Birthday1=date("Y-m-d", strtotime($request->Birthday1));
				if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and DATE_FORMAT(tblvoters.DateofBirth, '%m-%d') = DATE_FORMAT('$Birthday1', '%m-%d') and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and DATE_FORMAT(tblvoters.DateofBirth, '%m-%d') = DATE_FORMAT('$Birthday1', '%m-%d')  and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and DATE_FORMAT(tblvoters.DateofBirth, '%m-%d') = DATE_FORMAT('$Birthday1', '%m-%d')  order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and DATE_FORMAT(tblvoters.DateofBirth, '%m-%d') = DATE_FORMAT('$Birthday1', '%m-%d') and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
			}
			else if($Birthday2!="" && $Birthday1=="")
			{
				$Birthday2=date("Y-m-d", strtotime($request->Birthday2));
				if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and DATE_FORMAT(tblvoters.DateofBirth, '%m-%d') = DATE_FORMAT('$Birthday2', '%m-%d')  and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and DATE_FORMAT(tblvoters.DateofBirth, '%m-%d') = DATE_FORMAT('$Birthday2', '%m-%d') and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and DATE_FORMAT(tblvoters.DateofBirth, '%m-%d') = DATE_FORMAT('$Birthday2', '%m-%d') order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and DATE_FORMAT(tblvoters.DateofBirth, '%m-%d') = DATE_FORMAT('$Birthday2', '%m-%d') and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
			}
			else if($Birthday1!="" && $Birthday2!="")
			{
				$Birthday1=date("Y-m-d", strtotime($request->Birthday1));
				$Birthday2=date("Y-m-d", strtotime($request->Birthday2));
				if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and DATE_FORMAT(tblvoters.DateofBirth, '%m-%d') between DATE_FORMAT('$Birthday1', '%m-%d') and DATE_FORMAT('$Birthday2', '%m-%d') and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and DATE_FORMAT(tblvoters.DateofBirth, '%m-%d') between DATE_FORMAT('$Birthday1', '%m-%d') and DATE_FORMAT('$Birthday2', '%m-%d') and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and DATE_FORMAT(tblvoters.DateofBirth, '%m-%d') between DATE_FORMAT('$Birthday1', '%m-%d') and DATE_FORMAT('$Birthday2', '%m-%d') order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and (DATE_FORMAT(tblvoters.DateofBirth, '%m-%d') between DATE_FORMAT('$Birthday1', '%m-%d') and DATE_FORMAT('$Birthday2', '%m-%d')) and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
			}

			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				$Rply[$i]['DateofBirth']=$value->DateofBirth;
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);
	}


	public function report_by_education()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}
		
		$data=array("pagetitle" => " शिक्षणानुसार मतदार रिपोर्ट  ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		//$data=array("pagetitle" => " शिक्षणानुसार मतदार रिपोर्ट  ","Districts"=>$Districts);
		return view('admin.report_by_education',$data);
	}

	public function getVotersByEducation(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$Education=$request->Education;
			$Voters=array();
			if($Education=="")
			{
    			if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
							$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.Education!='' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblbooth.Village_City_ID=$Village_CityID and tblvoters.Education!='' order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.Education!='' order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' and tblvoters.Education!='' order by MarathiLastName desc");
				}	
			}
			else if($Education!="")
			{
				if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
							$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.Education='$Education' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.Education='$Education' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.Education='$Education' order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.Education='$Education' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
			}
			
			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				$Rply[$i]['Education']=$value->Education;
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);
	}

	public function report_by_cast()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$Casts=DB::select("select * from tblcast");
		$data=array("pagetitle" => "जातनिहाय मतदान रिपोर्ट  ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags,"Casts"=>$Casts);
		

		//$data=array("pagetitle" => " जातनिहाय मतदान रिपोर्ट   ","Districts"=>$Districts,"Casts"=>$Casts);
		return view('admin.report-by-cast',$data);
	}

	public function getVotersByCast(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$Cast=$request->Cast;
			$Voters=array();
			if($Cast=="")
			{
    			if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID and tblvoters.Cast!='' order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblbooth.Village_City_ID=$Village_CityID and tblvoters.Cast!='' order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.Cast!='' order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' and tblvoters.Cast!='' order by MarathiLastName desc");
				}	
			}
			else if($Cast!="")
			{
				if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.Cast='$Cast' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.Cast='$Cast' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.Cast='$Cast' order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.Cast='$Cast' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
			}
			
			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;				
				$Rply[$i]['Cast']=$value->Cast;
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);
	}

	public function report_by_profession()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}
		
		$data=array("pagetitle" => "प्रोफेशननुसार मतदार रिपोर्ट   ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

	//	$data=array("pagetitle" => " प्रोफेशननुसार मतदार रिपोर्ट   ","Districts"=>$Districts);
		return view('admin.report-by-profession',$data);
	}

	public function getVotersByProfession(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$Profession=$request->Profession;
			$Voters=array();
			if($Profession=="")
			{
    			if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.Profession!='' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblbooth.Village_City_ID=$Village_CityID and tblvoters.Profession!='' order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.Profession!='' order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' and tblvoters.Profession!='' order by MarathiLastName desc");
				}	
			}
			else if($Profession!="")
			{
				if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.Profession='$Profession' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.Profession='$Profession' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.Profession='$Profession' order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.Profession='$Profession' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
			}

			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				$Rply[$i]['Profession']=$value->Profession;								
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);		
	}

	public function report_by_age()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}

		$Casts=DB::select("select * from tblcast");
		$data=array("pagetitle" => " वयानुसार मतदार रिपोर्ट  ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags,"Casts"=>$Casts);

		//$data=array("pagetitle" => " वयानुसार मतदार रिपोर्ट  ","Districts"=>$Districts);
		return view('admin.report_by_age',$data);
	}

	public function getVotersByAge(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$MinAge=$request->MinAge;
			$MaxAge=$request->MaxAge;

			$Voters=array();
			if($MinAge=="" && $MaxAge=="")
			{
    			if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}	
			}
			else if($MinAge!="" && $MaxAge=="")
			{
				if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.Age='$MinAge' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.Age='$MinAge' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.Age='$MinAge' order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.Age='$MinAge' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
			}
			else if($MaxAge!="" && $MinAge=="")
			{
				if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.Age='$MaxAge' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.Age='$MaxAge' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.Age='$MaxAge' order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.Age='$MaxAge' and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
			}
			else if($MinAge!="" && $MaxAge!="")
			{
				if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.Age between '$MinAge' and '$MaxAge' and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.Age between '$MinAge' and '$MaxAge' and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.Age between '$MinAge' and '$MaxAge' order by MarathiLastName desc");
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and (tblvoters.Age between '$MinAge' and '$MaxAge') and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
				}
			}

			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				$Rply[$i]['Age']=$value->Age;								
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);
	}

	public function report_by_address()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}
		$data=array("pagetitle" => " पत्त्यानुसार मतदार रिपोर्ट   ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);
		return view('admin.report-by-address',$data);
	}

	public function getVotersByAddress(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$SMS=$request->SMS;
			$Voters=array();
    			if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						if($SMS==0)
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
						}
						else if($SMS==1)
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID and tblvoters.MobileNumber!='' order by MarathiLastName desc");
						}
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						if($SMS==0)
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblbooth.Village_City_ID=$Village_CityID order by MarathiLastName desc");
						}
						else if($SMS==1)
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblbooth.Village_City_ID=$Village_CityID and tblvoters.MobileNumber!='' order by MarathiLastName desc");
						}
					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
						if($SMS==0)
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId order by MarathiLastName desc");
						}
						else if($SMS==1)
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.MobileNumber!='' order by MarathiLastName desc");
						}
					
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
						if($SMS==0)
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' order by MarathiLastName desc");
						}
						else if($SMS==1)
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' and tblvoters.MobileNumber!='' order by MarathiLastName desc");
						}
				}	

			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				if($SMS==0)
				{
					$Rply[$i]['SrNo']=$value->SrNo;
					$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
					$Rply[$i]['MobileNumber']=$value->MobileNumber;
					$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
					$Rply[$i]['Email']=$value->Email;
					$Rply[$i]['EPICNumber']=$value->EPICNumber;
					$Rply[$i]['VotingCenter']=$value->VotingCentre;
					$Rply[$i]['BoothNumber']=$value->BoothNumber;
					$Rply[$i]['Address']=$value->Address;
					$Rply[$i]['NewAddress']=$value->NewAddress;
					$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
					$Rply[$i]['SMS']="";
				}
				else if($SMS==1)
				{
						$Rply[$i]['SrNo']=$value->SrNo;
						$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
						$Rply[$i]['MobileNumber']=$value->MobileNumber;
						$Rply[$i]['WhatsAppNumber']="";
						$Rply[$i]['Email']="";
						$Rply[$i]['EPICNumber']="";
						$Rply[$i]['VotingCenter']="";
						$Rply[$i]['BoothNumber']="";
						$Rply[$i]['Address']="";
						$Rply[$i]['NewAddress']="";
						$Rply[$i]['View']="";
						$Rply[$i]['SMS']="<input type='checkbox' id='Voter_".$i."' name='Voter_".$i."' onchange='Unselect()' value='".$value->VoterID."'>";
				}
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);
	}

	public function report_by_handicaped()
	{
		$DefaultValues=DB::select("select * from tbldefaultvalues");
		$DistrictID=-1;
		$TehsilID=-1;
		$CityID=-1;
		$VillageID=-1;
		$DefaultValue=-1;
		$Tehsils=array();
		$Cities_Villages=array();
		$IsCity=-1;
		foreach ($DefaultValues as $key => $value) {
			$DistrictID=$value->DistrictID;
			$TehsilID=$value->TehsilID;
			$CityID=$value->CityID;
			$VillageID=$value->VillageID;
		}
		if($DistrictID!=-1)
		{
			$DefaultValue="District";
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($TehsilID!=-1)
		{
			$DefaultValue="Tehsil";
			$DistrictDetails=tehsil::where("TehsilID",'=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
		}
		if($CityID!=-1)
		{
			$DefaultValue="City";
			$TehsilDetails=city::where('CityID','=',$CityID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}
			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}
			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=city::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=1;
		}

		if($VillageID!=-1)
		{
			$DefaultValue="Village";
			$TehsilDetails=village::where('VillageID','=',$VillageID)->get();
			foreach ($TehsilDetails as $key => $value) {
				$TehsilID=$value->TehsilID;
			}

			$DistrictDetails=tehsil::where('TehsilID','=',$TehsilID)->get();
			foreach ($DistrictDetails as $key => $value) {
				$DistrictID=$value->DistrictID;
			}

			$Tehsils=tehsil::where('DistrictID','=',$DistrictID)->get();
			$Cities_Villages=village::where("TehsilID",'=',$TehsilID)->get();
			$IsCity=0;
		}

		$SelectedCity_Village=-1;
		if($IsCity==0)
		{
			$SelectedCity_Village=$VillageID;
		}
		else if($IsCity==1)
		{
			$SelectedCity_Village=$CityID;
		}
		$Districts=district::where('Status','=',1)->get();
		$Booths=array();
		$Prabhags=array();
		if($IsCity!=-1)
		{
			$Booths=booth::where("Village_City_ID","=",$SelectedCity_Village)->get();
			$Prabhags=prabhag::where("Village_City_ID","=",$SelectedCity_Village)->get();
		}
		$data=array("pagetitle" => "  अपंग मतदारांचे मतदान  ","DefaultValue"=>$DefaultValue,"Districts"=>$Districts,"SelectDistrict"=>$DistrictID,"Tehsils"=>$Tehsils,"SelectedTehsil"=>$TehsilID,
			"IsCity"=>$IsCity,"Cities_Villages"=>$Cities_Villages,"SelectedCityOrVillage"=>$SelectedCity_Village,"Booths"=>$Booths,"Prabhags"=>$Prabhags);

		//$data=array("pagetitle" => " अपंग मतदारांचे मतदान  ","Districts"=>$Districts);
		return view('admin.report_by_handicaped_Voters',$data);
	}

	public function getVotersByHandicaped(Request $request)
	{
			$Village_CityID=$request->CorV_ID;
			$IsCity=$request->IsCity;
			$PrabhagId=$request->PrabhagId;
			$BoothId=$request->BoothId;
			$VotingAnalysis=$request->VotingAnalysis;
			$VotingStatus=$request->VotingStatus;
			$Voters=array();
			if($VotingAnalysis=="")
			{
				if($PrabhagId=="" && $BoothId=="" )
				{
					if($IsCity==0)
					{
						// Load Voters Surname from Village
						if($VotingStatus=="")
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID and tblvoters.IsHandicapped=1 order by MarathiLastName desc");
						}
						else
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvillage.VillageID=$Village_CityID and tblvoters.IsVoted=$VotingStatus and tblvoters.IsHandicapped=1 order by MarathiLastName desc");
						}
						
					}
					else if($IsCity==1)
					{
						// Load Voters Surnames From City
						if($VotingStatus=="")
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1  and tblbooth.Village_City_ID=$Village_CityID and tblvoters.IsHandicapped=1 order by MarathiLastName desc");
						}
						else
						{
							$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1  and tblbooth.Village_City_ID=$Village_CityID and tblvoters.IsVoted=$VotingStatus and tblvoters.IsHandicapped=1 order by MarathiLastName desc");
						}

					}
				}
				else if($BoothId!="" && $PrabhagId=="")
				{
					// Load Voters Surnames from Booth
					if($VotingStatus=="")
					{
						$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.IsHandicapped=1  order by MarathiLastName desc";						
					}
					else
					{
						$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.IsVoted=$VotingStatus and tblvoters.IsHandicapped=1 order by MarathiLastName desc";
					}
					
					$Voters=DB::select($Query);
				}
				else if($PrabhagId!="" && $BoothId=="" )
				{
					// Load Voters Surnames from Prabhag
					if($VotingStatus=="")
					{
						$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.IsHandicapped=1 order by MarathiLastName desc";
					}
					else
					{
						$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and and tblvoters.IsHandicapped=1 tblvoters.IsVoted=$VotingStatus order by MarathiLastName desc";
					}
					$Voters=DB::select($Query);
				}		
			}
			else{
					if($PrabhagId=="" && $BoothId=="" )
					{
						if($IsCity==0)
						{
							// Load Voters Surname from Village
							if($VotingStatus=="")
							{
								$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.VotingAnalysis='$VotingAnalysis' and tblvoters.IsHandicapped=1 and tblvillage.VillageID=$Village_CityID order by MarathiLastName desc");
							}
							else
							{
								$Voters=DB::select("select distinct * from tblbooth,tblvoters,tblvillage where tblvillage.VillageID=tblbooth.Village_City_ID and tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=0 and tblvoters.VotingAnalysis='$VotingAnalysis' and tblvoters.IsHandicapped=1 and tblvillage.VillageID=$Village_CityID and tblvoters.IsVoted=$VotingStatus order by MarathiLastName desc");
							}
							
						}
						else if($IsCity==1)
						{
							// Load Voters Surnames From City
							if($VotingStatus=="")
							{
								$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.VotingAnalysis='$VotingAnalysis' and tblbooth.Village_City_ID=$Village_CityID and tblvoters.IsHandicapped=1 order by MarathiLastName desc");
							}
							else
							{
								$Voters=DB::select("select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblbooth.IsCity=1 and tblvoters.VotingAnalysis='$VotingAnalysis' and tblbooth.Village_City_ID=$Village_CityID and  tblvoters.IsHandicapped=1 and tblvoters.IsVoted=$VotingStatus order by MarathiLastName desc");
							}
							
						}
					}
					else if($BoothId!="" && $PrabhagId=="")
					{
						// Load Voters Surnames from Booth
						if($VotingStatus=="")
						{
							$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.VotingAnalysis='$VotingAnalysis' and tblvoters.IsHandicapped=1 order by MarathiLastName desc";
						}
						else
						{
							$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.BoothID=$BoothId and tblvoters.VotingAnalysis='$VotingAnalysis' and tblvoters.IsVoted=$VotingStatus and tblvoters.IsHandicapped=1 order by MarathiLastName desc";
						}
						
						$Voters=DB::select($Query);
					}
					else if($PrabhagId!="" && $BoothId=="" )
					{
						// Load Voters Surnames from Prabhag
						if($VotingStatus=="")
						{
							$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' and tblvoters.VotingAnalysis='$VotingAnalysis' and tblvoters.IsHandicapped=1 order by MarathiLastName desc";
						}
						else
						{
							$Query="select distinct * from tblbooth,tblvoters where tblbooth.BoothID = tblvoters.BoothID and tblvoters.WardName='$PrabhagId' and tblvoters.VotingAnalysis='$VotingAnalysis' and tblvoters.IsHandicapped=1 and tblvoters.IsVoted=$VotingStatus order by MarathiLastName desc";							
						}
						
						$Voters=DB::select($Query);
					}				
			}

			//echo $Query;
			$Rply=array();
			$Reply=array();
			$i=0;
			foreach ($Voters as $key => $value) {
				$VotingAnalysis=$value->VotingAnalysis;
				if($VotingAnalysis=="इतर")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/08.png'></img>";
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/04.png'></img>";
					}
				}
				else if($VotingAnalysis=="आपला")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']=" <img src='theme/assets/images/icons/20pxl/06.png'></img>	 &nbsp;&nbsp;";					
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/02.png'></img>";
					}				
				}
				else if($VotingAnalysis=="विरोधी")			
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/05.png'></img> &nbsp;&nbsp;";	
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/01.png'></img>";
					}				
				}
				else if($VotingAnalysis=="संदिग्ध")
				{
					if($value->IsPoliticallyStrong==1)
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/07.png'></img>&nbsp;&nbsp; ";		
					}
					else
					{
						$Rply[$i]['VotingAnalysis']="<img src='theme/assets/images/icons/20pxl/03.png'></img>";
					}
				}

				$Rply[$i]['SrNo']=$value->SrNo;
				$Rply[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName ." ".$value->MarathiLastName;
				$Rply[$i]['MobileNumber']=$value->MobileNumber;
				$Rply[$i]['WhatsAppNumber']=$value->WhatsAppNumber;
				$Rply[$i]['Email']=$value->Email;
				$Rply[$i]['EPICNumber']=$value->EPICNumber;
				$Rply[$i]['VotingCenter']=$value->VotingCentre;
				$Rply[$i]['Address']=$value->Address;
				$Rply[$i]['NewAddress']=$value->NewAddress;
				$Rply[$i]['BoothNumber']=$value->BoothNumber;
				if($value->IsVoted==0)
				{
					$Rply[$i]['IsVoted']="नाही";
				}
				else if($value->IsVoted==1)
				{
					$Rply[$i]['IsVoted']="होय";
				}
				$Rply[$i]['View']="<a href='voter?VoterID=".$value->VoterID."' class='cg ts fx green' target='_blank'> <strong>View </strong></a>";
				$i++;
			}
			$Reply['aaData']=$Rply;
			echo json_encode($Reply);	
	}

	// Write Voters To Send SMS Details
	public function WriteSMSData(Request $request)
	{
		$VoterID=$request->VoterID;

		$VoterDetails=DB::select("select MarathiFirstName,MarathiMiddleName,MarathiLastName,MobileNumber from tblvoters where VoterID=$VoterID");

		//Storage::disk('local')->put('file.json', json_encode($VoterDetails));
		$Reply=array();
		foreach ($VoterDetails as $key => $value) {
			$Reply['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName." ".$value->MarathiLastName ;
			$Reply['MobileNumber']=$value->MobileNumber;
		}
		Storage::append('file.json', json_encode($Reply));
	}

	// This Sends SMS to App Users
	public function sendsmsui(Request $request)
	{
		$AppUsers_length=$request->AppUsers_length;
		$Apps=array();
		$AppUserDetails=array();$j=0;
		$MyApps=array();$j=0;
		for ($i=0; $i <$AppUsers_length; $i++) { 
			$id="_".$i;
			$AppUserID=$request->$id;
			if($AppUserID!=null)
			{
				$MyApps[$j]=$AppUserID;
				$j++;
			}
		}
		$k=0;
		for($i=0;$i<count($MyApps);$i++)
		{
			$AppUserID=$MyApps[$i];
			$AppUsers=androidapp::where("AppUserID","=",$AppUserID)->get();
			foreach ($AppUsers as $key => $value) {
				if(strlen($value->MobileNumber)==13 && substr($value->MobileNumber,0,3)=="+91")
				{
					$Mobile=substr($value->MobileNumber,3);
					if(ctype_digit($Mobile))
					{
						$Apps[$k]['Name']=$value->Name;
						$Apps[$k]['MobileNumber']=$Mobile;
						$k++;						
					}
				}
				if(strlen($value->MobileNumber)==12 && substr($value->MobileNumber,0,2)=="91")
				{
					if(ctype_digit($value->MobileNumber))
					{
						$Apps[$k]['Name']=$value->Name;
						$Apps[$k]['MobileNumber']=substr($value->MobileNumber,2);
						$k++;
					}
				}
				else if(strlen($value->MobileNumber)==11 && substr($value->MobileNumber,0,1)=="0")
				{
					if(ctype_digit($value->MobileNumber))
					{
						$Apps[$k]['Name']=$value->Name;
						$Apps[$k]['MobileNumber']=substr($value->MobileNumber,1);
						$k++;
					}
				}
				else if(strlen($value->MobileNumber)==10)
				{
					if(ctype_digit($value->MobileNumber))
					{
						$Apps[$k]['Name']=$value->Name;
						$Apps[$k]['MobileNumber']=$value->MobileNumber;
						$k++;
					}
				}
			}
		}
		$Response['aaData']=$Apps;
		$FileName=md5(uniqid(rand(), true)).".json";

		Storage::disk('local')->put($FileName, json_encode($Response));
		// Get Sender ID
		$Senders=DB::select("select SenderID from tblsenderids");

		$data=array("pagetitle" => " संदेश पाठवा  ","AppUserDetails"=>$Apps,"SenderIDs"=>$Senders,"File"=>$FileName);
		return view('admin.sendsmsui',$data);
	}

	public function sendsmsuiVoters(Request $request)
	{
		$VotersLength=$request->AssignedVoters_length;
		$Apps=array();
		$AppUserDetails=array();$j=0;
		$MyApps=array();$j=0;
		$APPMobile="";$AppName="";
		$APPUsersDetails=androidapp::where("AppUserID","=",$request->AppUserId)->get();
		foreach ($APPUsersDetails as $key => $vae) {
			$AppName=$vae->Name;
			$APPMobile=$vae->MobileNumber;
		}

		for ($i=0; $i <$VotersLength; $i++) { 
			$id="_".$i;
			$AppUserID=$request->$id;
			if($AppUserID!=null)
			{
				$MyApps[$j]=$AppUserID;
				$j++;
			}
		}
		$k=0;
		for($i=0;$i<count($MyApps);$i++)
		{
			$AppUserID=$MyApps[$i];
			$AppUsers=voter::where("VoterID","=",$AppUserID)->get();
			foreach ($AppUsers as $key => $value) {
				if(strlen($value->MobileNumber)==13 && substr($value->MobileNumber,0,3)=="+91")
				{
					$Mobile=substr($value->MobileNumber,3);
					if(ctype_digit($Mobile))
					{
						if(!in_array($Mobile, $Apps))
						{
							$Apps[$k]['Name']=$value->MarathiFirstName." ".$value->MarathiLastName;
							$Apps[$k]['MobileNumber']=$Mobile;
							$k++;													
						}
					}
				}
				if(strlen($value->MobileNumber)==12 && substr($value->MobileNumber,0,2)=="91")
				{
					if(ctype_digit($value->MobileNumber))
					{
						$Mobile=substr($value->MobileNumber,2);
						if(!in_array($Mobile, $Apps))
						{
							$Apps[$k]['Name']=$value->MarathiLastName." ".$value->MarathiFirstName;
							$Apps[$k]['MobileNumber']=$Mobile;
							$k++;													
						}
					}
				}
				else if(strlen($value->MobileNumber)==11 && substr($value->MobileNumber,0,1)=="0")
				{
					if(ctype_digit($value->MobileNumber))
					{
						$Mobile=substr($value->MobileNumber,1);
						if(!in_array($Mobile, $Apps))
						{
							$Apps[$k]['Name']=$value->MarathiLastName." ".$value->MarathiFirstName;
							$Apps[$k]['MobileNumber']=$Mobile;
							$k++;													
						}
					}
				}
				else if(strlen($value->MobileNumber)==10)
				{
					if(ctype_digit($value->MobileNumber))
					{
						$Mobile=$value->MobileNumber;
						if(!in_array($Mobile, $Apps))
						{
							$Apps[$k]['Name']=$value->MarathiLastName." ".$value->MarathiFirstName;
							$Apps[$k]['MobileNumber']=$Mobile;
							$k++;													
						}
					}
				}
			}
		}

		$ApUsers['Name']=$AppName;
		$ApUsers['MobileNumber']=$APPMobile;
		array_push($Apps, $ApUsers);
		$Response['aaData']=$Apps;
		$FileName=md5(uniqid(rand(), true)).".json";
		Storage::disk('local')->put($FileName, json_encode($Response));
		// Get Sender ID
		$Senders=DB::select("select SenderID from tblsenderids");

		$data=array("pagetitle" => " संदेश पाठवा  ","AppUserDetails"=>$Apps,"SenderIDs"=>$Senders,"File"=>$FileName);
		return view('admin.sendsmsui',$data);
	}

	public function getSMSMobileNumbers()
	{
		// Read File and put it into array
		$contents = Storage::get('file.json');
		$ContentsByLine=explode("\n", $contents);
		//print_r($ContentsByLine);
		$i=0;
		$VoterDetails=array();
		$Reply=array();$j=0;
		foreach ($ContentsByLine as $key => $value) {
			if($j>0)
			{
				if (!is_array($value)) {
					//echo $key . '=>' . $value . '<br/>';
					$Reply[$i]=json_decode($value,TRUE);
					$i++;
				}				
			}
			$j++;
			//foreach ($JSONArray as $key => $val) {
			//	echo $val->MarathiFirstName;
//				$VoterDetails[$i]['Name']=$value->MarathiFirstName." ".$value->MarathiMiddleName." ".$value->MarathiLastName;
//				$VoterDetails[$i]['MobileNumber']=$value->MobileNumber;
			//	$i++;
			//}
		}
		$Response['aaData']=$Reply;
		echo json_encode($Response);
	}

	public function Send_SMS(Request $request)
	{
		// Get Mobile Number Lists Array

		$SenderID=$request->SenderID;
		$MessageLanguage=$request->MessageLanguage;
		$Message=$request->Message;
		$File=$request->File;
		//$MobileCollection=Collection::make($MobileNumberArray);
		//Log::info("Request Cycle with Queues Starts");
		if($MessageLanguage==2)
		{
			$marathimessage=$Message;
			$newreplymessagemarathi=trim($marathimessage);
			$newreplymessagemarathihex=strtoupper(bin2hex(iconv('UTF-8', 'UCS-2', $newreplymessagemarathi)));
			$NewHexString="";
			$i=0;
			while($i<strlen($newreplymessagemarathihex))
			{
				$str1=substr($newreplymessagemarathihex,$i+2,2);
				$str2=substr($newreplymessagemarathihex,$i,2);
				$NewHexString=$NewHexString.$str2.$str1;
				$i=$i+4;
			}
			$Message=$NewHexString;
		}

		$exitCode = Artisan::call('queue:work'); //queue:work
		
//		Artisan::queue(' php artisan queue:listen --timeout=100 --tries=1');

		 Bus::dispatch(
		    new SendSMS($SenderID,$MessageLanguage,$Message,$File)
		 );
		//Artisan::call('queue:work');
        //Log::info("Request Cycle with Queues Ends");
        return redirect("/send-sms")->with("success"," SMS Sent ");
	}
}