<?php namespace App\Http\Controllers;

use App\state;// state model
use App\zone; // zone model

use Validator;

use illuminate\Http\Request;
use illuminate\Routing\Controllers;
class ZoneController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Welcome Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders the "marketing page" for the application and
	| is configured to only allow guests. Like most of the other sample
	| controllers, you are free to modify or remove it as you desire.
	|
	*/

	/**
	 * Show the application welcome screen to the user.
	 *
	 * @return Response
	 */
	public function index()
	{
	//	echo "this is My Admin Controller";
		$data=array("pagetitle" => "Add New Zone | Election Management System ");
		return view('admin.new-zone',$data);
	}

	public function edit()
	{
	//	echo "this is My Admin Controller";
		$data=array("pagetitle" => "Edit Zone | Election Management System | Sterling Systems");
		return view('admin.edit-zone',$data);
	}

	public function delete()
	{
	//	echo "this is My Admin Controller";
		$data=array("pagetitle" => "Delete Zone | Election Management System | Sterling Systems");
		return view('admin.delete-zone',$data);
	}

	public function getZoneNames(Request $request)
	{
		
		$validator= Validator::make(
			array(
				"States"=>$request->stateid
				),
			array(
				"States"=>"required",
				)
			);

		if($validator->fails())
		{
			//return redirect("/edit-state")->withErrors($validator)->withInput();
			return redirect()->intended($this->redirectPath())->withErrors($validator)->withInput();
		}
		else
		{
			$State=array();
			$Zones=zone::where('StateID', '=',$request->stateid)->get();

			echo json_encode($Zones);
		}
	}

}
