<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::get('/', 'AdminController@index');

Route::get('Login', 'AdminController@Login');
Route::post('LoginMe', 'AdminController@chklogin');

Route::get('logout','AdminController@logout');

Route::get('Forget-Password', 'ForgetController@index');
Route::get('SendPassword', 'ForgetController@SendPassword');

Route::get('ChangePassword', 'ForgetController@ChangePassword');
Route::get('ChangePWD', 'ForgetController@ChangePWD');

Route::group(['middleware' => 'auth'], function()
{
		// Send SMS To All AppUsers
	Route::get('Send_SMS_To_AppUsers', 'VoterController@Send_SMS_To_AppUsers');
	Route::get('Send_SMS_All_AppUsers', 'VoterController@Send_SMS_All_AppUsers');
	Route::get('GetMobileNumbersCount', 'VoterController@GetMobileNumbersCount');

	Route::get('Send_SMS_To_AppUsers_Birthday', 'VoterController@Send_SMS_To_AppUsers_Birthday');
	Route::get('Send_SMS_All_AppUsers_Birthday', 'VoterController@Send_SMS_All_AppUsers_Birthday');
	Route::get('GetMobileNumbersCountBirthday', 'VoterController@GetMobileNumbersCountBirthday');
	
	Route::get('Send_SMS_To_AppUsers_Voters', 'VoterController@Send_SMS_To_AppUsers_Voters');
	Route::get('Send_SMS_All_AppUsers_Voters', 'VoterController@Send_SMS_All_AppUsers_Voters');
	Route::get('GetMobileNumbersCountVoters', 'VoterController@GetMobileNumbersCountVoters');

	Route::get('SMS_Dashboard', 'VoterController@SMS_Dashboard');

	Route::get('Send_SMS_To_Voters', 'VoterController@Send_SMS_To_Voters');
	Route::get('GetVoterCountForAllInOne', 'VoterController@GetVoterCountForAllInOne');	
	Route::get('loadSurnamesOnCheck', 'VoterController@loadSurnamesOnCheck');	
	Route::get('SendSMSToVoterForAllInOne', 'VoterController@SendSMSToVoterForAllInOne');		
	
	Route::get('Send_Birthday_SMS_To_Voters', 'VoterController@Send_Birthday_SMS_To_Voters');		
	Route::get('GetVoterCountForAllInOneBirthday', 'VoterController@GetVoterCountForAllInOneBirthday');
	Route::get('SendSMSToVoterForAllInOneBirthday', 'VoterController@SendSMSToVoterForAllInOneBirthday');

	// Personal Message
	Route::get('PersonalMesagesToVoters', 'VoterController@PersonalMesagesToVoters');
	Route::get('SendIndividualSMSToNumbers', 'VoterController@SendIndividualSMSToNumbers');

	//  Voting Day SMS
	Route::get('SendVotingDaySMSToVoters', 'VoterController@SendVotingDaySMSToVoters');
	Route::get('GetVotersMobileCountVotingDay', 'VoterController@GetVotersMobileCountVotingDay');	
	Route::get('SendSMSToVotingStstusVoter', 'VoterController@SendSMSToVotingStstusVoter');		

	//VotingSlip
	Route::get('VotingSlip', 'VoterController@VotingSlip');	
	Route::get('GetVotersMobileCountForVotingSlip', 'VoterController@GetVotersMobileCountForVotingSlip');
	Route::get('SendVoterSlip', 'VoterController@SendVoterSlip');

	// Only authenticated users may enter...
	Route::get('dashboard', 'AdminController@dashboard');

	// Load Bar Graph Data
	Route::get('LoadBar','AdminController@LoadBar');

	// Get List of Surname and Count
	Route::get('LoadVotersCountBySurname','AdminController@LoadVotersCountBySurname');

	// Load Pie
	Route::get('LoadPie','AdminController@LoadPie');

	// Load Graphs By Android App Users
	Route::get('LoadAndroidAppUsersBar','AdminController@LoadAndroidAppUsersBar');
	// LoadCastPie

	Route::get('LoadCastPie','AdminController@LoadCastPie');

	// Education 
	Route::get('LoadEducationPie','AdminController@LoadEducationPie');	
	// Profession

	Route::get('LoadProfessionPie','AdminController@LoadProfessionPie');	
	// LoadVotingAnalysisPie
	Route::get('LoadVotingAnalysisPie','AdminController@LoadVotingAnalysisPie');

	Route::get('getCasts','CastController@getCasts');
	Route::get('InstantEditApp','AndroidAppController@InstantEditApp');
	
	// Load Default Values
	Route::get('default-values','AdminController@default_values');
	Route::get('ChangeDefaultValues','AdminController@ChangeDefaultValues');	

	Route::get('setting','AdminController@setting');
	
	// loadPrabhag
	Route::get('loadPrabhag','VoterController@loadPrabhag');
	// searchSurname
	Route::get('searchSurname','VoterController@searchSurname');

	// Routes for Voter
	Route::get('wizard', 'VoterController@wizard');

	Route::get('add-voter', 'VoterController@index');
	Route::get('edit-voter', 'VoterController@edit');
	Route::get('delete-voter', 'VoterController@delete');
	Route::get('report-voter', 'VoterController@report');

	Route::get('VotingDay', 'VoterController@VotingDay');

	// Instant Delete App
	Route::get('InstantDeleteApp', 'AndroidAppController@InstantDeleteApp');	

	// Edit Voter

	Route::get('EditVoter', 'VoterController@EditVoter');

	Route::get('getVotersByVillageOrCity', 'VoterController@getVotersByVillageOrCity');

	Route::get('InstantUpdateVoter', 'VoterController@InstantUpdateVoter');

	// Get voter details by id
	Route::get('getVoterDetailById', 'VoterController@getVoterDetailById');

	// Routes from Cast
	Route::get('new-cast', 'CastController@index');
	Route::get('edit-cast', 'CastController@edit');
	Route::get('delete-cast', 'CastController@delete');	

	Route::get('SaveCast', 'CastController@SaveCast');
	Route::get('EditCast','CastController@EditCast');
	Route::get('getCastNameById','CastController@getCastNameById');
	Route::get('DeleteCast','CastController@DeleteCast');

	// Routes for State

	Route::get('new-state', 'StateController@index');
	Route::get('edit-state', 'StateController@edit');
	Route::get('delete-state', 'StateController@delete');

	Route::get('getStateName', 'StateController@getStateName');
	Route::get('editState','StateController@editStateName'); // Edit State

	// All In 1
	Route::get('report', 'VoterController@report');

	Route::get('reportDemo', 'VoterController@reportDemo');
	// Display Voter Information
	
	Route::get('voter', 'VoterController@voter');

	Route::get('search', 'VoterController@search');

	// Report Dashboard
	Route::get('Report-Dashboard', 'VoterController@Report_Dashboard');
	
	// Voter Reporting (Individual)
	Route::get('report-by-seurnam', 'VoterController@report_by_seurnam');

	Route::get('report-by-politically-strong', 'VoterController@report_by_politically_strong');
	Route::get('getVotersPoliticalStatus', 'VoterController@getVotersPoliticalStatus');

	Route::get('report-by-booth-wise', 'VoterController@report_by_booth_wise');
	Route::get('getVotersByBooth','VoterController@getVotersByBooth');

	
	Route::get('report-by-handicaped','VoterController@report_by_handicaped');
	Route::get('getVotersByHandicaped','VoterController@getVotersByHandicaped');
	
	
	Route::get('report-by-voted-voters-by-appusers','AndroidAppController@report_by_voted_voters_by_appusers');
	Route::get('GetAppUsersVotedVoters','AndroidAppController@GetAppUsersVotedVoters');	

	Route::get('report-by-color', 'VoterController@report_by_color');		
	Route::get('getVotersByColor', 'VoterController@getVotersByColor');		

	Route::get('report-by-color-voting', 'VoterController@report_by_color2');		
	Route::get('getVotersByColorVoting', 'VoterController@getVotersByColor2');	

	Route::get('loadVotedVotersCount', 'VoterController@loadVotedVotersCount');

	Route::get('report-by-dead-voters', 'VoterController@report_by_dead_voters');
	Route::get('getVotersByDeadStatus', 'VoterController@getVotersByDeadStatus');		

	Route::get('report-by-voted-voters', 'VoterController@report_by_voted_voters');
	Route::get('getVotersByIsVotingStatus', 'VoterController@getVotersByIsVotingStatus');

	Route::get('report-by-mobile-number', 'VoterController@report_by_mobile_number');
	Route::get('getVotersByIsMobileNumbers', 'VoterController@getVotersByIsMobileNumbers');

	// Whatsapp Numbers
	Route::get('report-by-whatsapp-number', 'VoterController@report_by_whatsapp_number');
	Route::get('getVotersByIsWhatsappNumbers', 'VoterController@getVotersByIsWhatsappNumbers');	

	// Email
	Route::get('report-by-email', 'VoterController@report_by_email');
	Route::get('getVotersByEmail', 'VoterController@getVotersByEmail');

	// by Birthday
	Route::get('report-by-birthday', 'VoterController@report_by_birthday');
	Route::get('getVotersByBirthday', 'VoterController@getVotersByBirthday');

	// by Gender
	Route::get('report-by-gender', 'VoterController@report_by_gender');
	Route::get('getVotersByGender', 'VoterController@getVotersByGender');	

	// Address
	Route::get('report-by-address', 'VoterController@report_by_address');
	Route::get('getVotersByAddress', 'VoterController@getVotersByAddress');	

	Route::get('report-by-education', 'VoterController@report_by_education');
	Route::get('getVotersByEducation', 'VoterController@getVotersByEducation');	

	Route::get('report-by-cast', 'VoterController@report_by_cast');
	Route::get('getVotersByCast', 'VoterController@getVotersByCast');	

	Route::get('report-by-profession', 'VoterController@report_by_profession');
	Route::get('getVotersByProfession', 'VoterController@getVotersByProfession');	

	Route::get('report-by-age', 'VoterController@report_by_age');
	Route::get('getVotersByAge', 'VoterController@getVotersByAge');	

	// Get Voters Surnames By Villages Or Cities 
	Route::get('loadAvailableCitiesOrVillages','VoterController@loadAvailableCitiesOrVillages');

	// Get Cities or Villages Surnames
	Route::get('loadSurnames','VoterController@loadSurnames');	

	Route::get('SearchVoter','VoterController@SearchVoter');	
	Route::get('ShowVoters','VoterController@ShowVoters');

	Route::get('InstantAssignVoterToAppUser','VoterController@InstantAssignVoterToAppUser');
	
	// Android App 
	Route::get('add-new-app', 'AndroidAppController@add_new_app');

	Route::get('LoadTypes', 'AndroidAppController@LoadTypes');
	// Create App User
	Route::get('CreateAppUser', 'AndroidAppController@CreateAppUser');

	Route::get('edit-app', 'AndroidAppController@edit_app');
	// get App users by booth id	
	Route::get('getAppsOfBooth', 'AndroidAppController@getAppsOfBooth');
	// get All Android Apps From City Or Village
	Route::get('getAppsFromCityOrVillage', 'AndroidAppController@getAppsFromCityOrVillage');
	
	// get App Users by 
	Route::get('getAppDetailsById', 'AndroidAppController@getAppDetailsById');
	// Edit App User
	Route::get('EditAppUser', 'AndroidAppController@EditAppUser');	

	// Get Booth Id	
	Route::get('getBoothDetailsById', 'AndroidAppController@getBoothDetailsById');	

	// Delete Android App Users
	Route::get('delete-app', 'AndroidAppController@delete_android_app');

	// Delete App
	Route::get('DeleteApp', 'AndroidAppController@DeleteApp');

	Route::get('enable-app', 'AndroidAppController@enable_android_app');
	// Enable Android App
	Route::get('EnableApp', 'AndroidAppController@EnableApp');
	
	Route::get('disable-app', 'AndroidAppController@disable_android_app');
	// Disable App Users
	Route::get('DisableApp', 'AndroidAppController@DisableApp');

	// Voter Assignment For App
	Route::get('manage-app-voters', 'AndroidAppController@manage_app_voters');

	Route::get('update-password', 'AdminController@update_password');
	Route::get('update_password_user_password', 'AdminController@update_password_user_password');	

	// App Reports
	Route::get('app-reports', 'AndroidAppController@app_reports');
	// load app reports
	Route::get('APPReports', 'AndroidAppController@APPReports');
	// Android App Voters

	Route::get('SearchVoters', 'VoterController@SearchVoters');	

	Route::get('app-voters-reports', 'AndroidAppController@app_voters_reports');
	Route::get('GetAppVoters', 'AndroidAppController@GetAppVoters');

	// Get All Info of App StateName ,ZoneName, DistrictName,TehsilName, All City Or Village and Booth
	Route::get('GetAllInfoOfAppUser', 'AndroidAppController@GetAllInfoOfAppUser');

	Route::get('app-users-birthday-report', 'AndroidAppController@app_users_birthday_report');
	Route::get('GetAppUserBirthday', 'AndroidAppController@GetAppUserBirthday');

	Route::get('dashboard-android-app', 'AndroidAppController@android_app_users_dashboard');

	// Get Contacts of App User by Access Levels 
	Route::get('GetAllContactsByAppUser', 'AndroidAppController@GetAllContactsByAppUser');	
	// Get All Contacts Not Assigned To AppUsers
	Route::get('GetAllContactsNotAssignedToAppUsers', 'AndroidAppController@GetAllContactsNotAssignedToAppUsers');	
	//
	//Assign getVotersByVillageOrCity
	Route::get('AssignVoters','AndroidAppController@AssignVoters');
	// Remove Voters
	Route::get('RemoveVoters','AndroidAppController@RemoveVoters');

	// loadAvailableCitiesOrVillages
	Route::get('RemoveVoters','AndroidAppController@RemoveVoters');	

	// Remove App Voters
	
	Route::get('RemoveAppVoters','AndroidAppController@RemoveAppVoters');	
	// Routes for Zone

	Route::get('new-zone', 'ZoneController@index');
	Route::get('edit-zone', 'ZoneController@edit');
	Route::get('delete-zone', 'ZoneController@delete');

	// Get Zone Names by stateid

	Route::get('getZoneNames', 'ZoneController@getZoneNames');

	// Routes for District

	Route::get('new-district', 'DistrictController@index');
	Route::get('edit-district', 'DistrictController@edit');
	Route::get('delete-district', 'DistrictController@delete');

	// Get District Names by zoneid

	Route::get('getDistrictNames', 'DistrictController@getDistrictNames');
	// Routes for Tehsil

	Route::get('new-tehsil', 'TehsilController@index');
	Route::get('edit-tehsil', 'TehsilController@edit');
	Route::get('delete-tehsil', 'TehsilController@delete');

	// Get Tehsil by Districtid

	Route::get('getTehsilNames', 'TehsilController@getTehsilNames');
	// Routes for City

	Route::get('new-city', 'CityController@index');
	Route::get('edit-city', 'CityController@edit');
	Route::get('delete-city', 'CityController@delete');

	// Save City
	Route::get('SaveCity', 'CityController@SaveCity');
	//edit-city	
	Route::get('EditCity', 'CityController@EditCity');
	// delete City
	Route::get('DeleteCity', 'CityController@DeleteCity');	

	// Get City by Tehsil
	Route::get('getCityNames', 'CityController@getCityNames');
	// get City Name by Id
	Route::get('getCityNameById', 'CityController@getCityNameById');

	// Routes for Village

	Route::get('new-village', 'VillageController@index');
	Route::get('edit-village', 'VillageController@edit');
	Route::get('delete-village', 'VillageController@delete');

	// Save Village -SaveVillage
	Route::get('SaveVillage', 'VillageController@SaveVillage');
	// Get All Village Names by tehsil
	Route::get('getVillageNames', 'VillageController@getVillageNames');
	Route::get('getVillageNameById', 'VillageController@getVillageNameById');
	
	// Edit Village

	Route::get('EditVillage', 'VillageController@EditVillage');

	// Delete Village

	Route::get('DeleteVillage', 'VillageController@DeleteVillage');
	// Routes for Prabhag or ward

	Route::get('new-prabhag', 'PrabhagController@index');
	Route::get('edit-prabhag', 'PrabhagController@edit');
	Route::get('delete-prabhag', 'PrabhagController@delete');

	// Booth Routes
	Route::get('new-booth', 'BoothController@index');
	Route::get('edit-booth', 'BoothController@edit');
	Route::get('delete-booth', 'BoothController@delete');

	// Save Booth 
	Route::get('SaveBooth', 'BoothController@SaveBooth');
	// Get Booth Number by City or Village
	Route::get('getBoothsNumbersById', 'BoothController@getBoothsNumbersById');
	// Get Booth Name by Id 
	Route::get('getBoothNameById', 'BoothController@getBoothNameById');
	//EditBooth
	Route::get('EditBooth', 'BoothController@EditBooth');
	// Delete Booth
	Route::get('DeleteBooth', 'BoothController@DeleteBooth');

	// Prabhag
	Route::get('new-prabhag', 'PrabhagController@index');
	Route::get('edit-prabhag', 'PrabhagController@edit');
	Route::get('delete-prabhag', 'PrabhagController@delete');	
	Route::get('report-prabhag', 'PrabhagController@report');

	// Save Booth 
	Route::get('SavePrabhag', 'PrabhagController@SavePrabhag');
	
	// Get Booth Name by Id 
	Route::get('getPrabhagsByCityOrVillageId', 'PrabhagController@getPrabhagsByCityOrVillageId');
	// Get Prabhag Name By ID
	Route::get('getPrabhagNameById', 'PrabhagController@getPrabhagNameById');

	//EditBooth
	Route::get('EditPrabhag', 'PrabhagController@EditPrabhag');
	// Delete Booth
	Route::get('DeletePrabhag', 'PrabhagController@DeletePrabhag');	

	Route::get('WriteSMSData', 'VoterController@WriteSMSData');
	// Get SMS Mobile Numbers
	Route::get('getSMSMobileNumbers', 'VoterController@getSMSMobileNumbers');
	// Send SMS to Voters
	Route::get('send-sms', 'VoterController@sendsmsui');
	Route::get('send-sms-to-voters', 'VoterController@sendsmsuiVoters');
	Route::get('Send_SMS', 'VoterController@Send_SMS');

	//Send Birthday SMS 
	Route::get('ViewBirthdayAppUsers', 'VoterController@ViewBirthdayAppUsers');	
	Route::get('ViewBirthdayVoters', 'VoterController@ViewBirthdayVoters');


});